/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTrackerCustomizer;

final class BundleFinder
implements BundleTrackerCustomizer<List<Bundle>> {
    private final ConcurrentMap<String, List<Bundle>> trackedBundles = new ConcurrentHashMap<String, List<Bundle>>();

    BundleFinder() {
    }

    public Bundle findBundle(String symbolicName) {
        List bundlesWithSameSymName = (List)this.trackedBundles.get(symbolicName);
        if (bundlesWithSameSymName == null) {
            return null;
        }
        ArrayList<Bundle> snapshot = new ArrayList<Bundle>(bundlesWithSameSymName);
        switch (snapshot.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (Bundle)snapshot.get(0);
            }
        }
        snapshot.sort(VersionComperator.INSTANCE);
        return (Bundle)snapshot.get(0);
    }

    public List<Bundle> addingBundle(Bundle bundle, BundleEvent event) {
        String bundleSymName = bundle.getSymbolicName();
        if (bundleSymName == null) {
            return null;
        }
        List<Object> bundlesWithSameSymName = (CopyOnWriteArrayList<Bundle>)this.trackedBundles.get(bundleSymName);
        if (bundlesWithSameSymName == null && this.trackedBundles.putIfAbsent(bundleSymName, bundlesWithSameSymName = new CopyOnWriteArrayList<Bundle>()) != null) {
            bundlesWithSameSymName = (List)this.trackedBundles.get(bundleSymName);
        }
        bundlesWithSameSymName.add(bundle);
        return bundlesWithSameSymName;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, List<Bundle> bundlesWithSameSymName) {
    }

    public void removedBundle(Bundle bundle, BundleEvent event, List<Bundle> bundlesWithSameSymName) {
        bundlesWithSameSymName.remove(bundle);
    }

    private static final class VersionComperator
    implements Comparator<Bundle> {
        public static final Comparator<Bundle> INSTANCE = new VersionComperator();

        private VersionComperator() {
        }

        @Override
        public int compare(Bundle bundle1, Bundle bundle2) {
            if (bundle1 == null) {
                return bundle2 == null ? 0 : 1;
            }
            if (bundle2 == null) {
                return -1;
            }
            return bundle2.getVersion().compareTo(bundle1.getVersion());
        }
    }
}

