/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.palette;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteSeparator;
import org.eclipse.jface.resource.ImageDescriptor;

public class PaletteContainer
extends PaletteEntry {
    public static final String PROPERTY_CHILDREN = "Children Changed";
    protected List<PaletteEntry> children = new ArrayList<PaletteEntry>();

    protected PaletteContainer(String label, String desc, ImageDescriptor icon, Object type) {
        super(label, desc, icon, null, type);
    }

    public boolean acceptsType(Object type) {
        return true;
    }

    public void add(PaletteEntry entry) {
        this.add(-1, entry);
    }

    public void add(int index, PaletteEntry entry) {
        if (!this.acceptsType(entry.getType())) {
            throw new IllegalArgumentException("This container can not contain this type of child: " + String.valueOf(entry.getType()));
        }
        ArrayList<PaletteEntry> oldChildren = new ArrayList<PaletteEntry>(this.children);
        int actualIndex = index < 0 ? this.children.size() : index;
        this.children.add(actualIndex, entry);
        entry.setParent(this);
        this.listeners.firePropertyChange(PROPERTY_CHILDREN, oldChildren, this.children);
    }

    public void addAll(List<? extends PaletteEntry> list) {
        ArrayList<PaletteEntry> oldChildren = new ArrayList<PaletteEntry>(this.children);
        for (PaletteEntry paletteEntry : list) {
            if (!this.acceptsType(paletteEntry.getType())) {
                throw new IllegalArgumentException("This container can not contain this type of child: " + String.valueOf(paletteEntry.getType()));
            }
            this.children.add(paletteEntry);
            paletteEntry.setParent(this);
        }
        this.listeners.firePropertyChange(PROPERTY_CHILDREN, oldChildren, this.children);
    }

    public void appendToSection(String id, PaletteEntry entry) {
        boolean found = false;
        int i = 0;
        while (i < this.children.size()) {
            PaletteEntry currEntry = this.children.get(i);
            if (currEntry.getId().equals(id)) {
                found = true;
            } else if (found && currEntry instanceof PaletteSeparator) {
                this.add(i, entry);
                return;
            }
            ++i;
        }
        if (!found) {
            throw new IllegalArgumentException("Section not found: " + id);
        }
        this.add(entry);
    }

    public List<? extends PaletteEntry> getChildren() {
        return this.children;
    }

    private boolean move(PaletteEntry entry, boolean up) {
        int index = this.children.indexOf(entry);
        if (index < 0) {
            return false;
        }
        int n = index = up ? index - 1 : index + 1;
        if (index < 0 || index >= this.children.size()) {
            return false;
        }
        PaletteEntry paletteEntry = this.children.get(index);
        if (paletteEntry instanceof PaletteContainer) {
            PaletteContainer container = (PaletteContainer)paletteEntry;
            if (this.getUserModificationPermission() == 15 && container.acceptsType(entry.getType()) && container.getUserModificationPermission() == 15) {
                this.remove(entry);
                if (up) {
                    container.add(entry);
                } else {
                    container.add(0, entry);
                }
                return true;
            }
        }
        ArrayList<PaletteEntry> oldChildren = new ArrayList<PaletteEntry>(this.children);
        this.children.remove(entry);
        this.children.add(index, entry);
        this.listeners.firePropertyChange(PROPERTY_CHILDREN, oldChildren, this.children);
        return true;
    }

    public boolean moveDown(PaletteEntry entry) {
        return this.move(entry, false);
    }

    public boolean moveUp(PaletteEntry entry) {
        return this.move(entry, true);
    }

    public void remove(PaletteEntry entry) {
        ArrayList<PaletteEntry> oldChildren = new ArrayList<PaletteEntry>(this.children);
        if (this.children.remove(entry)) {
            entry.setParent(null);
            this.listeners.firePropertyChange(PROPERTY_CHILDREN, oldChildren, this.children);
        }
    }

    public void setChildren(List<PaletteEntry> list) {
        List<PaletteEntry> oldChildren = this.children;
        oldChildren.forEach(entry -> entry.setParent(null));
        this.children = list;
        this.children.forEach(entry -> entry.setParent(this));
        this.listeners.firePropertyChange(PROPERTY_CHILDREN, oldChildren, this.children);
    }

    @Override
    public String toString() {
        return "Palette Container (" + (this.getLabel() != null ? this.getLabel() : "") + ")";
    }
}

