/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op.transformation.grids;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class GridUtils {
    static String URL_PATH = "https://github.com/orbisgis/cts/raw/master/grids/";

    public static File findGrid(String nameGrid) throws FileNotFoundException, IOException {
        String ctsFolderPath = new File(System.getProperty("user.home")).getAbsolutePath() + File.separator + ".cts";
        File ctsFileFolder = new File(ctsFolderPath);
        File gridFile = new File(ctsFolderPath + File.separator + nameGrid);
        if (ctsFileFolder.exists()) {
            if (gridFile.exists()) {
                return gridFile;
            }
            if (ctsFileFolder.canWrite()) {
                GridUtils.downloadFile(gridFile, new URL(URL_PATH + nameGrid));
                return gridFile;
            }
            throw new IOException("Cannot download the grid : " + nameGrid + " into .cts folder");
        }
        boolean ctsDir = ctsFileFolder.mkdir();
        if (ctsDir && ctsFileFolder.canWrite()) {
            GridUtils.downloadFile(gridFile, new URL(URL_PATH + nameGrid));
            return gridFile;
        }
        throw new IOException("Unable to create the .cts folder");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFile(File outputFile, URL urlGrid) throws MalformedURLException, IOException {
        BufferedInputStream in = null;
        FileOutputStream fout = null;
        try {
            int count;
            in = new BufferedInputStream(urlGrid.openStream());
            fout = new FileOutputStream(outputFile);
            byte[] data = new byte[1024];
            while ((count = in.read(data, 0, 1024)) != -1) {
                fout.write(data, 0, count);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

