/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import java.io.Serializable;
import java.util.Iterator;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.create.table.ColumnDefinition;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.create.table.Index;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.util.deparser.AbstractDeParser;
import net.sf.jsqlparser.util.deparser.StatementDeParser;

public class CreateTableDeParser
extends AbstractDeParser<CreateTable> {
    private StatementDeParser statementDeParser;

    public CreateTableDeParser(StringBuilder buffer) {
        super(buffer);
    }

    public CreateTableDeParser(StatementDeParser statementDeParser, StringBuilder buffer) {
        super(buffer);
        this.statementDeParser = statementDeParser;
    }

    @Override
    public void deParse(CreateTable createTable) {
        String params;
        this.builder.append("CREATE ");
        if (createTable.isOrReplace()) {
            this.builder.append("OR REPLACE ");
        }
        if (createTable.isUnlogged()) {
            this.builder.append("UNLOGGED ");
        }
        if (!(params = PlainSelect.getStringList(createTable.getCreateOptionsStrings(), false, false)).isEmpty()) {
            this.builder.append(params).append(' ');
        }
        this.builder.append("TABLE ");
        if (createTable.isIfNotExists()) {
            this.builder.append("IF NOT EXISTS ");
        }
        this.builder.append(createTable.getTable().getFullyQualifiedName());
        if (createTable.getColumns() != null && !createTable.getColumns().isEmpty()) {
            this.builder.append(" (");
            Iterator<String> columnIterator = createTable.getColumns().iterator();
            this.builder.append(columnIterator.next());
            while (columnIterator.hasNext()) {
                this.builder.append(", ").append(columnIterator.next());
            }
            this.builder.append(")");
        }
        if (createTable.getColumnDefinitions() != null) {
            this.builder.append(" (");
            Iterator<Serializable> iter = createTable.getColumnDefinitions().iterator();
            while (iter.hasNext()) {
                ColumnDefinition columnDefinition = iter.next();
                this.builder.append(columnDefinition.getColumnName());
                this.builder.append(" ");
                this.builder.append(columnDefinition.getColDataType().toString());
                if (columnDefinition.getColumnSpecs() != null) {
                    for (String s : columnDefinition.getColumnSpecs()) {
                        this.builder.append(" ");
                        this.builder.append(s);
                    }
                }
                if (!iter.hasNext()) continue;
                this.builder.append(", ");
            }
            if (createTable.getIndexes() != null) {
                for (Index index : createTable.getIndexes()) {
                    this.builder.append(", ");
                    this.builder.append(index.toString());
                }
            }
            this.builder.append(")");
        }
        if (!"".equals(params = PlainSelect.getStringList(createTable.getTableOptionsStrings(), false, false))) {
            this.builder.append(' ').append(params);
        }
        if (createTable.getRowMovement() != null) {
            this.builder.append(' ').append(createTable.getRowMovement().getMode().toString()).append(" ROW MOVEMENT");
        }
        if (createTable.getSelect() != null) {
            this.builder.append(" AS ");
            if (createTable.isSelectParenthesis()) {
                this.builder.append("(");
            }
            Select sel = createTable.getSelect();
            sel.accept(this.statementDeParser, null);
            if (createTable.isSelectParenthesis()) {
                this.builder.append(")");
            }
        }
        if (createTable.getLikeTable() != null) {
            this.builder.append(" LIKE ");
            if (createTable.isSelectParenthesis()) {
                this.builder.append("(");
            }
            Table table = createTable.getLikeTable();
            this.builder.append(table.getFullyQualifiedName());
            if (createTable.isSelectParenthesis()) {
                this.builder.append(")");
            }
        }
        if (createTable.getSpannerInterleaveIn() != null) {
            this.builder.append(", ").append(createTable.getSpannerInterleaveIn());
        }
    }
}

