/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseReplication;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseReplicationModule;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.utils.ByteNumberFormat;

public class AltibaseReplicationSender
extends AltibaseReplicationModule {
    private long gapSizeInByte;
    private String startFlag;
    private boolean networkError;
    private long xsn;
    private long commitXsn;
    private String status;
    private long readLogCount;
    private long sentLogCount;

    public AltibaseReplicationSender(AltibaseReplication parent, JDBCResultSet resultSet) {
        super(parent);
        this.startFlag = this.getStartFlag(JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"START_FLAG"));
        this.networkError = JDBCUtils.safeGetBoolean((ResultSet)resultSet, (String)"NET_ERROR_FLAG", (String)"1");
        this.xsn = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"XSN");
        this.commitXsn = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"COMMIT_XSN");
        this.status = this.getStatus(JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"STATUS"));
        this.readLogCount = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"READ_LOG_COUNT");
        this.sentLogCount = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"SEND_LOG_COUNT");
        this.gapSizeInByte = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"GAP_SIZE_IN_BYTE");
    }

    @Override
    @Property(viewable=false, order=1, hidden=true)
    @NotNull
    public String getName() {
        return "Sender";
    }

    @Property(viewable=true, order=2, formatter=ByteNumberFormat.class)
    public long getGap() {
        return this.gapSizeInByte;
    }

    @Property(viewable=true, order=3)
    @NotNull
    public String getStartFlag() {
        return this.startFlag;
    }

    @Property(viewable=true, order=4)
    public boolean getNetworkError() {
        return this.networkError;
    }

    @Property(viewable=true, order=5)
    public long getXsn() {
        return this.xsn;
    }

    @Property(viewable=true, order=6)
    public long getCommitXsn() {
        return this.commitXsn;
    }

    @Property(viewable=true, order=7)
    @NotNull
    public String getStatus() {
        return this.status;
    }

    @Property(viewable=true, order=8)
    public long getReadLogCount() {
        return this.readLogCount;
    }

    @Property(viewable=true, order=9)
    public long getSentLogCount() {
        return this.sentLogCount;
    }

    public long getGapSizeInByte() {
        return this.gapSizeInByte;
    }

    private String getStartFlag(long value) {
        switch ((int)value) {
            case 0: {
                return "Normal";
            }
            case 1: {
                return "Quick";
            }
            case 2: {
                return "Sync";
            }
            case 3: {
                return "Sync Only";
            }
            case 4: {
                return "Sync Run";
            }
            case 5: {
                return "Sync End";
            }
            case 6: {
                return "Recovery";
            }
            case 7: {
                return "Offline";
            }
            case 8: {
                return "Parallel";
            }
        }
        return "Unknown";
    }

    private String getStatus(long value) {
        switch ((int)value) {
            case 0: {
                return "Stop";
            }
            case 1: {
                return "Run";
            }
            case 2: {
                return "Retry";
            }
            case 3: {
                return "Failback Normal";
            }
            case 4: {
                return "Failback Master";
            }
            case 5: {
                return "Failback Slave";
            }
            case 6: {
                return "Sync";
            }
            case 7: {
                return "Failback Eager";
            }
            case 8: {
                return "Failback Flush";
            }
            case 9: {
                return "Idle";
            }
        }
        return "Unknown";
    }
}

