/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.jarprocessor.unsigner;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Unsigner {
    private static final String META_INF = "META-INF";
    private static final String DSA_EXT = ".DSA";
    private static final String RSA_EXT = ".RSA";
    private static final String SF_EXT = ".SF";
    private static final String META_INF_PREFIX = "META-INF/";
    private String[] signers;
    private File jarFile;
    private boolean keepManifestContent = false;

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean isSigned(File file) {
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (ZipFile jar = new ZipFile(file);){
                if (this.signers != null) {
                    String[] stringArray = this.signers;
                    int n = this.signers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String signer = stringArray[n2];
                        if (jar.getEntry((META_INF_PREFIX + signer + SF_EXT).toUpperCase()) != null) {
                            return true;
                        }
                        ++n2;
                    }
                } else {
                    Enumeration<? extends ZipEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        String entryName = entry.getName();
                        if (!entryName.endsWith(SF_EXT) || !entryName.startsWith(META_INF)) continue;
                        return true;
                    }
                }
                return false;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ZipException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void execute() {
        this.processJar(this.jarFile);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processJar(File inputFile) {
        if (!this.isSigned(inputFile)) {
            return;
        }
        try {
            File outputFile;
            block21: {
                outputFile = File.createTempFile("removing.", ".signature", inputFile.getParentFile());
                Throwable throwable = null;
                Object var4_7 = null;
                try {
                    ZipInputStream input = new ZipInputStream(new BufferedInputStream(new FileInputStream(inputFile)));
                    try {
                        try (ZipOutputStream output = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile)));){
                            ZipEntry inputZe = input.getNextEntry();
                            while (inputZe != null) {
                                byte remove = this.shouldRemove(inputZe);
                                if (remove == 2) {
                                    inputZe = input.getNextEntry();
                                    continue;
                                }
                                if (remove == 1) {
                                    output.putNextEntry(new ZipEntry(inputZe.getName()));
                                    Manifest m = new Manifest();
                                    m.read(input);
                                    m.getEntries().clear();
                                    m.write(output);
                                } else {
                                    output.putNextEntry(inputZe);
                                    input.transferTo(output);
                                }
                                output.closeEntry();
                                input.closeEntry();
                                inputZe = input.getNextEntry();
                            }
                        }
                        if (input == null) break block21;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (input == null) throw throwable;
                        input.close();
                        throw throwable;
                    }
                    input.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            inputFile.delete();
            outputFile.renameTo(inputFile);
            return;
        }
        catch (FileNotFoundException outputFile) {
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private byte shouldRemove(ZipEntry entry) {
        String entryName = entry.getName();
        if (!this.keepManifestContent && entryName.equalsIgnoreCase("META-INF/MANIFEST.MF")) {
            return 1;
        }
        if (this.signers != null) {
            String[] stringArray = this.signers;
            int n = this.signers.length;
            int n2 = 0;
            while (n2 < n) {
                String signer = stringArray[n2];
                if (entryName.equalsIgnoreCase(META_INF_PREFIX + signer + SF_EXT) || entryName.equalsIgnoreCase(META_INF_PREFIX + signer + RSA_EXT) || entryName.equalsIgnoreCase(META_INF_PREFIX + signer + DSA_EXT)) {
                    return 2;
                }
                ++n2;
            }
        } else if (entryName.startsWith(META_INF) && (entryName.endsWith(SF_EXT) || entryName.endsWith(RSA_EXT) || entryName.endsWith(DSA_EXT))) {
            return 2;
        }
        return 0;
    }

    public void setRemoveSigners(String[] fileName) {
        this.signers = fileName;
    }

    public void setJar(File file) {
        this.jarFile = file;
    }

    public void setKeepManifestEntries(boolean keep) {
        this.keepManifestContent = keep;
    }
}

