﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/payment-cryptography-data/PaymentCryptographyData_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace PaymentCryptographyData
{
namespace Model
{

  /**
   * <p>Parameters that are required to generate or verify Dynamic Card Verification
   * Value (dCVV).</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-data-2022-02-03/DynamicCardVerificationCode">AWS
   * API Reference</a></p>
   */
  class DynamicCardVerificationCode
  {
  public:
    AWS_PAYMENTCRYPTOGRAPHYDATA_API DynamicCardVerificationCode() = default;
    AWS_PAYMENTCRYPTOGRAPHYDATA_API DynamicCardVerificationCode(Aws::Utils::Json::JsonView jsonValue);
    AWS_PAYMENTCRYPTOGRAPHYDATA_API DynamicCardVerificationCode& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_PAYMENTCRYPTOGRAPHYDATA_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>A random number generated by the issuer.</p>
     */
    inline const Aws::String& GetUnpredictableNumber() const { return m_unpredictableNumber; }
    inline bool UnpredictableNumberHasBeenSet() const { return m_unpredictableNumberHasBeenSet; }
    template<typename UnpredictableNumberT = Aws::String>
    void SetUnpredictableNumber(UnpredictableNumberT&& value) { m_unpredictableNumberHasBeenSet = true; m_unpredictableNumber = std::forward<UnpredictableNumberT>(value); }
    template<typename UnpredictableNumberT = Aws::String>
    DynamicCardVerificationCode& WithUnpredictableNumber(UnpredictableNumberT&& value) { SetUnpredictableNumber(std::forward<UnpredictableNumberT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>A number that identifies and differentiates payment cards with the same
     * Primary Account Number (PAN).</p>
     */
    inline const Aws::String& GetPanSequenceNumber() const { return m_panSequenceNumber; }
    inline bool PanSequenceNumberHasBeenSet() const { return m_panSequenceNumberHasBeenSet; }
    template<typename PanSequenceNumberT = Aws::String>
    void SetPanSequenceNumber(PanSequenceNumberT&& value) { m_panSequenceNumberHasBeenSet = true; m_panSequenceNumber = std::forward<PanSequenceNumberT>(value); }
    template<typename PanSequenceNumberT = Aws::String>
    DynamicCardVerificationCode& WithPanSequenceNumber(PanSequenceNumberT&& value) { SetPanSequenceNumber(std::forward<PanSequenceNumberT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The transaction counter value that comes from the terminal.</p>
     */
    inline const Aws::String& GetApplicationTransactionCounter() const { return m_applicationTransactionCounter; }
    inline bool ApplicationTransactionCounterHasBeenSet() const { return m_applicationTransactionCounterHasBeenSet; }
    template<typename ApplicationTransactionCounterT = Aws::String>
    void SetApplicationTransactionCounter(ApplicationTransactionCounterT&& value) { m_applicationTransactionCounterHasBeenSet = true; m_applicationTransactionCounter = std::forward<ApplicationTransactionCounterT>(value); }
    template<typename ApplicationTransactionCounterT = Aws::String>
    DynamicCardVerificationCode& WithApplicationTransactionCounter(ApplicationTransactionCounterT&& value) { SetApplicationTransactionCounter(std::forward<ApplicationTransactionCounterT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The data on the two tracks of magnetic cards used for financial transactions.
     * This includes the cardholder name, PAN, expiration date, bank ID (BIN) and
     * several other numbers the issuing bank uses to validate the data received.</p>
     */
    inline const Aws::String& GetTrackData() const { return m_trackData; }
    inline bool TrackDataHasBeenSet() const { return m_trackDataHasBeenSet; }
    template<typename TrackDataT = Aws::String>
    void SetTrackData(TrackDataT&& value) { m_trackDataHasBeenSet = true; m_trackData = std::forward<TrackDataT>(value); }
    template<typename TrackDataT = Aws::String>
    DynamicCardVerificationCode& WithTrackData(TrackDataT&& value) { SetTrackData(std::forward<TrackDataT>(value)); return *this;}
    ///@}
  private:

    Aws::String m_unpredictableNumber;
    bool m_unpredictableNumberHasBeenSet = false;

    Aws::String m_panSequenceNumber;
    bool m_panSequenceNumberHasBeenSet = false;

    Aws::String m_applicationTransactionCounter;
    bool m_applicationTransactionCounterHasBeenSet = false;

    Aws::String m_trackData;
    bool m_trackDataHasBeenSet = false;
  };

} // namespace Model
} // namespace PaymentCryptographyData
} // namespace Aws
