/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class Synchronizer {
    private final Lock lock = new ReentrantLock();

    public <T> T synchronize(Supplier<T> factory) {
        this.lock.lock();
        try {
            T t = factory.get();
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void synchronize(Runnable operation) {
        this.lock.lock();
        try {
            operation.run();
        }
        finally {
            this.lock.unlock();
        }
    }
}

