/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.properties.annotations;

import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Map;
import org.gradle.api.tasks.Nested;
import org.gradle.internal.properties.PropertyValue;
import org.gradle.internal.properties.PropertyVisitor;
import org.gradle.internal.properties.annotations.AbstractPropertyAnnotationHandler;
import org.gradle.internal.properties.annotations.NestedValidationUtil;
import org.gradle.internal.properties.annotations.PropertyAnnotationHandler;
import org.gradle.internal.properties.annotations.PropertyMetadata;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.internal.reflect.validation.TypeValidationContext;

public class NestedBeanAnnotationHandler
extends AbstractPropertyAnnotationHandler {
    public NestedBeanAnnotationHandler(Collection<Class<? extends Annotation>> allowedModifiers) {
        super(Nested.class, PropertyAnnotationHandler.Kind.OTHER, (ImmutableSet<Class<? extends Annotation>>)ImmutableSet.copyOf(allowedModifiers));
    }

    @Override
    public boolean isPropertyRelevant() {
        return true;
    }

    @Override
    public void visitPropertyValue(String propertyName, PropertyValue value, PropertyMetadata propertyMetadata, PropertyVisitor visitor) {
    }

    @Override
    public void validatePropertyMetadata(PropertyMetadata propertyMetadata, TypeValidationContext validationContext) {
        if (Map.class.isAssignableFrom(propertyMetadata.getDeclaredType().getRawType())) {
            Class keyType = JavaReflectionUtil.extractNestedType(propertyMetadata.getDeclaredType(), Map.class, (int)0).getRawType();
            NestedValidationUtil.validateKeyType(validationContext, propertyMetadata.getPropertyName(), keyType);
        }
    }
}

