/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.DataCollectorDebugLogger;
import com.intellij.internal.statistic.eventLog.DataCollectorSystemEventLogger;
import com.intellij.internal.statistic.eventLog.EventLogApplicationInfo;
import com.intellij.internal.statistic.eventLog.EventLogSystemCollector;
import com.intellij.internal.statistic.eventLog.InternalDataCollectorDebugLogger;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogProviderUtil;
import com.intellij.internal.statistic.eventLog.StatisticsRegionSettingsService;
import com.intellij.internal.statistic.eventLog.StatsAppConnectionSettings;
import com.intellij.internal.statistic.eventLog.connection.EventLogStatisticsService;
import com.intellij.internal.statistic.eventLog.connection.metadata.StatsConnectionSettings;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.EventLogMetadataSettingsPersistence;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class EventLogInternalApplicationInfo
implements EventLogApplicationInfo {
    public static final String EVENT_LOG_SETTINGS_REGION_CODE = "not_set";
    private static final DataCollectorDebugLogger LOG = new InternalDataCollectorDebugLogger(Logger.getInstance(EventLogStatisticsService.class));
    private final boolean myIsTestSendEndpoint;
    private final boolean myIsTestConfig;
    private final DataCollectorSystemEventLogger myEventLogger;
    private final StatsConnectionSettings myConnectionSettings;

    public EventLogInternalApplicationInfo(boolean isTestConfig, boolean isTestSendEndpoint) {
        this.myIsTestConfig = isTestConfig;
        this.myIsTestSendEndpoint = isTestSendEndpoint;
        this.myConnectionSettings = new StatsAppConnectionSettings();
        this.myEventLogger = new DataCollectorSystemEventLogger(this){

            @Override
            public void logLoadingConfigFailed(@NotNull String recorderId, @NotNull Throwable exception) {
                if (recorderId == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (exception == null) {
                    1.$$$reportNull$$$0(1);
                }
                EventLogSystemCollector eventLogSystemCollector = StatisticsEventLogProviderUtil.getEventLogProvider(recorderId).getEventLogSystemLogger$intellij_platform_statistics();
                eventLogSystemCollector.logLoadingConfigFailed(exception.getClass().getName(), -1L);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "recorderId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "exception";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/internal/statistic/eventLog/EventLogInternalApplicationInfo$1";
                objectArray[2] = "logLoadingConfigFailed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Override
    @NotNull
    public String getRegionalCode() {
        String regionCode = StatisticsRegionSettingsService.Companion.getInstance().getRegionCode();
        String string = regionCode == null ? EVENT_LOG_SETTINGS_REGION_CODE : regionCode;
        if (string == null) {
            EventLogInternalApplicationInfo.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getProductCode() {
        ApplicationInfoEx applicationInfo = ApplicationInfoEx.getInstanceEx();
        String fullIdeProductCode = applicationInfo.getFullIdeProductCode();
        String string = fullIdeProductCode != null ? fullIdeProductCode : applicationInfo.getBuild().getProductCode();
        if (string == null) {
            EventLogInternalApplicationInfo.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String getProductVersion() {
        ApplicationInfo info = ApplicationInfo.getInstance();
        String string = info.getMajorVersion() + "." + info.getMinorVersion();
        if (string == null) {
            EventLogInternalApplicationInfo.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public int getBaselineVersion() {
        ApplicationInfo info = ApplicationInfo.getInstance();
        return info.getBuild().getBaselineVersion();
    }

    @Override
    @NotNull
    public StatsConnectionSettings getConnectionSettings() {
        StatsConnectionSettings statsConnectionSettings = this.myConnectionSettings;
        if (statsConnectionSettings == null) {
            EventLogInternalApplicationInfo.$$$reportNull$$$0(3);
        }
        return statsConnectionSettings;
    }

    @Override
    public boolean isInternal() {
        return EventLogMetadataSettingsPersistence.getInstance().isInternal();
    }

    @Override
    public boolean isTestConfig() {
        return this.myIsTestConfig;
    }

    @Override
    public boolean isTestSendEndpoint() {
        return this.myIsTestSendEndpoint;
    }

    @Override
    public boolean isEAP() {
        return ApplicationManager.getApplication().isEAP();
    }

    @Override
    @NotNull
    public DataCollectorDebugLogger getLogger() {
        DataCollectorDebugLogger dataCollectorDebugLogger = LOG;
        if (dataCollectorDebugLogger == null) {
            EventLogInternalApplicationInfo.$$$reportNull$$$0(4);
        }
        return dataCollectorDebugLogger;
    }

    @Override
    @NotNull
    public DataCollectorSystemEventLogger getEventLogger() {
        DataCollectorSystemEventLogger dataCollectorSystemEventLogger = this.myEventLogger;
        if (dataCollectorSystemEventLogger == null) {
            EventLogInternalApplicationInfo.$$$reportNull$$$0(5);
        }
        return dataCollectorSystemEventLogger;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/internal/statistic/eventLog/EventLogInternalApplicationInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegionalCode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProductCode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProductVersion";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnectionSettings";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventLogger";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

