/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import { Pipe, PipeTransform } from '@angular/core';

@Pipe({
  name: 'highlightSearch',
  standalone: false,
})
export class HighlightSearchPipe implements PipeTransform {
  transform(value: string, search: string): string {
    const valueStr = String(value); // Ensure numeric values are converted to strings
    // (?![^&;]+;) - to ensure that there are no HTML entities (such as &amp; or &lt;)
    //               ex. value = "&lt;span&gt;" search = "span", The word 'span' will not be included in the matches
    // (?!<[^<>]*) - to ensure that there are no HTML tags (<...>)
    //               ex. value = "<span>" search = "span", The word 'span' will not be included in the matches
    return valueStr.replace(
      new RegExp('(?![^&;]+;)(?!<[^<>]*)(' + search + ')(?![^<>]*>)(?![^&;]+;)', 'gi'),
      '<strong>$1</strong>'
    );
  }
}
