/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.impl.action.osgi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.karaf.shell.impl.action.osgi.MultiServiceTracker;
import org.apache.karaf.shell.impl.action.osgi.SingleServiceTracker;
import org.osgi.framework.BundleContext;

public abstract class AggregateServiceTracker {
    private final BundleContext bundleContext;
    private final ConcurrentMap<Class, SingleServiceTracker> singleTrackers = new ConcurrentHashMap<Class, SingleServiceTracker>();
    private final ConcurrentMap<Class, MultiServiceTracker> multiTrackers = new ConcurrentHashMap<Class, MultiServiceTracker>();
    private final ConcurrentMap<Class, Boolean> optional = new ConcurrentHashMap<Class, Boolean>();
    private volatile State state = new State();
    private volatile boolean opening = true;

    public AggregateServiceTracker(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public <T> void trackList(final Class<T> service, String filter) {
        if (this.multiTrackers.get(service) == null) {
            MultiServiceTracker tracker = new MultiServiceTracker<T>(this.bundleContext, service, filter){

                @Override
                public void updateState(List<T> services) {
                    AggregateServiceTracker.this.updateStateMulti(service, services);
                }
            };
            this.multiTrackers.put(service, tracker);
        }
    }

    public <T> void trackSingle(final Class<T> service, boolean optional, String filter) {
        this.optional.merge(service, optional, Boolean::logicalAnd);
        if (this.singleTrackers.get(service) == null) {
            SingleServiceTracker tracker = new SingleServiceTracker<T>(this.bundleContext, service, filter){

                @Override
                public void updateState(T oldSvc, T newSvc) {
                    AggregateServiceTracker.this.updateStateSingle(service, newSvc);
                }
            };
            this.singleTrackers.putIfAbsent(service, tracker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State open() {
        State state;
        for (Object tracker : this.singleTrackers.values()) {
            ((SingleServiceTracker)tracker).open();
        }
        for (Object tracker : this.multiTrackers.values()) {
            ((MultiServiceTracker)tracker).open();
        }
        AggregateServiceTracker aggregateServiceTracker = this;
        synchronized (aggregateServiceTracker) {
            state = this.state;
            this.opening = false;
        }
        return state;
    }

    public void close() {
        this.updateState(null);
        for (Object tracker : this.multiTrackers.values()) {
            ((MultiServiceTracker)tracker).close();
        }
        for (Object tracker : this.singleTrackers.values()) {
            ((SingleServiceTracker)tracker).close();
        }
    }

    protected abstract void updateState(State var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void updateStateMulti(Class<T> serviceClass, List<T> services) {
        State newState = new State();
        AggregateServiceTracker aggregateServiceTracker = this;
        synchronized (aggregateServiceTracker) {
            newState.multi.putAll(this.state.multi);
            newState.single.putAll(this.state.single);
            newState.multi.put(serviceClass, services);
            this.state = newState;
        }
        this.updateState(newState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void updateStateSingle(Class<T> serviceClass, T service) {
        boolean opening;
        State newState = new State();
        AggregateServiceTracker aggregateServiceTracker = this;
        synchronized (aggregateServiceTracker) {
            newState.multi.putAll(this.state.multi);
            newState.single.putAll(this.state.single);
            if (service != null) {
                newState.single.put(serviceClass, service);
            } else {
                newState.single.remove(serviceClass);
            }
            this.state = newState;
            opening = this.opening;
        }
        if (!opening) {
            this.updateState(newState);
        }
    }

    public class State {
        private final Map<Class, List> multi = new HashMap<Class, List>();
        private final Map<Class, Object> single = new HashMap<Class, Object>();

        public boolean isSatisfied() {
            return AggregateServiceTracker.this.singleTrackers.keySet().stream().noneMatch(c -> (Boolean)AggregateServiceTracker.this.optional.get(c) == false && !this.single.containsKey(c));
        }

        public Map<Class, Object> getSingleServices() {
            return this.single;
        }

        public Map<Class, List> getMultiServices() {
            return this.multi;
        }

        public List<String> getMissingServices() {
            ArrayList<String> missing = new ArrayList<String>();
            for (SingleServiceTracker tracker : AggregateServiceTracker.this.singleTrackers.values()) {
                if (this.single.containsKey(tracker.getTrackedClass())) continue;
                missing.add(tracker.getTrackedClass().getName());
            }
            return missing;
        }
    }
}

