/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.log;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.log.LogFactory;

public class MultiLogFactory
implements LogFactory {
    private List<LogFactory> _delegates;

    public MultiLogFactory(LogFactory d1, LogFactory d2) {
        this(new LogFactory[]{d1, d2});
    }

    public MultiLogFactory(LogFactory d1, LogFactory d2, LogFactory d3) {
        this(new LogFactory[]{d1, d2, d3});
    }

    public MultiLogFactory(LogFactory[] delegates) {
        this._delegates = new CopyOnWriteArrayList<LogFactory>(Arrays.asList(delegates));
    }

    public void addLogFactory(LogFactory factory) {
        this._delegates.add(factory);
    }

    public void removeLogFactory(LogFactory factory) {
        this._delegates.remove(factory);
    }

    public LogFactory[] getDelegates() {
        return this._delegates.toArray(new LogFactory[this._delegates.size()]);
    }

    @Override
    public synchronized Log getLog(String channel) {
        ArrayList<Log> logs = new ArrayList<Log>(this._delegates.size());
        for (LogFactory f : this._delegates) {
            Log l;
            if (f == null || (l = f.getLog(channel)) == null) continue;
            logs.add(l);
        }
        return new MultiLog(logs.toArray(new Log[logs.size()]));
    }

    private static class MultiLog
    implements Log {
        private Log[] _logs;

        public MultiLog(Log[] logs) {
            this._logs = logs;
        }

        public Log[] getDelegates() {
            return this._logs;
        }

        @Override
        public void trace(Object msg) {
            for (Log log : this._logs) {
                log.trace(msg);
            }
        }

        @Override
        public void trace(Object msg, Throwable t) {
            for (Log log : this._logs) {
                log.trace(msg, t);
            }
        }

        @Override
        public void info(Object msg) {
            for (Log log : this._logs) {
                log.info(msg);
            }
        }

        @Override
        public void info(Object msg, Throwable t) {
            for (Log log : this._logs) {
                log.info(msg, t);
            }
        }

        @Override
        public void warn(Object msg) {
            for (Log log : this._logs) {
                log.warn(msg);
            }
        }

        @Override
        public void warn(Object msg, Throwable t) {
            for (Log log : this._logs) {
                log.warn(msg, t);
            }
        }

        @Override
        public void error(Object msg) {
            for (Log log : this._logs) {
                log.error(msg);
            }
        }

        @Override
        public void error(Object msg, Throwable t) {
            for (Log log : this._logs) {
                log.error(msg, t);
            }
        }

        @Override
        public void fatal(Object msg) {
            for (Log log : this._logs) {
                log.fatal(msg);
            }
        }

        @Override
        public void fatal(Object msg, Throwable t) {
            for (Log log : this._logs) {
                log.fatal(msg, t);
            }
        }

        @Override
        public boolean isTraceEnabled() {
            for (Log log : this._logs) {
                if (!log.isTraceEnabled()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isInfoEnabled() {
            for (Log log : this._logs) {
                if (!log.isInfoEnabled()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isWarnEnabled() {
            for (Log log : this._logs) {
                if (!log.isWarnEnabled()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isErrorEnabled() {
            for (Log log : this._logs) {
                if (!log.isErrorEnabled()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isFatalEnabled() {
            for (Log log : this._logs) {
                if (!log.isFatalEnabled()) continue;
                return true;
            }
            return false;
        }
    }
}

