/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.spi.impl;

import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.PersistenceUnit;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.myfaces.spi.impl.ResourceAnnotationInjectionProvider;

public class AllAnnotationInjectionProvider
extends ResourceAnnotationInjectionProvider {
    public AllAnnotationInjectionProvider(Context context) {
        super(context);
    }

    @Override
    protected void checkMethodAnnotation(Method method, Object instance) throws NamingException, IllegalAccessException, InvocationTargetException {
        Resource annotation;
        super.checkMethodAnnotation(method, instance);
        if (method.isAnnotationPresent(Resource.class)) {
            annotation = method.getAnnotation(Resource.class);
            AllAnnotationInjectionProvider.lookupMethodResource(this.context, instance, method, annotation.name());
        }
        if (method.isAnnotationPresent(EJB.class)) {
            annotation = method.getAnnotation(EJB.class);
            AllAnnotationInjectionProvider.lookupMethodResource(this.context, instance, method, annotation.name());
        }
        if (method.isAnnotationPresent(PersistenceContext.class)) {
            annotation = method.getAnnotation(PersistenceContext.class);
            AllAnnotationInjectionProvider.lookupMethodResource(this.context, instance, method, annotation.name());
        }
        if (method.isAnnotationPresent(PersistenceUnit.class)) {
            annotation = method.getAnnotation(PersistenceUnit.class);
            AllAnnotationInjectionProvider.lookupMethodResource(this.context, instance, method, annotation.name());
        }
    }

    @Override
    protected void checkFieldAnnotation(Field field, Object instance) throws NamingException, IllegalAccessException {
        EJB annotation;
        super.checkFieldAnnotation(field, instance);
        if (field.isAnnotationPresent(EJB.class)) {
            annotation = field.getAnnotation(EJB.class);
            AllAnnotationInjectionProvider.lookupFieldResource(this.context, instance, field, annotation.name());
        }
        if (field.isAnnotationPresent(PersistenceContext.class)) {
            annotation = field.getAnnotation(PersistenceContext.class);
            AllAnnotationInjectionProvider.lookupFieldResource(this.context, instance, field, annotation.name());
        }
        if (field.isAnnotationPresent(PersistenceUnit.class)) {
            annotation = field.getAnnotation(PersistenceUnit.class);
            AllAnnotationInjectionProvider.lookupFieldResource(this.context, instance, field, annotation.name());
        }
    }
}

