/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.logging.jul;

import java.io.OutputStream;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.SessionLogEntry;
import org.eclipse.persistence.logging.jul.EclipseLinkLogRecord;
import org.eclipse.persistence.logging.jul.LogFormatter;
import org.eclipse.persistence.sessions.Session;

public class JavaLog
extends AbstractSessionLog {
    public static final String TOPLINK_NAMESPACE = "org.eclipse.persistence";
    @Deprecated(forRemoval=true, since="4.0.9")
    protected static final String LOGGING_LOCALIZATION_STRING = "org.eclipse.persistence.internal.localization.i18n.LoggingLocalizationResource";
    @Deprecated(forRemoval=true, since="4.0.9")
    protected static final String TRACE_LOCALIZATION_STRING = "org.eclipse.persistence.internal.localization.i18n.TraceLocalizationResource";
    public static final String DEFAULT_TOPLINK_NAMESPACE = "org.eclipse.persistence.default";
    public static final String SESSION_TOPLINK_NAMESPACE = "org.eclipse.persistence.session";
    private static final Level[] levels = new Level[]{Level.ALL, Level.FINEST, Level.FINER, Level.FINE, Level.CONFIG, Level.INFO, Level.WARNING, Level.SEVERE, Level.OFF};
    private final Map<String, String> nameSpaceMap = new HashMap<String, String>();
    private String sessionNameSpace;
    private Logger sessionLogger;
    private final Map<String, Logger> categoryloggers = new HashMap<String, Logger>();

    public JavaLog() {
        this.addLogger(DEFAULT_TOPLINK_NAMESPACE, DEFAULT_TOPLINK_NAMESPACE);
    }

    protected void addLogger(String loggerCategory, String loggerNameSpace) {
        this.categoryloggers.put(loggerCategory, Logger.getLogger(loggerNameSpace));
    }

    public Map<String, Logger> getCategoryLoggers() {
        return this.categoryloggers;
    }

    @Override
    public int getLevel(String category) {
        Logger logger;
        for (logger = this.getLogger(category); logger != null && logger.getLevel() == null; logger = logger.getParent()) {
        }
        if (logger == null) {
            return 8;
        }
        int logLevel = logger.getLevel().intValue();
        for (int i = 0; i < levels.length; ++i) {
            if (logLevel != levels[i].intValue()) continue;
            return i;
        }
        return 8;
    }

    @Override
    public void setLevel(int level, String category) {
        Logger logger = this.getLogger(category);
        if (logger == null) {
            return;
        }
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(() -> {
                logger.setLevel(this.getJavaLevel(level));
                return null;
            });
        } else {
            logger.setLevel(this.getJavaLevel(level));
        }
    }

    @Override
    public void setWriter(OutputStream fileOutputStream) {
        StreamHandler sh = new StreamHandler(fileOutputStream, new LogFormatter());
        this.categoryloggers.get(DEFAULT_TOPLINK_NAMESPACE).addHandler(sh);
        if (this.sessionLogger != null) {
            this.sessionLogger.addHandler(sh);
        }
    }

    protected String getNameSpaceString(String category) {
        if (this.session == null && this.getSessionName() == null) {
            return DEFAULT_TOPLINK_NAMESPACE;
        }
        if (this.nameSpaceMap.isEmpty()) {
            this.initLoggers();
        }
        if (category == null || category.isEmpty()) {
            return this.sessionNameSpace;
        }
        return this.nameSpaceMap.get(category);
    }

    protected Logger getLogger(String category) {
        if (this.nameSpaceMap.isEmpty()) {
            this.initLoggers();
        }
        if (this.session == null && this.getSessionName() == null) {
            return this.categoryloggers.get(DEFAULT_TOPLINK_NAMESPACE);
        }
        if (category == null || category.isEmpty() || !this.categoryloggers.containsKey(category)) {
            return this.categoryloggers.get(this.sessionNameSpace);
        }
        Logger logger = this.categoryloggers.get(category);
        assert (logger != null);
        return logger;
    }

    @Override
    @Deprecated(forRemoval=true, since="4.0.9")
    public void setSession(Session session) {
        super.setSession(session);
        this.initLoggers();
    }

    private void initLoggers() {
        this.sessionNameSpace = this.getSessionName() != null ? "org.eclipse.persistence.session." + this.getSessionName() : DEFAULT_TOPLINK_NAMESPACE;
        this.addLogger(this.sessionNameSpace, this.sessionNameSpace);
        for (String loggerCategory : loggerCatagories) {
            String loggerNameSpace = this.sessionNameSpace + "." + loggerCategory;
            this.nameSpaceMap.put(loggerCategory, loggerNameSpace);
            this.addLogger(loggerCategory, loggerNameSpace);
        }
    }

    protected Level getJavaLevel(int level) {
        return levels[level];
    }

    @Override
    public boolean shouldLog(int level, String category) {
        if (this.nameSpaceMap.isEmpty()) {
            this.initLoggers();
        }
        Logger logger = this.getLogger(category);
        return logger.isLoggable(this.getJavaLevel(level));
    }

    @Override
    public void log(SessionLogEntry entry) {
        if (!this.shouldLog(entry.getLevel(), entry.getNameSpace())) {
            return;
        }
        Logger logger = this.getLogger(entry.getNameSpace());
        Level javaLevel = this.getJavaLevel(entry.getLevel());
        this.internalLog(entry, javaLevel, logger);
    }

    protected void internalLog(SessionLogEntry entry, Level javaLevel, Logger logger) {
        EclipseLinkLogRecord lr = new EclipseLinkLogRecord(javaLevel, this.formatMessage(entry));
        lr.setSourceClassName(entry.getSourceClassName());
        lr.setSourceMethodName(entry.getSourceMethodName());
        lr.setLoggerName(this.getNameSpaceString(entry.getNameSpace()));
        if (this.shouldPrintSession()) {
            lr.setSessionString(this.getSessionString(entry.getSession()));
        }
        if (this.shouldPrintConnection()) {
            lr.setConnectionId(entry.getConnectionId());
            lr.setConnection(entry.getConnection());
        }
        lr.setThrown(entry.getException());
        lr.setShouldLogExceptionStackTrace(this.shouldLogExceptionStackTrace());
        lr.setShouldPrintDate(this.shouldPrintDate());
        lr.setShouldPrintThread(this.shouldPrintThread());
        logger.log(lr);
    }

    @Override
    public void throwing(Throwable throwable) {
        this.getLogger(null).throwing(null, null, throwable);
    }

    @Override
    public Object clone() {
        JavaLog cloneLog = (JavaLog)super.clone();
        return cloneLog;
    }
}

