/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.httpclient;

import java.io.IOException;
import javax.annotation.Nonnull;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.slf4j.Logger;

public class RequestConnectionClose
implements HttpRequestInterceptor {
    @Nonnull
    static final Logger LOG = LoggerFactory.getLogger(RequestConnectionClose.class);

    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        LOG.trace("Saw negotiated protocol version: {}", (Object)context.getProtocolVersion());
        if (HttpVersion.HTTP_1_1.lessEquals(context.getProtocolVersion())) {
            LOG.trace("Adding request header '{}: {}'", (Object)"Connection", (Object)"close");
            request.addHeader("Connection", (Object)"close");
        } else {
            LOG.warn("Negotiated protocol did not match condition, skipping add of request header '{}: {}', may cause issues related to pooling", (Object)"Connection", (Object)"close");
        }
    }
}

