/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.apache.openejb.server.cxf.fault;

import jakarta.ejb.Stateless;
import jakarta.jws.HandlerChain;
import jakarta.jws.WebService;

/**
 * @version $Rev$
 */
@Stateless
@WebService(targetNamespace = "http://superbiz.org/wsdl")
@HandlerChain(file = "handler.xml")
public class AuthenticatorServiceBean implements AuthenticatorService {

    public boolean authenticate(String name, String password) throws WrongPasswordException {
        System.out.println(String.format("AuthenticatorServiceBean.authenticate(%s, %s)",
            name, password));
        throw new WrongPasswordException("Checked exception");
    }

    public boolean authenticateRuntime(String name, String password) {
        System.out.println(String.format("AuthenticatorServiceBean.authenticateRuntime(%s, %s)",
            name, password));
        throw new WrongPasswordRuntimeException("Runtime exception");
    }

}