/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.classloader;

import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.openejb.classloader.ClassLoaderConfigurer;

public class CompositeClassLoaderConfigurer
implements ClassLoaderConfigurer {
    private final ClassLoaderConfigurer[] composites;
    private final URL[] urls;

    public CompositeClassLoaderConfigurer(ClassLoaderConfigurer ... configurers) {
        this.composites = configurers;
        HashSet<URL> urlSet = new HashSet<URL>();
        for (ClassLoaderConfigurer configurer : configurers) {
            if (configurer == null) continue;
            urlSet.addAll(Arrays.asList(configurer.additionalURLs()));
        }
        this.urls = urlSet.toArray(new URL[urlSet.size()]);
    }

    @Override
    public URL[] additionalURLs() {
        return this.urls;
    }

    @Override
    public boolean accept(URL url) {
        for (ClassLoaderConfigurer configurer : this.composites) {
            if (configurer == null || configurer.accept(url)) continue;
            return false;
        }
        return true;
    }
}

