/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.finder.archive;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.CompositeArchive;
import org.apache.xbean.finder.archive.FileArchive;
import org.apache.xbean.finder.archive.JarArchive;

public class ClasspathArchive
extends CompositeArchive {
    private final List<URL> urls = new ArrayList<URL>();
    private final ClassLoader loader;

    public ClasspathArchive(ClassLoader loader, URL ... urls) {
        this(loader, Arrays.asList(urls));
    }

    public ClasspathArchive(ClassLoader loader, Iterable<URL> urls) {
        super(ClasspathArchive.archives(loader, urls));
        this.loader = loader;
    }

    public static List<Archive> archives(ClassLoader loader, Iterable<URL> urls) {
        ArrayList<Archive> archives = new ArrayList<Archive>();
        for (URL location : urls) {
            try {
                archives.add(ClasspathArchive.archive(loader, location));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return archives;
    }

    public static Archive archive(ClassLoader loader, URL location) {
        if (location.getProtocol().equals("jar")) {
            return new JarArchive(loader, location);
        }
        if (location.getProtocol().equals("file")) {
            try {
                URL jarUrl = new URL("jar", "", location.toExternalForm() + "!/");
                JarURLConnection juc = (JarURLConnection)jarUrl.openConnection();
                juc.getJarFile();
                return new JarArchive(loader, jarUrl);
            }
            catch (IOException e) {
                return new FileArchive(loader, location);
            }
        }
        throw new UnsupportedOperationException("unsupported archive type: " + location);
    }

    public static List<Archive> archives(ClassLoader loader, URL ... urls) {
        return ClasspathArchive.archives(loader, Arrays.asList(urls));
    }

    @Override
    public InputStream getBytecode(String className) throws IOException, ClassNotFoundException {
        URL resource;
        int pos = className.indexOf("<");
        if (pos > -1) {
            className = className.substring(0, pos);
        }
        if ((pos = className.indexOf(">")) > -1) {
            className = className.substring(0, pos);
        }
        if (!className.endsWith(".class")) {
            className = className.replace('.', '/') + ".class";
        }
        if ((resource = this.loader.getResource(className)) != null) {
            return resource.openStream();
        }
        throw new ClassNotFoundException(className);
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.loader.loadClass(className);
    }
}

