/*
 * Decompiled with CFR 0.152.
 */
package jakarta.enterprise.concurrent;

import jakarta.enterprise.util.Nonbinding;
import jakarta.interceptor.InterceptorBinding;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.concurrent.CompletableFuture;

@Documented
@Inherited
@InterceptorBinding
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD, ElementType.TYPE})
public @interface Asynchronous {
    @Nonbinding
    public String executor() default "java:comp/DefaultManagedExecutorService";

    public static final class Result {
        private static final ThreadLocal<CompletableFuture<?>> FUTURES = new ThreadLocal();

        private Result() {
        }

        public static <T> CompletableFuture<T> complete(T result) {
            CompletableFuture<?> future = FUTURES.get();
            if (future == null) {
                throw new IllegalStateException();
            }
            future.complete(result);
            return future;
        }

        public static <T> CompletableFuture<T> getFuture() {
            CompletableFuture<?> future = FUTURES.get();
            if (future == null) {
                throw new IllegalStateException();
            }
            return future;
        }

        public static <T> void setFuture(CompletableFuture<T> future) {
            if (future == null) {
                FUTURES.remove();
            } else {
                FUTURES.set(future);
            }
        }
    }
}

