/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ObjectFactory;
import org.apache.openejb.assembler.classic.WebAppBuilder;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.tomee.catalina.TomcatWebAppBuilder;

public class TomcatResourceFactory {
    private static final Logger LOGGER = Logger.getInstance((LogCategory)LogCategory.OPENEJB, TomcatResourceFactory.class);
    private String jndiName;
    private String appName;
    private String factory;
    private Reference reference;
    private CompositeName name;

    public void setJndiName(String jndiName) {
        try {
            this.name = new CompositeName(jndiName);
        }
        catch (InvalidNameException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setFactory(String factory) {
        this.factory = factory;
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object create() throws NamingException {
        TomcatWebAppBuilder.ContextInfo info = ((TomcatWebAppBuilder)SystemInstance.get().getComponent(WebAppBuilder.class)).getContextInfo(this.appName);
        if (info == null || info.standardContext == null) {
            return null;
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        ClassLoader tccl = info.standardContext.getLoader().getClassLoader();
        Thread.currentThread().setContextClassLoader(tccl);
        try {
            Object clazz;
            Object instance;
            if (this.factory != null && (instance = ((Class)(clazz = tccl.loadClass(this.factory))).newInstance()) instanceof ObjectFactory) {
                Object object = ((ObjectFactory)instance).getObjectInstance(this.reference, this.name, null, null);
                return object;
            }
            if (this.reference != null) {
                clazz = NamingManager.getObjectInstance(this.reference, this.name, null, null);
                return clazz;
            }
            try {
                throw new IllegalStateException("nothing to create the resource " + this.jndiName);
            }
            catch (Exception e) {
                LOGGER.error("Can't create resource " + this.jndiName, (Throwable)e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader);
        }
        return null;
    }
}

