/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.ivm;

public final class IntraVmCopyMonitor {
    private static final ThreadLocal<IntraVmCopyMonitor> threadMonitor = new ThreadLocal();
    private State state = State.NONE;

    private IntraVmCopyMonitor() {
    }

    public static boolean exists() {
        return threadMonitor.get() != null;
    }

    public static void release() {
        threadMonitor.set(null);
    }

    private static IntraVmCopyMonitor getMonitor() {
        IntraVmCopyMonitor monitor = threadMonitor.get();
        if (monitor == null) {
            monitor = new IntraVmCopyMonitor();
            threadMonitor.set(monitor);
        }
        return monitor;
    }

    public static void pre(State state) {
        IntraVmCopyMonitor.getMonitor().state = state;
    }

    public static void post() {
        IntraVmCopyMonitor.pre(State.NONE);
    }

    public static State state() {
        return IntraVmCopyMonitor.getMonitor().state;
    }

    public static void prePassivationOperation() {
        IntraVmCopyMonitor.pre(State.PASSIVATION);
    }

    public static void postPassivationOperation() {
        IntraVmCopyMonitor.post();
    }

    public static void preCrossClassLoaderOperation() {
        IntraVmCopyMonitor.pre(State.CLASSLOADER_COPY);
    }

    public static void postCrossClassLoaderOperation() {
        IntraVmCopyMonitor.post();
    }

    public static void preCopyOperation() {
        IntraVmCopyMonitor.pre(State.COPY);
    }

    public static void postCopyOperation() {
        IntraVmCopyMonitor.post();
    }

    public static boolean isIntraVmCopyOperation() {
        return IntraVmCopyMonitor.state() == State.COPY;
    }

    public static boolean isStatefulPassivationOperation() {
        return IntraVmCopyMonitor.state() == State.PASSIVATION;
    }

    public static boolean isCrossClassLoaderOperation() {
        return IntraVmCopyMonitor.state() == State.CLASSLOADER_COPY;
    }

    public static enum State {
        NONE,
        COPY(true),
        CLASSLOADER_COPY(true),
        PASSIVATION;

        private final boolean copy;

        private State() {
            this.copy = false;
        }

        private State(boolean copy) {
            this.copy = copy;
        }

        public boolean isCopy() {
            return this.copy;
        }
    }
}

