/*
 * Decompiled with CFR 0.152.
 */
package io.churchkey.ssh;

import io.churchkey.Key;
import io.churchkey.ssh.KeyInput;
import io.churchkey.ssh.OpenSSHPublicKey;
import io.churchkey.util.Pem;
import io.churchkey.util.Utils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;

public class SSH2Parser
implements Key.Format.Parser {
    @Override
    public Key decode(byte[] bytes) {
        if (!Utils.startsWith("---- BEGIN SSH2 PUBLIC KEY ----", bytes)) {
            return null;
        }
        Pem pem = Pem.parse(bytes);
        try {
            KeyInput reader = new KeyInput(pem.getData());
            String algorithm = reader.readString();
            if (algorithm.equals("ssh-rsa")) {
                PublicKey publicKey = OpenSSHPublicKey.RsaPublic.read(reader);
                return new Key((java.security.Key)publicKey, Key.Type.PUBLIC, Key.Algorithm.RSA, Key.Format.SSH2, pem.getAttributes());
            }
            if (algorithm.equals("ssh-dss")) {
                PublicKey publicKey = OpenSSHPublicKey.DsaPublic.read(reader);
                return new Key((java.security.Key)publicKey, Key.Type.PUBLIC, Key.Algorithm.DSA, Key.Format.SSH2, pem.getAttributes());
            }
            throw new UnsupportedOperationException("Unsupported key type: " + algorithm);
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public byte[] encode(Key key) {
        byte[] bytes;
        block6: {
            if (!Key.Type.PUBLIC.equals((Object)key.getType())) {
                throw new UnsupportedOperationException("SSH2 encoding only supported for public keys");
            }
            try {
                if (Key.Algorithm.RSA.equals((Object)key.getAlgorithm())) {
                    bytes = OpenSSHPublicKey.RsaPublic.write((RSAPublicKey)key.getKey());
                    break block6;
                }
                if (Key.Algorithm.DSA.equals((Object)key.getAlgorithm())) {
                    bytes = OpenSSHPublicKey.DsaPublic.write((DSAPublicKey)key.getKey());
                    break block6;
                }
                if (Key.Algorithm.EC.equals((Object)key.getAlgorithm())) {
                    ECPublicKey ecPublicKey = (ECPublicKey)key.getKey();
                    String curveName = OpenSSHPublicKey.EcPublic.curveName(ecPublicKey.getParams());
                    bytes = OpenSSHPublicKey.EcPublic.write(ecPublicKey, curveName);
                    break block6;
                }
                throw new UnsupportedOperationException("Unsupported key algorithm: " + (Object)((Object)key.getAlgorithm()));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return Pem.builder().data(bytes).attributes(key.getAttributes()).wrap(70).header("---- BEGIN SSH2 PUBLIC KEY ----").footer("---- END SSH2 PUBLIC KEY ----").format().getBytes();
    }
}

