/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;

public class OwbCustomObjectInputStream
extends ObjectInputStream {
    public static final BlacklistClassResolver BLACKLIST_CLASSES = new BlacklistClassResolver(OwbCustomObjectInputStream.toArray(System.getProperty("openwebbeans.serialization.class.blacklist", "org.codehaus.groovy.runtime.,org.apache.commons.collections.functors.,org.apache.xalan")), OwbCustomObjectInputStream.toArray(System.getProperty("openwebbeans.serialization.class.whitelist")));
    private ClassLoader classLoader;

    public OwbCustomObjectInputStream(InputStream in, ClassLoader classLoader) throws IOException {
        super(in);
        this.classLoader = classLoader;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws ClassNotFoundException {
        return Class.forName(BLACKLIST_CLASSES.check(desc.getName()), false, this.classLoader);
    }

    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        Class[] cinterfaces = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            cinterfaces[i] = Class.forName(interfaces[i], false, this.classLoader);
        }
        try {
            return Proxy.getProxyClass(this.classLoader, cinterfaces);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }

    private static String[] toArray(String property) {
        return property == null ? null : property.split(" *, *");
    }

    private static class BlacklistClassResolver {
        private final String[] blacklist;
        private final String[] whitelist;

        protected BlacklistClassResolver(String[] blacklist, String[] whitelist) {
            this.whitelist = whitelist;
            this.blacklist = blacklist;
        }

        protected boolean isBlacklisted(String name) {
            return this.whitelist != null && !BlacklistClassResolver.contains(this.whitelist, name) || BlacklistClassResolver.contains(this.blacklist, name);
        }

        public final String check(String name) {
            if (this.isBlacklisted(name)) {
                throw new SecurityException(name + " is not whitelisted as deserialisable, prevented before loading.");
            }
            return name;
        }

        private static boolean contains(String[] list, String name) {
            if (list != null) {
                for (String white : list) {
                    if (!name.startsWith(white)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

