/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import org.hsqldb.Constraint;
import org.hsqldb.Expression;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.rights.Grantee;
import org.hsqldb.types.Collation;
import org.hsqldb.types.Type;

public class UserTypeModifier {
    final HsqlNameManager.HsqlName name;
    final int schemaObjectType;
    final Type dataType;
    Constraint[] constraints = Constraint.emptyArray;
    Expression defaultExpression;
    boolean isNullable = true;

    public UserTypeModifier(HsqlNameManager.HsqlName hsqlName, int n, Type type) {
        this.name = hsqlName;
        this.schemaObjectType = n;
        this.dataType = type;
    }

    public int schemaObjectType() {
        return this.schemaObjectType;
    }

    public void addConstraint(Constraint constraint) {
        int n = this.constraints.length;
        this.constraints = (Constraint[])ArrayUtil.resizeArray(this.constraints, n + 1);
        this.constraints[n] = constraint;
        this.setNotNull();
    }

    public void removeConstraint(String string) {
        for (int i = 0; i < this.constraints.length; ++i) {
            if (!this.constraints[i].getName().name.equals(string)) continue;
            this.constraints = (Constraint[])ArrayUtil.toAdjustedArray(this.constraints, null, i, -1);
            break;
        }
        this.setNotNull();
    }

    public Constraint getConstraint(String string) {
        for (int i = 0; i < this.constraints.length; ++i) {
            if (!this.constraints[i].getName().name.equals(string)) continue;
            return this.constraints[i];
        }
        return null;
    }

    public Constraint[] getConstraints() {
        return this.constraints;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public Expression getDefaultClause() {
        return this.defaultExpression;
    }

    public void setDefaultClause(Expression expression) {
        this.defaultExpression = expression;
    }

    public void removeDefaultClause() {
        this.defaultExpression = null;
    }

    private void setNotNull() {
        this.isNullable = true;
        for (int i = 0; i < this.constraints.length; ++i) {
            if (!this.constraints[i].isNotNull()) continue;
            this.isNullable = false;
            break;
        }
    }

    public int getType() {
        return this.schemaObjectType;
    }

    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    public HsqlNameManager.HsqlName getSchemaName() {
        return this.name.schema;
    }

    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    public OrderedHashSet<HsqlNameManager.HsqlName> getReferences() {
        OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet = new OrderedHashSet<HsqlNameManager.HsqlName>();
        for (int i = 0; i < this.constraints.length; ++i) {
            OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet2 = this.constraints[i].getReferences();
            if (orderedHashSet2 == null) continue;
            orderedHashSet.addAll(orderedHashSet2);
        }
        Collation collation = this.dataType.getCollation();
        if (collation != null && collation.isObjectCollation()) {
            orderedHashSet.add(collation.getName());
        }
        return orderedHashSet;
    }

    public final OrderedHashSet<SchemaObject> getComponents() {
        OrderedHashSet<SchemaObject> orderedHashSet = new OrderedHashSet<SchemaObject>();
        if (this.constraints != null) {
            orderedHashSet.addAll((SchemaObject[])this.constraints);
        }
        return orderedHashSet;
    }

    public void compile(Session session) {
        for (int i = 0; i < this.constraints.length; ++i) {
            this.constraints[i].compile(session, null);
        }
    }

    public String getSQL() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.schemaObjectType == 12) {
            Collation collation;
            stringBuilder.append("CREATE").append(' ').append("TYPE").append(' ').append(this.name.getSchemaQualifiedStatementName()).append(' ').append("AS").append(' ').append(this.dataType.getDefinition());
            if (this.dataType.isCharacterType() && (collation = this.dataType.getCollation()).isObjectCollation()) {
                stringBuilder.append(' ').append(collation.getCollateSQL());
            }
        } else {
            Collation collation;
            stringBuilder.append("CREATE").append(' ').append("DOMAIN").append(' ').append(this.name.getSchemaQualifiedStatementName()).append(' ').append("AS").append(' ').append(this.dataType.getDefinition());
            if (this.dataType.isCharacterType() && (collation = this.dataType.getCollation()).isObjectCollation()) {
                stringBuilder.append(' ').append(collation.getCollateSQL());
            }
            if (this.defaultExpression != null) {
                stringBuilder.append(' ').append("DEFAULT").append(' ').append(this.defaultExpression.getSQL());
            }
            for (int i = 0; i < this.constraints.length; ++i) {
                stringBuilder.append(' ').append("CONSTRAINT").append(' ').append(this.constraints[i].getName().statementName).append(' ').append("CHECK").append('(').append(this.constraints[i].getCheckSQL()).append(')');
            }
        }
        return stringBuilder.toString();
    }
}

