/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rights;

import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Routine;
import org.hsqldb.SchemaObject;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.MultiValueHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.rights.GranteeManager;
import org.hsqldb.rights.Right;
import org.hsqldb.types.Type;

public class Grantee
implements SchemaObject {
    boolean isRole;
    private boolean isAdminDirect = false;
    private boolean isAdmin = false;
    boolean isPublic = false;
    boolean isSystem = false;
    protected HsqlNameManager.HsqlName granteeName;
    private MultiValueHashMap<HsqlNameManager.HsqlName, Right> directRightsMap;
    HashMap<HsqlNameManager.HsqlName, Right> fullRightsMap = new HashMap();
    OrderedHashSet<Grantee> roles;
    private MultiValueHashMap<HsqlNameManager.HsqlName, Right> grantedRightsMap;
    protected GranteeManager granteeManager;
    protected Right ownerRights;

    Grantee(HsqlNameManager.HsqlName hsqlName, GranteeManager granteeManager) {
        this.directRightsMap = new MultiValueHashMap();
        this.grantedRightsMap = new MultiValueHashMap();
        this.granteeName = hsqlName;
        this.granteeManager = granteeManager;
        this.roles = new OrderedHashSet();
        this.ownerRights = new Right();
        this.ownerRights.isFull = true;
        this.ownerRights.grantor = GranteeManager.systemAuthorisation;
        this.ownerRights.grantee = this;
    }

    @Override
    public int getType() {
        return 11;
    }

    @Override
    public HsqlNameManager.HsqlName getName() {
        return this.granteeName;
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        return null;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return null;
    }

    @Override
    public Grantee getOwner() {
        return null;
    }

    @Override
    public String getSQL() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("CREATE").append(' ').append("ROLE").append(' ').append(this.granteeName.statementName);
        return stringBuilder.toString();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    public boolean isRole() {
        return this.isRole;
    }

    public boolean isSystem() {
        return this.isSystem;
    }

    public OrderedHashSet<Grantee> getDirectRoles() {
        return this.roles;
    }

    public OrderedHashSet<Grantee> getDirectRolesWithPublic() {
        OrderedHashSet<Grantee> orderedHashSet = new OrderedHashSet<Grantee>();
        orderedHashSet.addAll(this.roles);
        orderedHashSet.add(this.granteeManager.publicRole);
        return orderedHashSet;
    }

    public OrderedHashSet<Grantee> getAllRoles() {
        OrderedHashSet<Grantee> orderedHashSet = this.getGranteeAndAllRoles();
        orderedHashSet.remove(this);
        return orderedHashSet;
    }

    public OrderedHashSet<Grantee> getGranteeAndAllRoles() {
        OrderedHashSet<Grantee> orderedHashSet = new OrderedHashSet<Grantee>();
        this.addGranteeAndRoles(orderedHashSet);
        return orderedHashSet;
    }

    public OrderedHashSet<Grantee> getGranteeAndAllRolesWithPublic() {
        OrderedHashSet<Grantee> orderedHashSet = new OrderedHashSet<Grantee>();
        this.addGranteeAndRoles(orderedHashSet);
        orderedHashSet.add(this.granteeManager.publicRole);
        return orderedHashSet;
    }

    public boolean isAccessible(HsqlNameManager.HsqlName hsqlName, int n) {
        if (this.isFullyAccessibleByRole(hsqlName)) {
            return true;
        }
        Right right = this.fullRightsMap.get((Object)hsqlName);
        if (right == null) {
            return false;
        }
        return right.canAccess(n);
    }

    public boolean isAccessible(SchemaObject schemaObject) {
        return this.isAccessible(schemaObject.getName());
    }

    public boolean isAccessible(HsqlNameManager.HsqlName hsqlName) {
        if (this.isFullyAccessibleByRole(hsqlName)) {
            return true;
        }
        Right right = this.fullRightsMap.get((Object)hsqlName);
        if (right != null && !right.isEmpty()) {
            return true;
        }
        if (!this.isPublic) {
            return this.granteeManager.publicRole.isAccessible(hsqlName);
        }
        return false;
    }

    private OrderedHashSet<Grantee> addGranteeAndRoles(OrderedHashSet<Grantee> orderedHashSet) {
        orderedHashSet.add(this);
        for (int i = 0; i < this.roles.size(); ++i) {
            Grantee grantee = this.roles.get(i);
            if (orderedHashSet.contains(grantee)) continue;
            grantee.addGranteeAndRoles(orderedHashSet);
        }
        return orderedHashSet;
    }

    private boolean hasRoleDirect(Grantee grantee) {
        return this.roles.contains(grantee);
    }

    public boolean hasRole(Grantee grantee) {
        return this.getAllRoles().contains(grantee);
    }

    private void grantToAll(HsqlNameManager.HsqlName hsqlName, Right right, Grantee grantee, boolean bl) {
        int n = 3;
        if (right.isFullUsage) {
            right = Right.fullRights;
            n = 7;
        } else if (right.isFullExecute) {
            right = Right.fullRights;
            n = 24;
        }
        Iterator<SchemaObject> iterator = this.granteeManager.database.schemaManager.databaseObjectIterator(hsqlName.name, n);
        while (iterator.hasNext()) {
            SchemaObject schemaObject = iterator.next();
            this.grant(schemaObject.getName(), right, grantee, bl);
        }
    }

    void grant(HsqlNameManager.HsqlName hsqlName, Right right, Grantee grantee, boolean bl) {
        if (hsqlName.type == 2) {
            this.grantToAll(hsqlName, right, grantee, bl);
            return;
        }
        Right right2 = grantee.getAllGrantableRights(hsqlName);
        Right right3 = null;
        if (right == Right.fullRights) {
            if (right2.isEmpty()) {
                return;
            }
            right = right2;
        } else if (!right2.contains(right)) {
            throw Error.error(2000);
        }
        Iterator<Right> iterator = this.directRightsMap.getValuesIterator(hsqlName);
        while (iterator.hasNext()) {
            Right right4 = iterator.next();
            if (right4.grantor != grantee) continue;
            right3 = right4;
            right3.add(right);
            break;
        }
        if (right3 == null) {
            right3 = right.duplicate();
            right3.grantor = grantee;
            right3.grantee = this;
            this.directRightsMap.put(hsqlName, right3);
        }
        if (bl) {
            if (right3.grantableRights == null) {
                right3.grantableRights = right.duplicate();
            } else {
                right3.grantableRights.add(right);
            }
        }
        if (!grantee.isSystem()) {
            grantee.grantedRightsMap.put(hsqlName, right3);
        }
        this.updateAllRights();
    }

    private void revokeFromAll(HsqlNameManager.HsqlName hsqlName, Right right, Grantee grantee, boolean bl) {
        int n = 3;
        if (right.isFullUsage) {
            right = Right.fullRights;
            n = 7;
        } else if (right.isFullExecute) {
            right = Right.fullRights;
            n = 24;
        }
        Iterator<SchemaObject> iterator = this.granteeManager.database.schemaManager.databaseObjectIterator(hsqlName.name, n);
        while (iterator.hasNext()) {
            SchemaObject schemaObject = iterator.next();
            this.revoke(schemaObject, right, grantee, bl);
        }
    }

    void revoke(SchemaObject schemaObject, Right right, Grantee grantee, boolean bl) {
        HsqlNameManager.HsqlName hsqlName = schemaObject.getName();
        if (hsqlName.type == 2) {
            this.revokeFromAll(hsqlName, right, grantee, bl);
            return;
        }
        if (schemaObject instanceof Routine) {
            hsqlName = ((Routine)schemaObject).getSpecificName();
        }
        Iterator<Right> iterator = this.directRightsMap.getValuesIterator(hsqlName);
        Right right2 = null;
        while (iterator.hasNext()) {
            right2 = iterator.next();
            if (right2.grantor != grantee) continue;
        }
        if (right2 == null) {
            return;
        }
        if (right2.grantableRights != null) {
            right2.grantableRights.remove(schemaObject, right);
        }
        if (bl) {
            return;
        }
        if (right.isFull) {
            this.directRightsMap.remove(hsqlName, right2);
            grantee.grantedRightsMap.remove(hsqlName, right2);
            this.updateAllRights();
            return;
        }
        right2.remove(schemaObject, right);
        if (right2.isEmpty()) {
            this.directRightsMap.remove(hsqlName, right2);
            grantee.grantedRightsMap.remove(hsqlName, right2);
        }
        this.updateAllRights();
    }

    void revokeDbObject(HsqlNameManager.HsqlName hsqlName) {
        this.directRightsMap.remove(hsqlName);
        this.grantedRightsMap.remove(hsqlName);
        this.fullRightsMap.remove(hsqlName);
    }

    void clearPrivileges() {
        this.roles.clear();
        this.directRightsMap.clear();
        this.grantedRightsMap.clear();
        this.fullRightsMap.clear();
        this.isAdmin = false;
    }

    public OrderedHashSet<HsqlNameManager.HsqlName> getColumnsForAllPrivileges(SchemaObject schemaObject) {
        if (schemaObject instanceof Table) {
            Table table = (Table)schemaObject;
            if (this.isFullyAccessibleByRole(table.getName())) {
                return table.getColumnNameSet();
            }
            Right right = this.fullRightsMap.get((Object)table.getName());
            return right == null ? new OrderedHashSet() : right.getColumnsForAllRights(table);
        }
        return new OrderedHashSet<HsqlNameManager.HsqlName>();
    }

    public OrderedHashSet<Right> getAllDirectPrivileges(SchemaObject schemaObject) {
        Iterator<Right> iterator;
        if (schemaObject.getOwner() == this) {
            OrderedHashSet<Right> orderedHashSet = new OrderedHashSet<Right>();
            orderedHashSet.add(this.ownerRights);
            return orderedHashSet;
        }
        HsqlNameManager.HsqlName hsqlName = schemaObject.getName();
        if (schemaObject instanceof Routine) {
            hsqlName = ((Routine)schemaObject).getSpecificName();
        }
        if ((iterator = this.directRightsMap.getValuesIterator(hsqlName)).hasNext()) {
            OrderedHashSet<Right> orderedHashSet = new OrderedHashSet<Right>();
            while (iterator.hasNext()) {
                orderedHashSet.add(iterator.next());
            }
            return orderedHashSet;
        }
        return Right.emptySet;
    }

    public OrderedHashSet<Right> getAllGrantedPrivileges(SchemaObject schemaObject) {
        Iterator<Right> iterator;
        HsqlNameManager.HsqlName hsqlName = schemaObject.getName();
        if (schemaObject instanceof Routine) {
            hsqlName = ((Routine)schemaObject).getSpecificName();
        }
        if ((iterator = this.grantedRightsMap.getValuesIterator(hsqlName)).hasNext()) {
            OrderedHashSet<Right> orderedHashSet = new OrderedHashSet<Right>();
            while (iterator.hasNext()) {
                orderedHashSet.add(iterator.next());
            }
            return orderedHashSet;
        }
        return Right.emptySet;
    }

    public Right checkSelect(SchemaObject schemaObject, boolean[] blArray) {
        if (schemaObject instanceof Table) {
            Table table = (Table)schemaObject;
            if (this.isFullyAccessibleByRole(table.getName())) {
                return Right.fullRights;
            }
            Right right = this.fullRightsMap.get((Object)table.getName());
            if (right != null && right.canSelect(table, blArray)) {
                return right;
            }
        }
        throw Error.error(5501, schemaObject.getName().name);
    }

    public Right checkInsert(SchemaObject schemaObject, boolean[] blArray) {
        if (schemaObject instanceof Table) {
            Table table = (Table)schemaObject;
            if (this.isFullyAccessibleByRole(table.getName())) {
                return Right.fullRights;
            }
            Right right = this.fullRightsMap.get((Object)table.getName());
            if (right != null && right.canInsert(table, blArray)) {
                return right;
            }
        }
        throw Error.error(5501, schemaObject.getName().name);
    }

    public Right checkUpdate(SchemaObject schemaObject, boolean[] blArray) {
        if (schemaObject instanceof Table) {
            Table table = (Table)schemaObject;
            if (this.isFullyAccessibleByRole(table.getName())) {
                return Right.fullRights;
            }
            Right right = this.fullRightsMap.get((Object)table.getName());
            if (right != null && right.canUpdate(table, blArray)) {
                return right;
            }
        }
        throw Error.error(5501, schemaObject.getName().name);
    }

    public Right checkReferences(SchemaObject schemaObject, boolean[] blArray) {
        if (schemaObject instanceof Table) {
            Table table = (Table)schemaObject;
            if (this.isFullyAccessibleByRole(table.getName())) {
                return Right.fullRights;
            }
            Right right = this.fullRightsMap.get((Object)table.getName());
            if (right != null && right.canReference(table, blArray)) {
                return right;
            }
        }
        throw Error.error(5501, schemaObject.getName().name);
    }

    public Right checkTrigger(SchemaObject schemaObject, boolean[] blArray) {
        if (schemaObject instanceof Table) {
            Table table = (Table)schemaObject;
            if (this.isFullyAccessibleByRole(table.getName())) {
                return Right.fullRights;
            }
            Right right = this.fullRightsMap.get((Object)table.getName());
            if (right != null && right.canReference(table, blArray)) {
                return right;
            }
        }
        throw Error.error(5501, schemaObject.getName().name);
    }

    public Right checkDelete(SchemaObject schemaObject) {
        if (schemaObject instanceof Table) {
            Table table = (Table)schemaObject;
            if (this.isFullyAccessibleByRole(table.getName())) {
                return Right.fullRights;
            }
            Right right = this.fullRightsMap.get((Object)table.getName());
            if (right != null && right.canDelete()) {
                return right;
            }
        }
        throw Error.error(5501, schemaObject.getName().name);
    }

    public Right checkAccess(SchemaObject schemaObject) {
        Right right;
        if (this.isFullyAccessibleByRole(schemaObject.getName())) {
            return Right.fullRights;
        }
        HsqlNameManager.HsqlName hsqlName = schemaObject.getName();
        if (schemaObject instanceof Routine) {
            hsqlName = ((Routine)schemaObject).getSpecificName();
        }
        if ((right = this.fullRightsMap.get((Object)hsqlName)) != null && !right.isEmpty()) {
            return right;
        }
        throw Error.error(5501, schemaObject.getName().name);
    }

    public void checkSchemaUpdateOrGrantRights(HsqlNameManager.HsqlName hsqlName) {
        if (!this.hasSchemaUpdateOrGrantRights(hsqlName)) {
            throw Error.error(5501, hsqlName.name);
        }
    }

    public boolean hasSchemaUpdateOrGrantRights(HsqlNameManager.HsqlName hsqlName) {
        if (this.isAdmin()) {
            return true;
        }
        Grantee grantee = this.granteeManager.database.schemaManager.toSchemaOwner(hsqlName.name);
        if (grantee == this) {
            return true;
        }
        return this.hasRole(grantee);
    }

    public boolean isGrantable(SchemaObject schemaObject, Right right) {
        if (this.isFullyAccessibleByRole(schemaObject.getName())) {
            return true;
        }
        Right right2 = this.getAllGrantableRights(schemaObject.getName());
        return right2.contains(right);
    }

    public boolean isGrantable(Grantee grantee) {
        return this.isAdmin;
    }

    public boolean isFullyAccessibleByRole(HsqlNameManager.HsqlName hsqlName) {
        Grantee grantee;
        if (this.isAdmin) {
            return true;
        }
        if (hsqlName.type == 2) {
            grantee = hsqlName.owner;
        } else {
            if (hsqlName.schema == null) {
                return false;
            }
            grantee = hsqlName.schema.owner;
        }
        if (grantee == this) {
            return true;
        }
        return this.hasRole(grantee);
    }

    public void checkAdmin() {
        if (!this.isAdmin()) {
            throw Error.error(5507);
        }
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public boolean isSchemaCreator() {
        return this.isAdmin || this.hasRole(this.granteeManager.schemaRole);
    }

    public boolean canChangeAuthorisation() {
        return this.isAdmin || this.hasRole(this.granteeManager.changeAuthRole);
    }

    public boolean canPerformScriptOps() {
        return this.isAdmin || this.hasRole(this.granteeManager.scriptOpsRole);
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public OrderedHashSet<Grantee> visibleGrantees() {
        OrderedHashSet<Grantee> orderedHashSet = new OrderedHashSet<Grantee>();
        GranteeManager granteeManager = this.granteeManager;
        if (this.isAdmin()) {
            orderedHashSet.addAll(granteeManager.getGrantees());
        } else {
            orderedHashSet.add(this);
            Iterator iterator = this.getAllRoles().iterator();
            while (iterator.hasNext()) {
                orderedHashSet.add((Grantee)iterator.next());
            }
        }
        return orderedHashSet;
    }

    public boolean hasNonSelectTableRight(SchemaObject schemaObject) {
        if (this.isFullyAccessibleByRole(schemaObject.getName())) {
            return true;
        }
        Right right = this.fullRightsMap.get((Object)schemaObject.getName());
        if (right == null) {
            return false;
        }
        return right.canAccessNonSelect();
    }

    public boolean hasColumnRights(SchemaObject schemaObject, int[] nArray) {
        if (this.isFullyAccessibleByRole(schemaObject.getName())) {
            return true;
        }
        Right right = this.fullRightsMap.get((Object)schemaObject.getName());
        if (right == null) {
            return false;
        }
        return right.canAccess((Table)schemaObject, nArray);
    }

    void setAdminDirect() {
        this.isAdminDirect = true;
        this.isAdmin = true;
    }

    boolean updateNestedRoles(Grantee grantee) {
        boolean bl = false;
        if (grantee != this) {
            for (int i = 0; i < this.roles.size(); ++i) {
                Grantee grantee2 = this.roles.get(i);
                bl |= grantee2.updateNestedRoles(grantee);
            }
        }
        if (bl) {
            this.updateAllRights();
        }
        return bl || grantee == this;
    }

    void updateAllRights() {
        this.fullRightsMap.clear();
        this.isAdmin = this.isAdminDirect;
        for (int i = 0; i < this.roles.size(); ++i) {
            Grantee grantee = this.roles.get(i);
            this.addToFullRights(grantee.fullRightsMap);
            this.isAdmin |= grantee.isAdmin();
        }
        this.addToFullRights(this.directRightsMap);
        if (!(this.isRole || this.isPublic || this.isSystem)) {
            this.addToFullRights(this.granteeManager.publicRole.fullRightsMap);
        }
    }

    void addToFullRights(HashMap<HsqlNameManager.HsqlName, Right> hashMap) {
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)iterator.next();
            Right right = hashMap.get((Object)hsqlName);
            Right right2 = this.fullRightsMap.get((Object)hsqlName);
            if (right2 == null) {
                right2 = right.duplicate();
                this.fullRightsMap.put(hsqlName, right2);
            } else {
                right2.add(right);
            }
            if (right.grantableRights == null) continue;
            if (right2.grantableRights == null) {
                right2.grantableRights = right.grantableRights.duplicate();
                continue;
            }
            right2.grantableRights.add(right.grantableRights);
        }
    }

    private void addToFullRights(MultiValueHashMap<HsqlNameManager.HsqlName, Right> multiValueHashMap) {
        Iterator iterator = multiValueHashMap.keySet().iterator();
        while (iterator.hasNext()) {
            HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)iterator.next();
            Iterator<Right> iterator2 = multiValueHashMap.getValuesIterator(hsqlName);
            Right right = this.fullRightsMap.get((Object)hsqlName);
            while (iterator2.hasNext()) {
                Right right2 = iterator2.next();
                if (right == null) {
                    right = right2.duplicate();
                    this.fullRightsMap.put(hsqlName, right);
                } else {
                    right.add(right2);
                }
                if (right2.grantableRights == null) continue;
                if (right.grantableRights == null) {
                    right.grantableRights = right2.grantableRights.duplicate();
                    continue;
                }
                right.grantableRights.add(right2.grantableRights);
            }
        }
    }

    Right getAllGrantableRights(HsqlNameManager.HsqlName hsqlName) {
        if (this.isAdmin) {
            return hsqlName.schema.owner.ownerRights;
        }
        if (hsqlName.schema.owner == this) {
            return this.ownerRights;
        }
        if (this.roles.contains(hsqlName.schema.owner)) {
            return hsqlName.schema.owner.ownerRights;
        }
        OrderedHashSet<Grantee> orderedHashSet = this.getAllRoles();
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            Grantee grantee = orderedHashSet.get(i);
            if (hsqlName.schema.owner != grantee) continue;
            return grantee.ownerRights;
        }
        Right right = this.fullRightsMap.get((Object)hsqlName);
        return right == null || right.grantableRights == null ? Right.noRights : right.grantableRights;
    }

    private MultiValueHashMap<HsqlNameManager.HsqlName, Right> getRights() {
        return this.directRightsMap;
    }

    void grant(Grantee grantee) {
        this.roles.add(grantee);
    }

    void revoke(Grantee grantee) {
        if (!this.hasRoleDirect(grantee)) {
            throw Error.error(2253, grantee.getName().getNameString());
        }
        this.roles.remove(grantee);
    }

    private String roleMapToString(OrderedHashSet<Grantee> orderedHashSet) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            Grantee grantee = orderedHashSet.get(i);
            stringBuilder.append(grantee.getName().getStatementName());
        }
        return stringBuilder.toString();
    }

    HsqlArrayList<String> getRightsSQL() {
        Object object;
        HsqlArrayList<String> hsqlArrayList = new HsqlArrayList<String>();
        String string = this.roleMapToString(this.roles);
        if (!string.isEmpty()) {
            object = new StringBuilder(64);
            ((StringBuilder)object).append("GRANT").append(' ').append(string).append(' ').append("TO").append(' ').append(this.getName().getStatementName());
            hsqlArrayList.add(((StringBuilder)object).toString());
        }
        object = this.getRights();
        Iterator iterator = ((MultiValueHashMap)object).keySet().iterator();
        while (iterator.hasNext()) {
            HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)iterator.next();
            Iterator iterator2 = ((MultiValueHashMap)object).getValuesIterator(hsqlName);
            while (iterator2.hasNext()) {
                Right right = (Right)iterator2.next();
                StringBuilder stringBuilder = new StringBuilder(128);
                switch (hsqlName.type) {
                    case 3: 
                    case 4: {
                        Table table = this.granteeManager.database.schemaManager.findUserTable(hsqlName.name, hsqlName.schema.name);
                        if (table == null) break;
                        stringBuilder.append("GRANT").append(' ').append(right.getTableRightsSQL(table)).append(' ').append("ON").append(' ').append("TABLE").append(' ').append(hsqlName.getSchemaQualifiedStatementName());
                        break;
                    }
                    case 7: {
                        NumberSequence numberSequence = (NumberSequence)this.granteeManager.database.schemaManager.findSchemaObject(hsqlName.name, hsqlName.schema.name, 7);
                        if (numberSequence == null) break;
                        stringBuilder.append("GRANT").append(' ').append("USAGE").append(' ').append("ON").append(' ').append("SEQUENCE").append(' ').append(hsqlName.getSchemaQualifiedStatementName());
                        break;
                    }
                    case 13: {
                        Type type = (Type)this.granteeManager.database.schemaManager.findSchemaObject(hsqlName.name, hsqlName.schema.name, 13);
                        if (type == null) break;
                        stringBuilder.append("GRANT").append(' ').append("USAGE").append(' ').append("ON").append(' ').append("DOMAIN").append(' ').append(hsqlName.getSchemaQualifiedStatementName());
                        break;
                    }
                    case 12: {
                        Type type = (Type)this.granteeManager.database.schemaManager.findSchemaObject(hsqlName.name, hsqlName.schema.name, 13);
                        if (type == null) break;
                        stringBuilder.append("GRANT").append(' ').append("USAGE").append(' ').append("ON").append(' ').append("TYPE").append(' ').append(hsqlName.getSchemaQualifiedStatementName());
                        break;
                    }
                    case 16: 
                    case 17: 
                    case 24: {
                        SchemaObject schemaObject = this.granteeManager.database.schemaManager.findSchemaObject(hsqlName.name, hsqlName.schema.name, hsqlName.type);
                        if (schemaObject == null) break;
                        stringBuilder.append("GRANT").append(' ').append("EXECUTE").append(' ').append("ON").append(' ').append("SPECIFIC").append(' ');
                        if (schemaObject.getType() == 17) {
                            stringBuilder.append("PROCEDURE");
                        } else {
                            stringBuilder.append("FUNCTION");
                        }
                        stringBuilder.append(' ').append(hsqlName.getSchemaQualifiedStatementName());
                        break;
                    }
                }
                if (stringBuilder.length() == 0) continue;
                stringBuilder.append(' ').append("TO").append(' ').append(this.getName().getStatementName());
                hsqlArrayList.add(stringBuilder.toString());
            }
        }
        return hsqlArrayList;
    }
}

