/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.runtime.io.Format;
import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.IoMessages;
import io.smallrye.openapi.runtime.io.JsonIO;
import io.smallrye.openapi.runtime.io.OpenAPIDefinitionIO;
import io.smallrye.openapi.runtime.io.extensions.ExtensionIO;
import io.smallrye.openapi.runtime.io.media.SchemaIO;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.media.Schema;

@Deprecated
public class OpenApiParser {
    private OpenApiParser() {
    }

    public static final OpenAPI parse(URL url) throws IOException {
        OpenAPI openAPI;
        block11: {
            boolean isYaml;
            String fname = url.getFile();
            if (fname == null) {
                throw IoMessages.msg.noFileName(url.toURI().toString());
            }
            int lidx = fname.lastIndexOf(46);
            if (lidx == -1 || lidx >= fname.length()) {
                throw IoMessages.msg.invalidFileName(url.toURI().toString());
            }
            String ext = fname.substring(lidx + 1);
            boolean isJson = ext.equalsIgnoreCase("json");
            boolean bl = isYaml = ext.equalsIgnoreCase("yaml") || ext.equalsIgnoreCase("yml");
            if (!isJson && !isYaml) {
                throw IoMessages.msg.invalidFileExtension(url.toURI().toString());
            }
            InputStream stream = url.openStream();
            try {
                openAPI = OpenApiParser.parse(stream, isJson ? Format.JSON : Format.YAML, OpenApiConfig.fromConfig(ConfigProvider.getConfig()));
                if (stream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (URISyntaxException e) {
                    throw new IOException(e);
                }
            }
            stream.close();
        }
        return openAPI;
    }

    public static OpenAPI parse(InputStream stream, Format format, OpenApiConfig config) {
        return OpenApiParser.parse(stream, format, JsonIO.newInstance(config));
    }

    private static <V, A extends V, O extends V, AB, OB> OpenAPI parse(InputStream stream, Format format, JsonIO<V, A, O, AB, OB> jsonIO) {
        IOContext<V, A, O, AB, OB> context = IOContext.forJson(jsonIO);
        return (OpenAPI)new OpenAPIDefinitionIO<V, A, O, AB, OB>(context).readValue(jsonIO.fromStream(stream, format));
    }

    public static Schema parseSchema(String schemaJson) {
        return OpenApiParser.parseSchema(schemaJson, JsonIO.newInstance(null));
    }

    private static <V, A extends V, O extends V, AB, OB> Schema parseSchema(String schemaJson, JsonIO<V, A, O, AB, OB> jsonIO) {
        IOContext<V, A, O, AB, OB> context = IOContext.forJson(jsonIO);
        V schemaValue = jsonIO.fromString(schemaJson, Format.JSON);
        return (Schema)new SchemaIO<V, A, O, AB, OB>(context, new ExtensionIO<V, A, O, AB, OB>(context)).readValue(schemaValue);
    }
}

