/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.util.concurrent;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import org.apache.openjpa.lib.util.ReferenceMap;
import org.apache.openjpa.lib.util.SizedMap;
import org.apache.openjpa.lib.util.collections.AbstractReferenceMap;
import org.apache.openjpa.lib.util.concurrent.ConcurrentMap;

public class ConcurrentReferenceHashMap
extends AbstractMap
implements ConcurrentMap,
ReferenceMap,
SizedMap,
Cloneable {
    static final double[] RANDOMS = new double[1000];
    private transient Entry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private AbstractReferenceMap.ReferenceStrength keyType;
    private AbstractReferenceMap.ReferenceStrength valueType;
    private final ReferenceQueue queue = new ReferenceQueue();
    private int randomEntry = 0;
    private int maxSize = Integer.MAX_VALUE;
    private transient Set keySet = null;
    private transient Set entrySet = null;
    private transient Collection values = null;
    private static final int KEYS = 0;
    private static final int VALUES = 1;
    private static final int ENTRIES = 2;

    protected boolean eq(Object x, Object y) {
        return x == y || x != null && x.equals(y);
    }

    protected int hc(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    public ConcurrentReferenceHashMap(AbstractReferenceMap.ReferenceStrength keyType, AbstractReferenceMap.ReferenceStrength valueType, int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + initialCapacity);
        }
        if (loadFactor > 1.0f || loadFactor <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load factor: " + loadFactor);
        }
        if (keyType != AbstractReferenceMap.ReferenceStrength.HARD && valueType != AbstractReferenceMap.ReferenceStrength.HARD) {
            throw new IllegalArgumentException("Either keys or values must use hard references.");
        }
        this.keyType = keyType;
        this.valueType = valueType;
        this.loadFactor = loadFactor;
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public ConcurrentReferenceHashMap(AbstractReferenceMap.ReferenceStrength keyType, AbstractReferenceMap.ReferenceStrength valueType, int initialCapacity) {
        this(keyType, valueType, initialCapacity, 0.75f);
    }

    public ConcurrentReferenceHashMap(AbstractReferenceMap.ReferenceStrength keyType, AbstractReferenceMap.ReferenceStrength valueType) {
        this(keyType, valueType, 11, 0.75f);
    }

    public ConcurrentReferenceHashMap(AbstractReferenceMap.ReferenceStrength keyType, AbstractReferenceMap.ReferenceStrength valueType, Map t) {
        this(keyType, valueType, Math.max(3 * t.size(), 11), 0.75f);
        this.putAll(t);
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public void setMaxSize(int maxSize) {
        int n = this.maxSize = maxSize < 0 ? Integer.MAX_VALUE : maxSize;
        if (this.maxSize != Integer.MAX_VALUE) {
            this.removeOverflow(this.maxSize);
        }
    }

    @Override
    public boolean isFull() {
        return this.maxSize != Integer.MAX_VALUE && this.size() >= this.maxSize;
    }

    @Override
    public void overflowRemoved(Object key, Object value) {
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public boolean containsValue(Object value) {
        Entry[] tab = this.table;
        if (value == null) {
            if (this.valueType != AbstractReferenceMap.ReferenceStrength.HARD) {
                return false;
            }
            int i = tab.length;
            while (i-- > 0) {
                for (Entry e = tab[i]; e != null; e = e.getNext()) {
                    if (e.getValue() != null) continue;
                    return true;
                }
            }
        } else {
            int i = tab.length;
            while (i-- > 0) {
                for (Entry e = tab[i]; e != null; e = e.getNext()) {
                    if (!this.eq(value, e.getValue())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null && this.keyType != AbstractReferenceMap.ReferenceStrength.HARD) {
            return false;
        }
        Entry[] tab = this.table;
        int hash = this.hc(key);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        for (Entry e = tab[index]; e != null; e = e.getNext()) {
            if (e.getHash() != hash || !this.eq(key, e.getKey())) continue;
            return true;
        }
        return false;
    }

    public Object get(Object key) {
        if (key == null && this.keyType != AbstractReferenceMap.ReferenceStrength.HARD) {
            return null;
        }
        Entry[] tab = this.table;
        int hash = this.hc(key);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        for (Entry e = tab[index]; e != null; e = e.getNext()) {
            if (e.getHash() != hash || !this.eq(key, e.getKey())) continue;
            return e.getValue();
        }
        return null;
    }

    private void rehash() {
        int oldCapacity = this.table.length;
        Entry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldMap[i];
            while (old != null) {
                Entry e;
                if (this.keyType != AbstractReferenceMap.ReferenceStrength.HARD && old.getKey() == null || this.valueType != AbstractReferenceMap.ReferenceStrength.HARD && old.getValue() == null) {
                    e = old;
                    old = old.getNext();
                    e.setNext(null);
                    --this.count;
                    continue;
                }
                e = (Entry)old.clone(this.queue);
                old = old.getNext();
                int index = (e.getHash() & Integer.MAX_VALUE) % newCapacity;
                e.setNext(newMap[index]);
                newMap[index] = e;
            }
        }
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value) {
        if (key == null && this.keyType != AbstractReferenceMap.ReferenceStrength.HARD || value == null && this.valueType != AbstractReferenceMap.ReferenceStrength.HARD) {
            throw new IllegalArgumentException("Null references not supported");
        }
        int hash = this.hc(key);
        ConcurrentReferenceHashMap concurrentReferenceHashMap = this;
        synchronized (concurrentReferenceHashMap) {
            this.expungeStaleEntries();
            Entry[] tab = this.table;
            int index = 0;
            index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry prev = null;
            for (Entry e = tab[index]; e != null; e = e.getNext()) {
                if (e.getHash() == hash && this.eq(key, e.getKey())) {
                    Object old = e.getValue();
                    if (this.valueType == AbstractReferenceMap.ReferenceStrength.HARD) {
                        e.setValue(value);
                    } else {
                        e = this.newEntry(hash, e.getKey(), value, e.getNext());
                        if (prev == null) {
                            tab[index] = e;
                        } else {
                            prev.setNext(e);
                        }
                    }
                    return old;
                }
                prev = e;
            }
            if (this.count >= this.threshold) {
                this.rehash();
                tab = this.table;
                index = (hash & Integer.MAX_VALUE) % tab.length;
            }
            if (this.maxSize != Integer.MAX_VALUE) {
                this.removeOverflow(this.maxSize - 1);
            }
            tab[index] = this.newEntry(hash, key, value, tab[index]);
            ++this.count;
        }
        return null;
    }

    private Entry newEntry(int hash, Object key, Object value, Entry next) {
        AbstractReferenceMap.ReferenceStrength refType = this.keyType != AbstractReferenceMap.ReferenceStrength.HARD ? this.keyType : this.valueType;
        switch (refType) {
            case WEAK: {
                return new WeakEntry(hash, key, value, refType == this.keyType, next, this.queue);
            }
            case SOFT: {
                return new SoftEntry(hash, key, value, refType == this.keyType, next, this.queue);
            }
        }
        return new HardEntry(hash, key, value, next);
    }

    private void removeOverflow(int maxSize) {
        Map.Entry entry;
        while (this.count > maxSize && (entry = this.removeRandom()) != null) {
            this.overflowRemoved(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        if (key == null && this.keyType != AbstractReferenceMap.ReferenceStrength.HARD) {
            return null;
        }
        int hash = this.hc(key);
        ConcurrentReferenceHashMap concurrentReferenceHashMap = this;
        synchronized (concurrentReferenceHashMap) {
            this.expungeStaleEntries();
            Entry[] tab = this.table;
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry prev = null;
            for (Entry e = tab[index]; e != null; e = e.getNext()) {
                if (e.getHash() == hash && this.eq(key, e.getKey())) {
                    if (prev != null) {
                        prev.setNext(e.getNext());
                    } else {
                        tab[index] = e.getNext();
                    }
                    --this.count;
                    return e.getValue();
                }
                prev = e;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeExpired() {
        ConcurrentReferenceHashMap concurrentReferenceHashMap = this;
        synchronized (concurrentReferenceHashMap) {
            this.expungeStaleEntries();
        }
    }

    @Override
    public void keyExpired(Object value) {
    }

    @Override
    public void valueExpired(Object key) {
    }

    private int randomEntryIndex() {
        if (this.randomEntry == RANDOMS.length) {
            this.randomEntry = 0;
        }
        return (int)(RANDOMS[this.randomEntry++] * (double)this.table.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map.Entry removeRandom() {
        ConcurrentReferenceHashMap concurrentReferenceHashMap = this;
        synchronized (concurrentReferenceHashMap) {
            int random;
            this.expungeStaleEntries();
            if (this.count == 0) {
                return null;
            }
            int index = this.findEntry(random, (random = this.randomEntryIndex()) % 2 == 0, false);
            if (index == -1) {
                return null;
            }
            Entry rem = this.table[index];
            this.table[index] = rem.getNext();
            --this.count;
            return rem;
        }
    }

    private int findEntry(int start, boolean forward, boolean searchedOther) {
        if (forward) {
            for (int i = start; i < this.table.length; ++i) {
                if (this.table[i] == null) continue;
                return i;
            }
            return searchedOther || start == 0 ? -1 : this.findEntry(start - 1, false, true);
        }
        for (int i = start; i >= 0; --i) {
            if (this.table[i] == null) continue;
            return i;
        }
        return searchedOther || start == this.table.length - 1 ? -1 : this.findEntry(start + 1, true, true);
    }

    @Override
    public Iterator randomEntryIterator() {
        return new HashIterator(2, this.randomEntryIndex());
    }

    public void putAll(Map t) {
        for (Map.Entry e : t.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public synchronized void clear() {
        while (this.queue.poll() != null) {
        }
        this.table = new Entry[this.table.length];
        this.count = 0;
        while (this.queue.poll() != null) {
        }
    }

    @Override
    public synchronized Object clone() {
        try {
            this.expungeStaleEntries();
            ConcurrentReferenceHashMap t = (ConcurrentReferenceHashMap)super.clone();
            t.table = new Entry[this.table.length];
            int i = this.table.length;
            while (i-- > 0) {
                Entry e = this.table[i];
                if (e == null) continue;
                t.table[i] = (Entry)e.clone(t.queue);
                Entry k = t.table[i];
                for (e = e.getNext(); e != null; e = e.getNext()) {
                    k.setNext((Entry)e.clone(t.queue));
                    k = k.getNext();
                }
            }
            t.keySet = null;
            t.entrySet = null;
            t.values = null;
            return t;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet(){

                @Override
                public Iterator iterator() {
                    return new HashIterator(0, ConcurrentReferenceHashMap.this.table.length - 1);
                }

                @Override
                public int size() {
                    return ConcurrentReferenceHashMap.this.count;
                }

                @Override
                public boolean contains(Object o) {
                    return ConcurrentReferenceHashMap.this.containsKey(o);
                }

                @Override
                public boolean remove(Object o) {
                    return ConcurrentReferenceHashMap.this.remove(o) != null;
                }

                @Override
                public void clear() {
                    ConcurrentReferenceHashMap.this.clear();
                }
            };
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(){

                @Override
                public Iterator iterator() {
                    return new HashIterator(1, ConcurrentReferenceHashMap.this.table.length - 1);
                }

                @Override
                public int size() {
                    return ConcurrentReferenceHashMap.this.count;
                }

                @Override
                public boolean contains(Object o) {
                    return ConcurrentReferenceHashMap.this.containsValue(o);
                }

                @Override
                public void clear() {
                    ConcurrentReferenceHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet(){

                @Override
                public Iterator iterator() {
                    return new HashIterator(2, ConcurrentReferenceHashMap.this.table.length - 1);
                }

                @Override
                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Object key = entry.getKey();
                    Entry[] tab = ConcurrentReferenceHashMap.this.table;
                    int hash = ConcurrentReferenceHashMap.this.hc(key);
                    int index = (hash & Integer.MAX_VALUE) % tab.length;
                    for (Entry e = tab[index]; e != null; e = e.getNext()) {
                        if (e.getHash() != hash || !ConcurrentReferenceHashMap.this.eq(e, entry)) continue;
                        return true;
                    }
                    return false;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Object key = entry.getKey();
                    ConcurrentReferenceHashMap concurrentReferenceHashMap = ConcurrentReferenceHashMap.this;
                    synchronized (concurrentReferenceHashMap) {
                        Entry[] tab = ConcurrentReferenceHashMap.this.table;
                        int hash = ConcurrentReferenceHashMap.this.hc(key);
                        int index = (hash & Integer.MAX_VALUE) % tab.length;
                        Entry prev = null;
                        for (Entry e = tab[index]; e != null; e = e.getNext()) {
                            if (e.getHash() == hash && ConcurrentReferenceHashMap.this.eq(e, entry)) {
                                if (prev != null) {
                                    prev.setNext(e.getNext());
                                } else {
                                    tab[index] = e.getNext();
                                }
                                --ConcurrentReferenceHashMap.this.count;
                                return true;
                            }
                            prev = e;
                        }
                        return false;
                    }
                }

                @Override
                public int size() {
                    return ConcurrentReferenceHashMap.this.count;
                }

                @Override
                public void clear() {
                    ConcurrentReferenceHashMap.this.clear();
                }
            };
        }
        return this.entrySet;
    }

    private void expungeStaleEntries() {
        Reference r;
        while ((r = this.queue.poll()) != null) {
            Entry entry = (Entry)((Object)r);
            int hash = entry.getHash();
            Entry[] tab = this.table;
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry prev = null;
            for (Entry e = tab[index]; e != null; e = e.getNext()) {
                if (e == entry) {
                    if (prev != null) {
                        prev.setNext(e.getNext());
                    } else {
                        tab[index] = e.getNext();
                    }
                    --this.count;
                    if (this.keyType == AbstractReferenceMap.ReferenceStrength.HARD) {
                        this.valueExpired(e.getKey());
                    } else {
                        this.keyExpired(e.getValue());
                    }
                }
                prev = e;
            }
        }
    }

    int capacity() {
        return this.table.length;
    }

    float loadFactor() {
        return this.loadFactor;
    }

    static {
        Random random = new Random();
        for (int i = 0; i < RANDOMS.length; ++i) {
            ConcurrentReferenceHashMap.RANDOMS[i] = random.nextDouble();
        }
    }

    private class HashIterator
    implements Iterator {
        final Entry[] table;
        final int type;
        int startIndex;
        int stopIndex;
        int index;
        Entry entry;
        Entry lastReturned;

        HashIterator(int type, int startIndex) {
            this.table = ConcurrentReferenceHashMap.this.table;
            this.stopIndex = 0;
            this.entry = null;
            this.lastReturned = null;
            this.type = type;
            this.startIndex = startIndex;
            this.index = startIndex;
        }

        @Override
        public boolean hasNext() {
            if (this.entry != null) {
                return true;
            }
            while (this.index >= this.stopIndex) {
                if ((this.entry = this.table[this.index--]) == null) continue;
                return true;
            }
            if (this.stopIndex == 0) {
                this.index = this.table.length - 1;
                this.stopIndex = this.startIndex + 1;
                while (this.index >= this.stopIndex) {
                    if ((this.entry = this.table[this.index--]) == null) continue;
                    return true;
                }
            }
            return false;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Entry e = this.lastReturned = this.entry;
            this.entry = e.getNext();
            return this.type == 0 ? e.getKey() : (this.type == 1 ? e.getValue() : e);
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            ConcurrentReferenceHashMap concurrentReferenceHashMap = ConcurrentReferenceHashMap.this;
            synchronized (concurrentReferenceHashMap) {
                Entry[] tab = ConcurrentReferenceHashMap.this.table;
                int index = (this.lastReturned.getHash() & Integer.MAX_VALUE) % tab.length;
                Entry prev = null;
                for (Entry e = tab[index]; e != null; e = e.getNext()) {
                    if (e == this.lastReturned) {
                        if (prev == null) {
                            tab[index] = e.getNext();
                        } else {
                            prev.setNext(e.getNext());
                        }
                        --ConcurrentReferenceHashMap.this.count;
                        this.lastReturned = null;
                        return;
                    }
                    prev = e;
                }
                throw new Error("Iterated off table when doing remove");
            }
        }
    }

    private class SoftEntry
    extends SoftReference
    implements Entry {
        private int hash;
        private Object hard;
        private boolean keyRef;
        private Entry next;

        SoftEntry(int hash, Object key, Object value, boolean keyRef, Entry next, ReferenceQueue queue) {
            super(keyRef ? key : value, queue);
            this.hash = hash;
            this.hard = keyRef ? value : key;
            this.keyRef = keyRef;
            this.next = next;
        }

        @Override
        public int getHash() {
            return this.hash;
        }

        @Override
        public Entry getNext() {
            return this.next;
        }

        @Override
        public void setNext(Entry next) {
            this.next = next;
        }

        @Override
        public Object clone(ReferenceQueue queue) {
            return new SoftEntry(this.hash, this.getKey(), this.getValue(), this.keyRef, null, queue);
        }

        public Object getKey() {
            return this.keyRef ? super.get() : this.hard;
        }

        public Object getValue() {
            return this.keyRef ? this.hard : super.get();
        }

        public Object setValue(Object value) {
            if (!this.keyRef) {
                throw new Error("Attempt to reset reference value.");
            }
            Object oldValue = this.hard;
            this.hard = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return ConcurrentReferenceHashMap.this.eq(this.getKey(), e.getKey()) && ConcurrentReferenceHashMap.this.eq(this.getValue(), e.getValue());
        }

        @Override
        public int hashCode() {
            Object val = this.getValue();
            return this.hash ^ (val == null ? 0 : val.hashCode());
        }

        public String toString() {
            return String.valueOf(this.getKey()) + "=" + String.valueOf(this.getValue());
        }
    }

    private class WeakEntry
    extends WeakReference
    implements Entry {
        private int hash;
        private Object hard;
        private boolean keyRef;
        private Entry next;

        WeakEntry(int hash, Object key, Object value, boolean keyRef, Entry next, ReferenceQueue queue) {
            super(keyRef ? key : value, queue);
            this.hash = hash;
            this.hard = keyRef ? value : key;
            this.keyRef = keyRef;
            this.next = next;
        }

        @Override
        public int getHash() {
            return this.hash;
        }

        @Override
        public Entry getNext() {
            return this.next;
        }

        @Override
        public void setNext(Entry next) {
            this.next = next;
        }

        @Override
        public Object clone(ReferenceQueue queue) {
            return new WeakEntry(this.hash, this.getKey(), this.getValue(), this.keyRef, null, queue);
        }

        public Object getKey() {
            return this.keyRef ? super.get() : this.hard;
        }

        public Object getValue() {
            return this.keyRef ? this.hard : super.get();
        }

        public Object setValue(Object value) {
            if (!this.keyRef) {
                throw new Error("Attempt to reset reference value.");
            }
            Object oldValue = this.hard;
            this.hard = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return ConcurrentReferenceHashMap.this.eq(this.getKey(), e.getKey()) && ConcurrentReferenceHashMap.this.eq(this.getValue(), e.getValue());
        }

        @Override
        public int hashCode() {
            Object val = this.getValue();
            return this.hash ^ (val == null ? 0 : val.hashCode());
        }

        public String toString() {
            return String.valueOf(this.getKey()) + "=" + String.valueOf(this.getValue());
        }
    }

    private class HardEntry
    implements Entry {
        private int hash;
        private Object key;
        private Object value;
        private Entry next;

        HardEntry(int hash, Object key, Object value, Entry next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }

        @Override
        public int getHash() {
            return this.hash;
        }

        @Override
        public Entry getNext() {
            return this.next;
        }

        @Override
        public void setNext(Entry next) {
            this.next = next;
        }

        @Override
        public Object clone(ReferenceQueue queue) {
            return new HardEntry(this.hash, this.key, this.value, null);
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k1 = this.key;
            Object k2 = e.getKey();
            return (k1 == null ? k2 == null : ConcurrentReferenceHashMap.this.eq(k1, k2)) && (this.value == null ? e.getValue() == null : ConcurrentReferenceHashMap.this.eq(this.value, e.getValue()));
        }

        @Override
        public int hashCode() {
            return this.hash ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return String.valueOf(this.key) + "=" + this.value.toString();
        }
    }

    private static interface Entry
    extends Map.Entry {
        public int getHash();

        public Entry getNext();

        public void setNext(Entry var1);

        public Object clone(ReferenceQueue var1);
    }
}

