/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.microprofile.jwt.keys;

import io.churchkey.Key;
import io.churchkey.Keys;
import jakarta.enterprise.inject.spi.DeploymentException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.openejb.loader.IO;
import org.apache.tomee.microprofile.jwt.keys.HttpLocation;
import org.apache.tomee.microprofile.jwt.keys.UrlLocation;

public class KeyResolver {
    public Optional<Map<String, Key>> resolvePublicKey(Optional<String> keyContents, Optional<String> keyLocation) {
        return this.resolve(keyContents, keyLocation, this::validatePublicKeys);
    }

    public Optional<Map<String, Key>> resolveDecryptKey(Optional<String> keyContents, Optional<String> keyLocation) {
        return this.resolve(keyContents, keyLocation, this::validateDecryptKeys);
    }

    private Optional<Map<String, Key>> resolve(Optional<String> publicKeyContents, Optional<String> publicKeyLocation, Consumer<List<io.churchkey.Key>> validation) {
        Stream<Supplier> possiblePublicKeys = Stream.of(() -> publicKeyContents.map(publicKey -> this.readPublicKeys((String)publicKey, validation)), () -> publicKeyLocation.map(publicKeyLocation1 -> this.readPublicKeysFromLocation((String)publicKeyLocation1, validation)));
        return possiblePublicKeys.map(Supplier::get).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    public Map<String, Key> readPublicKeys(String publicKey, Consumer<List<io.churchkey.Key>> validation) {
        List keys;
        try {
            keys = Keys.decodeSet((String)publicKey);
        }
        catch (Exception e) {
            throw new DeploymentException("Unable to decode key contents: " + publicKey, (Throwable)e);
        }
        if (keys.size() == 0) {
            throw new DeploymentException("No keys found in key contents: " + publicKey);
        }
        validation.accept(keys);
        int unknown = 0;
        HashMap<String, Key> map = new HashMap<String, Key>();
        for (io.churchkey.Key key : keys) {
            Object id = this.defined(key, "kid") ? key.getAttribute("kid") : (this.defined(key, "Comment") ? key.getAttribute("Comment") : "Unknown " + unknown++);
            map.put((String)id, key.getKey());
        }
        return map;
    }

    private void validatePublicKeys(List<io.churchkey.Key> keys) {
        this.checkInvalidTypes(keys, Key.Type.PRIVATE);
        this.checkInvalidTypes(keys, Key.Type.SECRET);
    }

    private void validateDecryptKeys(List<io.churchkey.Key> keys) {
        this.checkInvalidTypes(keys, Key.Type.PUBLIC);
    }

    private boolean defined(io.churchkey.Key key, String kid) {
        String attribute = key.getAttribute(kid);
        return attribute != null && attribute.length() > 0;
    }

    private void checkInvalidTypes(List<io.churchkey.Key> keys, Key.Type type) {
        long invalid = keys.stream().map(io.churchkey.Key::getType).filter(arg_0 -> type.equals(arg_0)).count();
        if (invalid > 0L) {
            throw new DeploymentException("Found " + invalid + " " + type.name().toLowerCase() + " keys in MP JWT key configuration.  Only Public Keys must be configured for JWT validation");
        }
    }

    private Map<String, Key> readPublicKeysFromLocation(String publicKeyLocation, Consumer<List<io.churchkey.Key>> validatePublicKeys) {
        Stream<Supplier> possiblePublicKeysLocations = Stream.of(() -> this.readPublicKeysFromClasspath(publicKeyLocation), () -> this.readPublicKeysFromFile(publicKeyLocation), () -> this.readPublicKeysFromUrl(publicKeyLocation));
        return possiblePublicKeysLocations.map(Supplier::get).filter(Optional::isPresent).map(Optional::get).findFirst().map(publicKey -> this.readPublicKeys((String)publicKey, validatePublicKeys)).orElseThrow(() -> new DeploymentException("Could not read MicroProfile Public Key from Location: " + publicKeyLocation));
    }

    private Optional<String> readPublicKeysFromClasspath(String publicKeyLocation) {
        try {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(publicKeyLocation);
            if (is == null) {
                return Optional.empty();
            }
            return Optional.of(IO.slurp((InputStream)is));
        }
        catch (IOException e) {
            throw new DeploymentException("Could not read MicroProfile Public Key from Location: " + publicKeyLocation, (Throwable)e);
        }
    }

    private Optional<String> readPublicKeysFromFile(String publicKeyLocation) {
        if (!publicKeyLocation.startsWith("file")) {
            return Optional.empty();
        }
        try {
            URL locationURL = new URL(publicKeyLocation);
            File publicKeyFile = new File(locationURL.toURI());
            if (!publicKeyFile.exists() || publicKeyFile.isDirectory()) {
                throw new DeploymentException("Could not read MicroProfile Public Key from Location: " + publicKeyLocation + ". File does not exist or it is a directory.");
            }
            return Optional.of(IO.slurp((URL)locationURL));
        }
        catch (IOException | URISyntaxException e) {
            throw new DeploymentException("Could not read MicroProfile Public Key from Location: " + publicKeyLocation, (Throwable)e);
        }
    }

    private Optional<String> readPublicKeysFromUrl(String publicKeyLocation) {
        URI uri = URI.create(publicKeyLocation);
        if (uri.getScheme().startsWith("http")) {
            byte[] bytes = new HttpLocation(uri).get();
            return Optional.of(new String(bytes, StandardCharsets.UTF_8));
        }
        byte[] bytes = new UrlLocation(uri).get();
        return Optional.of(new String(bytes, StandardCharsets.UTF_8));
    }
}

