/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.base;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIOutcomeTarget;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.component.html.HtmlOutcomeTargetButton;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.Map;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.base.HtmlRenderer;
import org.apache.myfaces.renderkit.html.util.CommonHtmlAttributesUtil;
import org.apache.myfaces.renderkit.html.util.HTML;
import org.apache.myfaces.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.renderkit.html.util.ResourceUtils;

public class HtmlOutcomeTargetButtonRendererBase
extends HtmlRenderer {
    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        super.encodeBegin(facesContext, uiComponent);
        String clientId = uiComponent.getClientId(facesContext);
        ResponseWriter writer = facesContext.getResponseWriter();
        Map behaviors = null;
        if (uiComponent instanceof ClientBehaviorHolder && !(behaviors = ((ClientBehaviorHolder)uiComponent).getClientBehaviors()).isEmpty()) {
            ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, facesContext.getResponseWriter());
        }
        writer.startElement("input", uiComponent);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("name", (Object)clientId, "id");
        String image = this.getImage(uiComponent);
        ExternalContext externalContext = facesContext.getExternalContext();
        if (image != null) {
            writer.writeAttribute("type", (Object)"image", "type");
            String src = facesContext.getApplication().getViewHandler().getResourceURL(facesContext, image);
            writer.writeURIAttribute("src", (Object)externalContext.encodeResourceURL(src), "image");
        } else {
            writer.writeAttribute("type", (Object)"button", "type");
            String value = RendererUtils.getStringValue(facesContext, uiComponent);
            if (value != null) {
                writer.writeAttribute("value", (Object)value, "value");
            }
        }
        String outcomeTargetHref = HtmlRendererUtils.getOutcomeTargetHref(facesContext, (UIOutcomeTarget)uiComponent);
        if (HtmlRendererUtils.isDisabled(uiComponent) || outcomeTargetHref == null) {
            HtmlRendererUtils.renderHTMLAttribute(writer, "disabled", "disabled", true);
        } else {
            String href = facesContext.getExternalContext().encodeResourceURL(outcomeTargetHref);
            String commandOnClick = (String)uiComponent.getAttributes().get("onclick");
            String navigationJavaScript = "window.location.href = '" + href + "'";
            if (behaviors != null && !behaviors.isEmpty()) {
                HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onclick", uiComponent, "click", null, behaviors, "onclick", commandOnClick, navigationJavaScript);
            } else {
                StringBuilder onClick = new StringBuilder();
                if (commandOnClick != null) {
                    onClick.append(commandOnClick);
                    onClick.append(';');
                }
                onClick.append(navigationJavaScript);
                writer.writeAttribute("onclick", (Object)onClick.toString(), null);
            }
        }
        if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
            long commonPropertiesMarked = CommonHtmlAttributesUtil.getMarkedAttributes(uiComponent);
            if (behaviors != null && !behaviors.isEmpty() && uiComponent instanceof ClientBehaviorHolder) {
                HtmlRendererUtils.renderBehaviorizedEventHandlersWithoutOnclick(facesContext, writer, uiComponent, behaviors);
                HtmlRendererUtils.renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(facesContext, writer, uiComponent, behaviors);
            } else {
                CommonHtmlAttributesUtil.renderEventPropertiesWithoutOnclick(writer, commonPropertiesMarked, uiComponent);
                CommonHtmlAttributesUtil.renderFocusBlurEventProperties(writer, commonPropertiesMarked, uiComponent);
            }
            CommonHtmlAttributesUtil.renderCommonFieldPassthroughPropertiesWithoutDisabledAndEvents(writer, commonPropertiesMarked, uiComponent);
            if ((commonPropertiesMarked & 0x400L) != 0L) {
                HtmlRendererUtils.renderHTMLStringAttribute(writer, uiComponent, "alt", "alt");
            }
        } else {
            if (uiComponent instanceof ClientBehaviorHolder) {
                HtmlRendererUtils.renderBehaviorizedEventHandlersWithoutOnclick(facesContext, writer, uiComponent, behaviors);
                HtmlRendererUtils.renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(facesContext, writer, uiComponent, behaviors);
            } else {
                HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.EVENT_HANDLER_ATTRIBUTES_WITHOUT_ONCLICK);
                HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.COMMON_FIELD_EVENT_ATTRIBUTES_WITHOUT_ONSELECT_AND_ONCHANGE);
            }
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.COMMON_FIELD_PASSTROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_EVENTS);
            HtmlRendererUtils.renderHTMLStringAttribute(writer, uiComponent, "alt", "alt");
        }
        writer.flush();
    }

    private String getImage(UIComponent uiComponent) {
        if (uiComponent instanceof HtmlOutcomeTargetButton) {
            return ((HtmlOutcomeTargetButton)uiComponent).getImage();
        }
        return (String)uiComponent.getAttributes().get("image");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
        RendererUtils.renderChildren(facesContext, component);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        super.encodeEnd(facesContext, component);
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.endElement("input");
    }
}

