/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.credential.criteria.impl;

import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.logic.AbstractTriStatePredicate;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.apache.commons.codec.binary.Hex;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.criteria.impl.EvaluableCredentialCriterion;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.security.x509.X509SubjectKeyIdentifierCriterion;
import org.opensaml.security.x509.X509Support;
import org.slf4j.Logger;

public class EvaluableX509SubjectKeyIdentifierCredentialCriterion
extends AbstractTriStatePredicate<Credential>
implements EvaluableCredentialCriterion {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(EvaluableX509SubjectKeyIdentifierCredentialCriterion.class);
    @Nonnull
    private final byte[] ski;

    public EvaluableX509SubjectKeyIdentifierCredentialCriterion(@Nonnull X509SubjectKeyIdentifierCriterion criteria) {
        this.ski = ((X509SubjectKeyIdentifierCriterion)Constraint.isNotNull((Object)criteria, (String)"Criterion instance cannot be null")).getSubjectKeyIdentifier();
    }

    public EvaluableX509SubjectKeyIdentifierCredentialCriterion(@Nonnull byte[] newSKI) {
        this.ski = Constraint.isNotEmpty((byte[])newSKI, (String)"Subject key identifier cannot be null or empty");
    }

    @Override
    public boolean test(@Nullable Credential target) {
        if (target == null) {
            this.log.error("Credential target was null");
            return this.isNullInputSatisfies();
        }
        if (!(target instanceof X509Credential)) {
            this.log.info("Credential is not an X509Credential, does not satisfy subject key identifier criteria");
            return false;
        }
        X509Certificate entityCert = ((X509Credential)target).getEntityCertificate();
        byte[] credSKI = X509Support.getSubjectKeyIdentifier((X509Certificate)entityCert);
        if (credSKI == null || credSKI.length == 0) {
            this.log.info("Could not evaluate criteria, certificate contained no subject key identifier extension");
            return this.isUnevaluableSatisfies();
        }
        return Arrays.equals(this.ski, credSKI);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("EvaluableX509SubjectKeyIdentifierCredentialCriterion [ski=");
        builder.append(Hex.encodeHexString((byte[])this.ski));
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        return this.ski.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof EvaluableX509SubjectKeyIdentifierCredentialCriterion) {
            EvaluableX509SubjectKeyIdentifierCredentialCriterion other = (EvaluableX509SubjectKeyIdentifierCredentialCriterion)obj;
            return this.ski.equals(other.ski);
        }
        return false;
    }
}

