/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.openejb.OpenEJBRuntimeException;

public final class Reflections {
    private Reflections() {
    }

    public static Method findMethod(String name, Class<?> type, Class<?> ... args) {
        try {
            return type.getMethod(name, args);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Can't find public method " + name + " in " + type.getName());
        }
    }

    public static Object invokeByReflection(Object obj, String mtdName, Class<?>[] paramTypes, Object[] args) {
        for (Class<?> clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            boolean acc = true;
            Method mtd = null;
            try {
                mtd = clazz.getDeclaredMethod(mtdName, paramTypes);
                acc = mtd.isAccessible();
                mtd.setAccessible(true);
                Object object = mtd.invoke(obj, args);
                return object;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
            finally {
                if (mtd != null) {
                    mtd.setAccessible(acc);
                }
            }
        }
        throw new IllegalArgumentException(new NoSuchMethodException(obj.getClass().getName() + " ." + mtdName));
    }

    public static void set(Object instance, String field, Object value) {
        Reflections.set(instance.getClass(), instance, field, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set(Class<?> inClazz, Object instance, String field, Object value) {
        for (Class<?> clazz = inClazz; clazz != null; clazz = clazz.getSuperclass()) {
            try {
                Field f = clazz.getDeclaredField(field);
                boolean acc = f.isAccessible();
                f.setAccessible(true);
                Field modifiersField = null;
                int modifiers = f.getModifiers();
                boolean isFinal = Modifier.isFinal(modifiers);
                try {
                    if (isFinal) {
                        modifiersField = Field.class.getDeclaredField("modifiers");
                        modifiersField.setAccessible(true);
                        modifiersField.setInt(f, modifiers & 0xFFFFFFEF);
                    }
                    f.set(instance, value);
                    return;
                }
                finally {
                    if (isFinal && modifiersField != null) {
                        modifiersField.setInt(f, modifiers);
                    }
                    f.setAccessible(acc);
                }
            }
            catch (NoSuchFieldException f) {
                continue;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public static Object get(Object instance, String field) {
        return Reflections.get(instance.getClass(), instance, field);
    }

    public static Object get(Class<?> aClass, Object instance, String field) {
        for (Class<?> clazz = aClass; clazz != null; clazz = clazz.getSuperclass()) {
            try {
                Field f = clazz.getDeclaredField(field);
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                }
                return f.get(instance);
            }
            catch (NoSuchFieldException f) {
                continue;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        throw new OpenEJBRuntimeException(new NoSuchFieldException(field));
    }
}

