/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.transaction;

import java.rmi.RemoteException;
import org.apache.openejb.ApplicationException;
import org.apache.openejb.BeanContext;
import org.apache.openejb.InvalidateReferenceException;
import org.apache.openejb.SystemException;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.ThreadContextListener;
import org.apache.openejb.core.transaction.TransactionPolicy;
import org.apache.openejb.core.transaction.TransactionRolledbackException;
import org.apache.openejb.core.transaction.TransactionType;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public final class EjbTransactionUtil {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources");

    public static TransactionPolicy createTransactionPolicy(TransactionType type, ThreadContext threadContext) throws SystemException, ApplicationException {
        BeanContext beanContext = threadContext.getBeanContext();
        TransactionPolicy txPolicy = beanContext.getTransactionPolicyFactory().createTransactionPolicy(type);
        TransactionPolicy oldTxPolicy = threadContext.getTransactionPolicy();
        txPolicy.putResource(CallerTransactionEnvironment.class, new CallerTransactionEnvironment(oldTxPolicy));
        threadContext.setTransactionPolicy(txPolicy);
        return txPolicy;
    }

    public static void afterInvoke(TransactionPolicy txPolicy, ThreadContext threadContext) throws SystemException, ApplicationException {
        block13: {
            block12: {
                if (txPolicy != threadContext.getTransactionPolicy()) break block12;
                try {
                    txPolicy.commit();
                }
                catch (Throwable throwable) {
                    CallerTransactionEnvironment oldTxEnv = (CallerTransactionEnvironment)txPolicy.getResource(CallerTransactionEnvironment.class);
                    if (oldTxEnv != null) {
                        threadContext.setTransactionPolicy(oldTxEnv.oldTxPolicy);
                    } else {
                        threadContext.setTransactionPolicy(null);
                    }
                    throw throwable;
                }
                CallerTransactionEnvironment oldTxEnv = (CallerTransactionEnvironment)txPolicy.getResource(CallerTransactionEnvironment.class);
                if (oldTxEnv != null) {
                    threadContext.setTransactionPolicy(oldTxEnv.oldTxPolicy);
                } else {
                    threadContext.setTransactionPolicy(null);
                }
                break block13;
            }
            try {
                txPolicy.setRollbackOnly();
                txPolicy.commit();
            }
            catch (Exception e) {
                threadContext.setDiscardInstance(true);
                logger.error("Error rolling back transaction", e);
            }
            TransactionPolicy threadContextTxPolicy = threadContext.getTransactionPolicy();
            if (threadContextTxPolicy != null) {
                try {
                    threadContextTxPolicy.setRollbackOnly();
                    threadContextTxPolicy.commit();
                }
                catch (Exception e) {
                    threadContext.setDiscardInstance(true);
                    logger.error("Error rolling back transaction", e);
                }
            }
            if (threadContextTxPolicy != null) {
                throw new SystemException(new IllegalStateException("ThreadContext is bound to another transaction " + String.valueOf(threadContextTxPolicy)));
            }
            throw new SystemException(new IllegalStateException("ThreadContext is not bound to specified transaction " + String.valueOf(threadContextTxPolicy)));
        }
    }

    public static void handleApplicationException(TransactionPolicy txPolicy, Throwable appException, boolean rollback) throws ApplicationException {
        if (rollback) {
            txPolicy.setRollbackOnly(appException);
        }
        if (!(appException instanceof ApplicationException)) {
            throw new ApplicationException(appException);
        }
    }

    public static void handleSystemException(TransactionPolicy txPolicy, Throwable sysException, ThreadContext callContext) throws InvalidateReferenceException {
        Operation operation = null;
        if (callContext != null) {
            operation = callContext.getCurrentOperation();
        }
        if (operation != null) {
            logger.error("EjbTransactionUtil.handleSystemException: " + sysException.getMessage(), sysException);
        } else {
            logger.debug("EjbTransactionUtil.handleSystemException: " + sysException.getMessage(), sysException);
        }
        txPolicy.setRollbackOnly(sysException);
        if (txPolicy.isClientTransaction()) {
            String message = "The transaction has been marked rollback only because the bean encountered a non-application exception :" + sysException.getClass().getName() + " : " + sysException.getMessage();
            TransactionRolledbackException txException = new TransactionRolledbackException(message, sysException);
            throw new InvalidateReferenceException((Exception)((Object)txException));
        }
        RemoteException re = new RemoteException("The bean encountered a non-application exception", sysException);
        throw new InvalidateReferenceException(re);
    }

    private EjbTransactionUtil() {
    }

    static {
        ThreadContext.addThreadContextListener(new ThreadContextListener(){

            @Override
            public void contextEntered(ThreadContext oldContext, ThreadContext newContext) {
                if (oldContext != null) {
                    newContext.setTransactionPolicy(oldContext.getTransactionPolicy());
                }
            }

            @Override
            public void contextExited(ThreadContext exitedContext, ThreadContext reenteredContext) {
            }
        });
    }

    private static final class CallerTransactionEnvironment {
        private final TransactionPolicy oldTxPolicy;

        private CallerTransactionEnvironment(TransactionPolicy oldTxPolicy) {
            this.oldTxPolicy = oldTxPolicy;
        }
    }
}

