/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.util;

import jakarta.el.ExpressionFactory;
import jakarta.el.ValueExpression;
import jakarta.servlet.jsp.JspApplicationContext;
import jakarta.servlet.jsp.JspFactory;
import jakarta.servlet.jsp.PageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionUtil {
    public static ValueExpression createValueExpression(PageContext pageContext, String expression, Class<?> expectedType) {
        ExpressionFactory factory = ExpressionUtil.getExpressionFactory(pageContext);
        return factory.createValueExpression(pageContext.getELContext(), expression, expectedType);
    }

    public static ExpressionFactory getExpressionFactory(PageContext pageContext) {
        JspApplicationContext appContext = JspFactory.getDefaultFactory().getJspApplicationContext(pageContext.getServletContext());
        return appContext.getExpressionFactory();
    }

    public static <T> T evaluate(ValueExpression expression, PageContext pageContext) {
        if (expression == null) {
            return null;
        }
        Object value = expression.getValue(pageContext.getELContext());
        return (T)value;
    }

    public static boolean evaluate(ValueExpression expression, PageContext pageContext, boolean fallback) {
        if (expression == null) {
            return fallback;
        }
        Boolean result = (Boolean)expression.getValue(pageContext.getELContext());
        return result == null ? fallback : result;
    }

    public static int evaluate(ValueExpression expression, PageContext pageContext, int fallback) {
        if (expression == null) {
            return fallback;
        }
        Integer result = (Integer)expression.getValue(pageContext.getELContext());
        return result == null ? fallback : result;
    }
}

