/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli;

public class LogUtil {
    private LogUtil() {
    }

    public static String escape(String input) {
        int len = input.length();
        int lastControl = -1;
        StringBuilder sb = null;
        for (int i = 0; i < len; ++i) {
            char c = input.charAt(i);
            if (Character.getType(c) != 15 || c == '\t' || c == '\n' || c == '\r') continue;
            if (lastControl == -1) {
                sb = new StringBuilder(len + 20);
            }
            sb.append(input.substring(lastControl + 1, i));
            sb.append(String.format("\\u%1$04x", c));
            lastControl = i;
        }
        if (lastControl == -1) {
            return input;
        }
        sb.append(input.substring(lastControl + 1, len));
        return sb.toString();
    }
}

