/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import org.h2.engine.CastDataProvider;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.function.FunctionN;
import org.h2.message.DbException;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public final class CoalesceFunction
extends FunctionN {
    public static final int COALESCE = 0;
    public static final int GREATEST = 1;
    public static final int LEAST = 2;
    private static final String[] NAMES = new String[]{"COALESCE", "GREATEST", "LEAST"};
    private final int function;

    public CoalesceFunction(int n) {
        this(n, new Expression[4]);
    }

    public CoalesceFunction(int n, Expression ... expressionArray) {
        super(expressionArray);
        this.function = n;
    }

    @Override
    public Value getValue(SessionLocal sessionLocal) {
        Value value = ValueNull.INSTANCE;
        block0 : switch (this.function) {
            case 0: {
                int n = this.args.length;
                for (int i = 0; i < n; ++i) {
                    Value value2 = this.args[i].getValue(sessionLocal);
                    if (value2 == ValueNull.INSTANCE) continue;
                    value = value2.convertTo(this.type, (CastDataProvider)sessionLocal);
                    break block0;
                }
                break;
            }
            case 1: 
            case 2: {
                int n = this.args.length;
                for (int i = 0; i < n; ++i) {
                    Value value3 = this.args[i].getValue(sessionLocal);
                    if (value3 == ValueNull.INSTANCE) continue;
                    value3 = value3.convertTo(this.type, (CastDataProvider)sessionLocal);
                    if (value == ValueNull.INSTANCE) {
                        value = value3;
                        continue;
                    }
                    int n2 = sessionLocal.compareTypeSafe(value, value3);
                    if (this.function == 1) {
                        if (n2 >= 0) continue;
                        value = value3;
                        continue;
                    }
                    if (n2 <= 0) continue;
                    value = value3;
                }
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        return value;
    }

    @Override
    public Expression optimize(SessionLocal sessionLocal) {
        boolean bl = this.optimizeArguments(sessionLocal, true);
        this.type = TypeInfo.getHigherType(this.args);
        if (this.type.getValueType() <= 0) {
            this.type = TypeInfo.TYPE_VARCHAR;
        }
        if (bl) {
            return TypedValueExpression.getTypedIfNull(this.getValue(sessionLocal), this.type);
        }
        return this;
    }

    @Override
    public String getName() {
        return NAMES[this.function];
    }
}

