/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.strategy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.scheduler.DeploymentOption;
import org.apache.flink.runtime.scheduler.ExecutionVertexDeploymentOption;
import org.apache.flink.runtime.scheduler.SchedulerOperations;
import org.apache.flink.runtime.scheduler.strategy.ConsumedPartitionGroup;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.ResultPartitionState;
import org.apache.flink.runtime.scheduler.strategy.SchedulingExecutionVertex;
import org.apache.flink.runtime.scheduler.strategy.SchedulingPipelinedRegion;
import org.apache.flink.runtime.scheduler.strategy.SchedulingStrategy;
import org.apache.flink.runtime.scheduler.strategy.SchedulingStrategyFactory;
import org.apache.flink.runtime.scheduler.strategy.SchedulingStrategyUtils;
import org.apache.flink.runtime.scheduler.strategy.SchedulingTopology;
import org.apache.flink.util.IterableUtils;
import org.apache.flink.util.Preconditions;

public class PipelinedRegionSchedulingStrategy
implements SchedulingStrategy {
    private final SchedulerOperations schedulerOperations;
    private final SchedulingTopology schedulingTopology;
    private final DeploymentOption deploymentOption = new DeploymentOption(false);
    private final Map<ConsumedPartitionGroup, Set<SchedulingPipelinedRegion>> partitionGroupConsumerRegions = new IdentityHashMap<ConsumedPartitionGroup, Set<SchedulingPipelinedRegion>>();
    private final Map<SchedulingPipelinedRegion, List<ExecutionVertexID>> regionVerticesSorted = new IdentityHashMap<SchedulingPipelinedRegion, List<ExecutionVertexID>>();
    private final Set<ConsumedPartitionGroup> crossRegionConsumedPartitionGroups = Collections.newSetFromMap(new IdentityHashMap());

    public PipelinedRegionSchedulingStrategy(SchedulerOperations schedulerOperations, SchedulingTopology schedulingTopology) {
        this.schedulerOperations = (SchedulerOperations)Preconditions.checkNotNull((Object)schedulerOperations);
        this.schedulingTopology = (SchedulingTopology)Preconditions.checkNotNull((Object)schedulingTopology);
        this.init();
    }

    private void init() {
        this.initCrossRegionConsumedPartitionGroups();
        this.initPartitionGroupConsumerRegions();
        for (SchedulingExecutionVertex vertex : this.schedulingTopology.getVertices()) {
            SchedulingPipelinedRegion region = (SchedulingPipelinedRegion)this.schedulingTopology.getPipelinedRegionOfVertex(vertex.getId());
            this.regionVerticesSorted.computeIfAbsent(region, r -> new ArrayList()).add(vertex.getId());
        }
    }

    private void initCrossRegionConsumedPartitionGroups() {
        IdentityHashMap<ConsumedPartitionGroup, Set> producerRegionsByConsumedPartitionGroup = new IdentityHashMap<ConsumedPartitionGroup, Set>();
        for (SchedulingPipelinedRegion pipelinedRegion : this.schedulingTopology.getAllPipelinedRegions()) {
            for (ConsumedPartitionGroup consumedPartitionGroup : pipelinedRegion.getAllBlockingConsumedPartitionGroups()) {
                producerRegionsByConsumedPartitionGroup.computeIfAbsent(consumedPartitionGroup, this::getProducerRegionsForConsumedPartitionGroup);
            }
        }
        for (SchedulingPipelinedRegion pipelinedRegion : this.schedulingTopology.getAllPipelinedRegions()) {
            for (ConsumedPartitionGroup consumedPartitionGroup : pipelinedRegion.getAllBlockingConsumedPartitionGroups()) {
                Set producerRegions = (Set)producerRegionsByConsumedPartitionGroup.get(consumedPartitionGroup);
                if (producerRegions.size() <= 1 || !producerRegions.contains(pipelinedRegion)) continue;
                this.crossRegionConsumedPartitionGroups.add(consumedPartitionGroup);
            }
        }
    }

    private Set<SchedulingPipelinedRegion> getProducerRegionsForConsumedPartitionGroup(ConsumedPartitionGroup consumedPartitionGroup) {
        Set<SchedulingPipelinedRegion> producerRegions = Collections.newSetFromMap(new IdentityHashMap());
        for (IntermediateResultPartitionID partitionId : consumedPartitionGroup) {
            producerRegions.add(this.getProducerRegion(partitionId));
        }
        return producerRegions;
    }

    private SchedulingPipelinedRegion getProducerRegion(IntermediateResultPartitionID partitionId) {
        return (SchedulingPipelinedRegion)this.schedulingTopology.getPipelinedRegionOfVertex(((SchedulingExecutionVertex)this.schedulingTopology.getResultPartition(partitionId).getProducer()).getId());
    }

    private void initPartitionGroupConsumerRegions() {
        for (SchedulingPipelinedRegion region : this.schedulingTopology.getAllPipelinedRegions()) {
            for (ConsumedPartitionGroup consumedPartitionGroup : region.getAllBlockingConsumedPartitionGroups()) {
                if (!this.crossRegionConsumedPartitionGroups.contains(consumedPartitionGroup) && !this.isExternalConsumedPartitionGroup(consumedPartitionGroup, region)) continue;
                this.partitionGroupConsumerRegions.computeIfAbsent(consumedPartitionGroup, group -> new HashSet()).add(region);
            }
        }
    }

    @Override
    public void startScheduling() {
        Set<SchedulingPipelinedRegion> sourceRegions = IterableUtils.toStream(this.schedulingTopology.getAllPipelinedRegions()).filter(this::isSourceRegion).collect(Collectors.toSet());
        this.maybeScheduleRegions(sourceRegions);
    }

    private boolean isSourceRegion(SchedulingPipelinedRegion region) {
        for (ConsumedPartitionGroup consumedPartitionGroup : region.getAllBlockingConsumedPartitionGroups()) {
            if (!this.crossRegionConsumedPartitionGroups.contains(consumedPartitionGroup) && !this.isExternalConsumedPartitionGroup(consumedPartitionGroup, region)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void restartTasks(Set<ExecutionVertexID> verticesToRestart) {
        Set<SchedulingPipelinedRegion> regionsToRestart = verticesToRestart.stream().map(this.schedulingTopology::getPipelinedRegionOfVertex).collect(Collectors.toSet());
        this.maybeScheduleRegions(regionsToRestart);
    }

    @Override
    public void onExecutionStateChange(ExecutionVertexID executionVertexId, ExecutionState executionState) {
        if (executionState == ExecutionState.FINISHED) {
            Set finishedConsumedPartitionGroups = IterableUtils.toStream(this.schedulingTopology.getVertex(executionVertexId).getProducedResults()).filter(partition -> partition.getState() == ResultPartitionState.CONSUMABLE).flatMap(partition -> partition.getConsumedPartitionGroups().stream()).filter(group -> this.crossRegionConsumedPartitionGroups.contains(group) || group.areAllPartitionsFinished()).collect(Collectors.toSet());
            Set<SchedulingPipelinedRegion> consumerRegions = finishedConsumedPartitionGroups.stream().flatMap(partitionGroup -> this.partitionGroupConsumerRegions.getOrDefault(partitionGroup, Collections.emptySet()).stream()).collect(Collectors.toSet());
            this.maybeScheduleRegions(consumerRegions);
        }
    }

    @Override
    public void onPartitionConsumable(IntermediateResultPartitionID resultPartitionId) {
    }

    private void maybeScheduleRegions(Set<SchedulingPipelinedRegion> regions) {
        List<SchedulingPipelinedRegion> regionsSorted = SchedulingStrategyUtils.sortPipelinedRegionsInTopologicalOrder(this.schedulingTopology, regions);
        HashMap<ConsumedPartitionGroup, Boolean> consumableStatusCache = new HashMap<ConsumedPartitionGroup, Boolean>();
        for (SchedulingPipelinedRegion region : regionsSorted) {
            this.maybeScheduleRegion(region, consumableStatusCache);
        }
    }

    private void maybeScheduleRegion(SchedulingPipelinedRegion region, Map<ConsumedPartitionGroup, Boolean> consumableStatusCache) {
        if (!this.areRegionInputsAllConsumable(region, consumableStatusCache)) {
            return;
        }
        Preconditions.checkState((boolean)this.areRegionVerticesAllInCreatedState(region), (Object)"BUG: trying to schedule a region which is not in CREATED state");
        List<ExecutionVertexDeploymentOption> vertexDeploymentOptions = SchedulingStrategyUtils.createExecutionVertexDeploymentOptions((Collection<ExecutionVertexID>)this.regionVerticesSorted.get(region), id -> this.deploymentOption);
        this.schedulerOperations.allocateSlotsAndDeploy(vertexDeploymentOptions);
    }

    private boolean areRegionInputsAllConsumable(SchedulingPipelinedRegion region, Map<ConsumedPartitionGroup, Boolean> consumableStatusCache) {
        for (ConsumedPartitionGroup consumedPartitionGroup : region.getAllBlockingConsumedPartitionGroups()) {
            if (!(this.crossRegionConsumedPartitionGroups.contains(consumedPartitionGroup) ? !this.isCrossRegionConsumedPartitionConsumable(consumedPartitionGroup, region) : this.isExternalConsumedPartitionGroup(consumedPartitionGroup, region) && consumableStatusCache.computeIfAbsent(consumedPartitionGroup, this::isConsumedPartitionGroupConsumable) == false)) continue;
            return false;
        }
        return true;
    }

    private boolean isConsumedPartitionGroupConsumable(ConsumedPartitionGroup consumedPartitionGroup) {
        for (IntermediateResultPartitionID partitionId : consumedPartitionGroup) {
            if (this.schedulingTopology.getResultPartition(partitionId).getState() == ResultPartitionState.CONSUMABLE) continue;
            return false;
        }
        return true;
    }

    private boolean isCrossRegionConsumedPartitionConsumable(ConsumedPartitionGroup consumedPartitionGroup, SchedulingPipelinedRegion pipelinedRegion) {
        for (IntermediateResultPartitionID partitionId : consumedPartitionGroup) {
            if (!this.isExternalConsumedPartition(partitionId, pipelinedRegion) || this.schedulingTopology.getResultPartition(partitionId).getState() == ResultPartitionState.CONSUMABLE) continue;
            return false;
        }
        return true;
    }

    private boolean areRegionVerticesAllInCreatedState(SchedulingPipelinedRegion region) {
        for (SchedulingExecutionVertex vertex : region.getVertices()) {
            if (vertex.getState() == ExecutionState.CREATED) continue;
            return false;
        }
        return true;
    }

    private boolean isExternalConsumedPartitionGroup(ConsumedPartitionGroup consumedPartitionGroup, SchedulingPipelinedRegion pipelinedRegion) {
        return this.isExternalConsumedPartition(consumedPartitionGroup.getFirst(), pipelinedRegion);
    }

    private boolean isExternalConsumedPartition(IntermediateResultPartitionID partitionId, SchedulingPipelinedRegion pipelinedRegion) {
        return !pipelinedRegion.contains(((SchedulingExecutionVertex)this.schedulingTopology.getResultPartition(partitionId).getProducer()).getId());
    }

    @VisibleForTesting
    Set<ConsumedPartitionGroup> getCrossRegionConsumedPartitionGroups() {
        return Collections.unmodifiableSet(this.crossRegionConsumedPartitionGroups);
    }

    public static class Factory
    implements SchedulingStrategyFactory {
        @Override
        public SchedulingStrategy createInstance(SchedulerOperations schedulerOperations, SchedulingTopology schedulingTopology) {
            return new PipelinedRegionSchedulingStrategy(schedulerOperations, schedulingTopology);
        }
    }
}

