/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.client;

import org.sparkproject.jetty.client.Request;
import org.sparkproject.jetty.http.HttpFields;
import org.sparkproject.jetty.http.HttpHeader;
import org.sparkproject.jetty.http.MultiPart;
import org.sparkproject.jetty.http.MultiPartFormData;
import org.sparkproject.jetty.io.Content;

public class MultiPartRequestContent
extends MultiPartFormData.ContentSource
implements Request.Content {
    private final String contentType;

    public MultiPartRequestContent() {
        this(MultiPart.generateBoundary("JettyHttpClient-", 24));
    }

    public MultiPartRequestContent(String boundary) {
        super(boundary);
        this.contentType = "multipart/form-data; boundary=\"%s\"".formatted(boundary);
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    protected HttpFields customizePartHeaders(MultiPart.Part part) {
        Request.Content requestContent;
        String contentType;
        HttpFields headers = super.customizePartHeaders(part);
        if (headers.contains(HttpHeader.CONTENT_TYPE)) {
            return headers;
        }
        Content.Source partContent = part.getContentSource();
        if (partContent instanceof Request.Content && (contentType = (requestContent = (Request.Content)partContent).getContentType()) != null) {
            return HttpFields.build(headers).put(HttpHeader.CONTENT_TYPE, contentType);
        }
        return headers;
    }
}

