/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.CreateOrReplaceable;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Nameable;
import io.fabric8.kubernetes.client.dsl.TimeoutableScalable;
import io.fabric8.kubernetes.client.dsl.Waitable;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf$;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf;
import org.apache.spark.deploy.k8s.KubernetesExecutorSpec;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.scheduler.cluster.k8s.AbstractPodsAllocator;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend;
import org.apache.spark.scheduler.cluster.k8s.KubernetesExecutorBuilder;
import org.apache.spark.util.Clock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\rg\u0001B\u0010!\u00015B\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t{\u0001\u0011\t\u0011)A\u0005}!A\u0011\t\u0001B\u0001B\u0003%!\t\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003G\u0011!\u0011\u0006A!A!\u0002\u0013\u0019\u0006\u0002\u0003,\u0001\u0005\u0003\u0005\u000b\u0011B,\t\u000bu\u0003A\u0011\u00010\t\u000f\u0019\u0004!\u0019!C\u0005O\"1A\u0010\u0001Q\u0001\n!Dq! \u0001C\u0002\u0013%a\u0010C\u0004\u0002\u0006\u0001\u0001\u000b\u0011B@\t\u0013\u0005\u001d\u0001A1A\u0005\n\u0005%\u0001\u0002CA\u0011\u0001\u0001\u0006I!a\u0003\t\u0013\u0005\r\u0002A1A\u0005\n\u0005\u0015\u0002\u0002CA\u0017\u0001\u0001\u0006I!a\n\t\u0013\u0005=\u0002A1A\u0005\u0002\u0005E\u0002\u0002CA#\u0001\u0001\u0006I!a\r\t\u0017\u0005\u001d\u0003\u00011AA\u0002\u0013%\u0011\u0011\u0002\u0005\f\u0003\u0013\u0002\u0001\u0019!a\u0001\n\u0013\tY\u0005C\u0006\u0002X\u0001\u0001\r\u0011!Q!\n\u0005-\u0001\"CA-\u0001\t\u0007I\u0011BA.\u0011!\t\u0019\u0007\u0001Q\u0001\n\u0005u\u0003\"CA3\u0001\t\u0007I\u0011BA4\u0011!\t9\b\u0001Q\u0001\n\u0005%\u0004bBA=\u0001\u0011\u0005\u00131\u0010\u0005\b\u0003\u0017\u0003A\u0011IAG\u0011\u001d\tI\n\u0001C!\u00037Cq!a*\u0001\t\u0013\tI\u000bC\u0004\u00022\u0002!I!a-\t\u000f\u0005u\u0006\u0001\"\u0011\u0002@\n9B)\u001a9m_flWM\u001c;Q_\u0012\u001c\u0018\t\u001c7pG\u0006$xN\u001d\u0006\u0003C\t\n1a\u001b\u001dt\u0015\t\u0019C%A\u0004dYV\u001cH/\u001a:\u000b\u0005\u00152\u0013!C:dQ\u0016$W\u000f\\3s\u0015\t9\u0003&A\u0003ta\u0006\u00148N\u0003\u0002*U\u00051\u0011\r]1dQ\u0016T\u0011aK\u0001\u0004_J<7\u0001A\n\u0004\u00019\u0012\u0004CA\u00181\u001b\u0005\u0001\u0013BA\u0019!\u0005U\t%m\u001d;sC\u000e$\bk\u001c3t\u00032dwnY1u_J\u0004\"a\r\u001c\u000e\u0003QR!!\u000e\u0014\u0002\u0011%tG/\u001a:oC2L!a\u000e\u001b\u0003\u000f1{wmZ5oO\u0006!1m\u001c8g!\tQ4(D\u0001'\u0013\tadEA\u0005Ta\u0006\u00148nQ8oM\u000611/Z2NOJ\u0004\"AO \n\u0005\u00013#aD*fGV\u0014\u0018\u000e^=NC:\fw-\u001a:\u0002\u001f\u0015DXmY;u_J\u0014U/\u001b7eKJ\u0004\"aL\"\n\u0005\u0011\u0003#!G&vE\u0016\u0014h.\u001a;fg\u0016CXmY;u_J\u0014U/\u001b7eKJ\f\u0001c[;cKJtW\r^3t\u00072LWM\u001c;\u0011\u0005\u001d\u0003V\"\u0001%\u000b\u0005%S\u0015AB2mS\u0016tGO\u0003\u0002L\u0019\u0006Q1.\u001e2fe:,G/Z:\u000b\u00055s\u0015a\u00024bEJL7\r\u000f\u0006\u0002\u001f\u0006\u0011\u0011n\\\u0005\u0003#\"\u0013\u0001cS;cKJtW\r^3t\u00072LWM\u001c;\u0002\u001dMt\u0017\r]:i_R\u001c8\u000b^8sKB\u0011q\u0006V\u0005\u0003+\u0002\u0012!$\u0012=fGV$xN\u001d)pIN\u001cf.\u00199tQ>$8o\u0015;pe\u0016\fQa\u00197pG.\u0004\"\u0001W.\u000e\u0003eS!A\u0017\u0014\u0002\tU$\u0018\u000e\\\u0005\u00039f\u0013Qa\u00117pG.\fa\u0001P5oSRtDcB0aC\n\u001cG-\u001a\t\u0003_\u0001AQ\u0001O\u0004A\u0002eBQ!P\u0004A\u0002yBQ!Q\u0004A\u0002\tCQ!R\u0004A\u0002\u0019CQAU\u0004A\u0002MCQAV\u0004A\u0002]\u000bQC\u001d9JIR{'+Z:pkJ\u001cW\r\u0015:pM&dW-F\u0001i!\u0011I\u0007O\u001d<\u000e\u0003)T!a\u001b7\u0002\u000f5,H/\u00192mK*\u0011QN\\\u0001\u000bG>dG.Z2uS>t'\"A8\u0002\u000bM\u001c\u0017\r\\1\n\u0005ET'a\u0002%bg\"l\u0015\r\u001d\t\u0003gRl\u0011A\\\u0005\u0003k:\u00141!\u00138u!\t9(0D\u0001y\u0015\tIh%\u0001\u0005sKN|WO]2f\u0013\tY\bPA\bSKN|WO]2f!J|g-\u001b7f\u0003Y\u0011\b/\u00133U_J+7o\\;sG\u0016\u0004&o\u001c4jY\u0016\u0004\u0013!\u00073sSZ,'\u000fU8e%\u0016\fG-\u001b8fgN$\u0016.\\3pkR,\u0012a \t\u0004g\u0006\u0005\u0011bAA\u0002]\n!Aj\u001c8h\u0003i!'/\u001b<feB{GMU3bI&tWm]:US6,w.\u001e;!\u0003%q\u0017-\\3ta\u0006\u001cW-\u0006\u0002\u0002\fA!\u0011QBA\u000e\u001d\u0011\ty!a\u0006\u0011\u0007\u0005Ea.\u0004\u0002\u0002\u0014)\u0019\u0011Q\u0003\u0017\u0002\rq\u0012xn\u001c;?\u0013\r\tIB\\\u0001\u0007!J,G-\u001a4\n\t\u0005u\u0011q\u0004\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005ea.\u0001\u0006oC6,7\u000f]1dK\u0002\nqc[;cKJtW\r^3t\tJLg/\u001a:Q_\u0012t\u0015-\\3\u0016\u0005\u0005\u001d\u0002#B:\u0002*\u0005-\u0011bAA\u0016]\n1q\n\u001d;j_:\f\u0001d[;cKJtW\r^3t\tJLg/\u001a:Q_\u0012t\u0015-\\3!\u0003%!'/\u001b<feB{G-\u0006\u0002\u00024A)1/!\u000b\u00026A!\u0011qGA!\u001b\t\tID\u0003\u0003\u0002<\u0005u\u0012!B7pI\u0016d'bAA \u0015\u0006\u0019\u0011\r]5\n\t\u0005\r\u0013\u0011\b\u0002\u0004!>$\u0017A\u00033sSZ,'\u000fU8eA\u0005)\u0011\r\u001d9JI\u0006I\u0011\r\u001d9JI~#S-\u001d\u000b\u0005\u0003\u001b\n\u0019\u0006E\u0002t\u0003\u001fJ1!!\u0015o\u0005\u0011)f.\u001b;\t\u0013\u0005U3#!AA\u0002\u0005-\u0011a\u0001=%c\u00051\u0011\r\u001d9JI\u0002\n!\u0003Z3qY>LX.\u001a8ug\u000e\u0013X-\u0019;fIV\u0011\u0011Q\f\t\u0005S\u0006}#/C\u0002\u0002b)\u0014q\u0001S1tQN+G/A\neKBdw._7f]R\u001c8I]3bi\u0016$\u0007%A\rq_\u0012$U\r\\3uS>t7i\\:u\u0003:tw\u000e^1uS>tWCAA5!\u0011\tY'!\u001e\u000e\u0005\u00055$\u0002BA8\u0003c\nA\u0001\\1oO*\u0011\u00111O\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u001e\u00055\u0014A\u00079pI\u0012+G.\u001a;j_:\u001cun\u001d;B]:|G/\u0019;j_:\u0004\u0013!B:uCJ$HCBA'\u0003{\n\t\tC\u0004\u0002\u0000e\u0001\r!a\u0003\u0002\u001b\u0005\u0004\b\u000f\\5dCRLwN\\%e\u0011\u001d\t\u0019)\u0007a\u0001\u0003\u000b\u000b\u0001c]2iK\u0012,H.\u001a:CC\u000e\\WM\u001c3\u0011\u0007=\n9)C\u0002\u0002\n\u0002\u0012\u0011eS;cKJtW\r^3t\u00072,8\u000f^3s'\u000eDW\rZ;mKJ\u0014\u0015mY6f]\u0012\f\u0011d]3u)>$\u0018\r\\#ya\u0016\u001cG/\u001a3Fq\u0016\u001cW\u000f^8sgR!\u0011QJAH\u0011\u001d\t\tJ\u0007a\u0001\u0003'\u000b1D]3t_V\u00148-\u001a)s_\u001aLG.\u001a+p)>$\u0018\r\\#yK\u000e\u001c\bCBA\u0007\u0003+3(/\u0003\u0003\u0002\u0018\u0006}!aA'ba\u0006I\u0011n\u001d#fY\u0016$X\r\u001a\u000b\u0005\u0003;\u000b\u0019\u000bE\u0002t\u0003?K1!!)o\u0005\u001d\u0011un\u001c7fC:Dq!!*\u001c\u0001\u0004\tY!\u0001\u0006fq\u0016\u001cW\u000f^8s\u0013\u0012\fqa]3u\u001d\u0006lW\r\u0006\u0004\u0002\f\u0005-\u0016Q\u0016\u0005\b\u0003\u007fb\u0002\u0019AA\u0006\u0011\u0019\ty\u000b\ba\u0001e\u0006\t\"/Z:pkJ\u001cW\r\u0015:pM&dW-\u00133\u00029M,G\u000fV1sO\u0016$X\t_3dkR|'o\u001d#fa2|\u00170\\3oiRA\u0011QJA[\u0003s\u000bY\f\u0003\u0004\u00028v\u0001\rA]\u0001\tKb\u0004Xm\u0019;fI\"9\u0011qP\u000fA\u0002\u0005-\u0001BBAX;\u0001\u0007!/\u0001\u0003ti>\u0004H\u0003BA'\u0003\u0003Dq!a \u001f\u0001\u0004\tY\u0001")
public class DeploymentPodsAllocator
extends AbstractPodsAllocator
implements Logging {
    private final SparkConf conf;
    private final SecurityManager secMgr;
    private final KubernetesExecutorBuilder executorBuilder;
    private final KubernetesClient kubernetesClient;
    private final HashMap<Object, ResourceProfile> rpIdToResourceProfile;
    private final long driverPodReadinessTimeout;
    private final String namespace;
    private final Option<String> kubernetesDriverPodName;
    private final Option<Pod> driverPod;
    private String appId;
    private final HashSet<Object> deploymentsCreated;
    private final String podDeletionCostAnnotation;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(java.util.Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private HashMap<Object, ResourceProfile> rpIdToResourceProfile() {
        return this.rpIdToResourceProfile;
    }

    private long driverPodReadinessTimeout() {
        return this.driverPodReadinessTimeout;
    }

    private String namespace() {
        return this.namespace;
    }

    private Option<String> kubernetesDriverPodName() {
        return this.kubernetesDriverPodName;
    }

    @Override
    public Option<Pod> driverPod() {
        return this.driverPod;
    }

    private String appId() {
        return this.appId;
    }

    private void appId_$eq(String x$1) {
        this.appId = x$1;
    }

    private HashSet<Object> deploymentsCreated() {
        return this.deploymentsCreated;
    }

    private String podDeletionCostAnnotation() {
        return this.podDeletionCostAnnotation;
    }

    @Override
    public void start(String applicationId, KubernetesClusterSchedulerBackend schedulerBackend) {
        this.appId_$eq(applicationId);
        this.driverPod().foreach((Function1 & Serializable)pod -> {
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable)() -> ((Waitable)((Nameable)this.kubernetesClient.pods().inNamespace(this.namespace())).withName(pod.getMetadata().getName())).waitUntilReady(this.driverPodReadinessTimeout(), TimeUnit.SECONDS));
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void setTotalExpectedExecutors(scala.collection.immutable.Map<ResourceProfile, Object> resourceProfileToTotalExecs) {
        if (this.appId() == null) {
            throw new SparkException("setTotalExpectedExecutors called before start of allocator.");
        }
        resourceProfileToTotalExecs.foreach((Function1 & Serializable)x0$1 -> {
            DeploymentPodsAllocator.$anonfun$setTotalExpectedExecutors$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public boolean isDeleted(String executorId) {
        return false;
    }

    private String setName(String applicationId, int resourceProfileId) {
        return "spark-d-" + applicationId + "-" + resourceProfileId;
    }

    private void setTargetExecutorsDeployment(int expected, String applicationId, int resourceProfileId) {
        if (this.deploymentsCreated().contains((Object)BoxesRunTime.boxToInteger((int)resourceProfileId))) {
            ((TimeoutableScalable)((Nameable)this.kubernetesClient.apps().deployments().inNamespace(this.namespace())).withName(this.setName(applicationId, resourceProfileId))).scale(expected);
            return;
        }
        KubernetesExecutorConf executorConf = KubernetesConf$.MODULE$.createExecutorConf(this.conf, "EXECID", applicationId, this.driverPod(), resourceProfileId);
        KubernetesExecutorSpec resolvedExecutorSpec = this.executorBuilder.buildFromFeatures(executorConf, this.secMgr, this.kubernetesClient, (ResourceProfile)this.rpIdToResourceProfile().apply((Object)BoxesRunTime.boxToInteger((int)resourceProfileId)));
        SparkPod executorPod = resolvedExecutorSpec.pod();
        PodSpec podSpec = executorPod.pod().getSpec();
        PodSpecBuilder podSpecBuilder = podSpec == null ? new PodSpecBuilder() : new PodSpecBuilder(podSpec);
        PodSpec podWithAttachedContainer = ((PodSpecBuilder)podSpecBuilder.addToContainers(new Container[]{executorPod.container()})).build();
        ObjectMeta meta = executorPod.pod().getMetadata();
        scala.collection.immutable.Seq<HasMetadata> resources = resolvedExecutorSpec.executorKubernetesResources();
        String failureMessage = "PersistentVolumeClaims are not supported with the deployment allocator. Please remove PVC requirements or choose a different pods allocator.";
        scala.collection.immutable.Seq dynamicVolumeClaims = (scala.collection.immutable.Seq)resources.filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DeploymentPodsAllocator.$anonfun$setTargetExecutorsDeployment$1(x$2)));
        if (dynamicVolumeClaims.nonEmpty()) {
            throw new SparkException(failureMessage);
        }
        Seq staticVolumeClaims = (Seq)Option$.MODULE$.apply((Object)podWithAttachedContainer.getVolumes()).map((Function1 & Serializable)x$3 -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(x$3).asScala().filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DeploymentPodsAllocator.$anonfun$setTargetExecutorsDeployment$3(x$4)))).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty());
        if (staticVolumeClaims.nonEmpty()) {
            throw new SparkException(failureMessage);
        }
        Map currentAnnotations = (Map)Option$.MODULE$.apply((Object)meta.getAnnotations()).map((Function1 & Serializable)x$5 -> CollectionConverters$.MODULE$.MapHasAsScala(x$5).asScala()).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty());
        if (!currentAnnotations.contains((Object)this.podDeletionCostAnnotation())) {
            Map newAnnotations = (Map)currentAnnotations.concat((IterableOnce)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.podDeletionCostAnnotation()), (Object)"0"), (List)Nil$.MODULE$));
            meta.setAnnotations(CollectionConverters$.MODULE$.MapHasAsJava(newAnnotations).asJava());
        }
        PodTemplateSpec podTemplateSpec = new PodTemplateSpec(meta, podWithAttachedContainer);
        Deployment deployment = ((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentSpecFluent)((DeploymentSpecFluent.SelectorNested)((DeploymentFluent)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName(this.setName(applicationId, resourceProfileId)).withNamespace(this.namespace())).endMetadata()).withNewSpec().withReplicas(Predef$.MODULE$.int2Integer(expected)).withNewSelector().addToMatchLabels(Constants$.MODULE$.SPARK_APP_ID_LABEL(), applicationId).addToMatchLabels(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE()).addToMatchLabels(Constants$.MODULE$.SPARK_RESOURCE_PROFILE_ID_LABEL(), Integer.toString(resourceProfileId))).endSelector()).withTemplate(podTemplateSpec)).endSpec()).build();
        KubernetesUtils$.MODULE$.addOwnerReference((Pod)this.driverPod().get(), (scala.collection.immutable.Seq<HasMetadata>)new .colon.colon((Object)deployment, (List)Nil$.MODULE$));
        ((CreateOrReplaceable)((AnyNamespaceOperation)this.kubernetesClient.apps().deployments().inNamespace(this.namespace())).resource((Object)deployment)).create();
        this.deploymentsCreated().$plus$eq((Object)BoxesRunTime.boxToInteger((int)resourceProfileId));
    }

    @Override
    public void stop(String applicationId) {
        this.deploymentsCreated().foreach((Function1)(JFunction1.mcVI.sp & Serializable)rpid -> Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable)() -> ((Deletable)((Nameable)$this.kubernetesClient.apps().deployments().inNamespace(this.namespace())).withName(this.setName(applicationId, rpid))).delete()));
    }

    public static final /* synthetic */ void $anonfun$setTotalExpectedExecutors$1(DeploymentPodsAllocator $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            ResourceProfile rp = (ResourceProfile)tuple2._1();
            int numExecs = tuple2._2$mcI$sp();
            $this.rpIdToResourceProfile().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)rp.id()), (Function0 & Serializable)() -> rp);
            $this.setTargetExecutorsDeployment(numExecs, $this.appId(), rp.id());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$setTargetExecutorsDeployment$1(HasMetadata x$2) {
        String string = x$2.getKind();
        String string2 = "PersistentVolumeClaim";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$setTargetExecutorsDeployment$3(Volume x$4) {
        return x$4.getPersistentVolumeClaim() != null;
    }

    public DeploymentPodsAllocator(SparkConf conf, SecurityManager secMgr, KubernetesExecutorBuilder executorBuilder, KubernetesClient kubernetesClient, ExecutorPodsSnapshotsStore snapshotsStore, Clock clock) {
        this.conf = conf;
        this.secMgr = secMgr;
        this.executorBuilder = executorBuilder;
        this.kubernetesClient = kubernetesClient;
        Logging.$init$((Logging)this);
        this.rpIdToResourceProfile = new HashMap();
        this.driverPodReadinessTimeout = BoxesRunTime.unboxToLong((Object)conf.get(Config$.MODULE$.KUBERNETES_ALLOCATION_DRIVER_READINESS_TIMEOUT()));
        this.namespace = (String)conf.get(Config$.MODULE$.KUBERNETES_NAMESPACE());
        this.kubernetesDriverPodName = (Option)conf.get(Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME());
        this.driverPod = this.kubernetesDriverPodName().map((Function1 & Serializable)name -> (Pod)Option$.MODULE$.apply(((Gettable)((Nameable)$this.kubernetesClient.pods().inNamespace(this.namespace())).withName(name)).get()).getOrElse((Function0 & Serializable)() -> {
            throw new SparkException("No pod was found named " + name + " in the cluster in the namespace " + this.namespace() + " (this was supposed to be the driver pod.).");
        }));
        this.deploymentsCreated = new HashSet();
        this.podDeletionCostAnnotation = "controller.kubernetes.io/pod-deletion-cost";
    }
}

