/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KeyToPath;
import io.fabric8.kubernetes.api.model.LifecycleFluent;
import io.fabric8.kubernetes.api.model.LifecycleHandlerFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.OwnerReferenceBuilder;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import java.io.Serializable;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.apache.spark.ReadOnlySparkConf;
import org.apache.spark.SecurityManager;
import org.apache.spark.SecurityManager$;
import org.apache.spark.SparkConf$;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf$;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import org.apache.spark.deploy.k8s.submit.KubernetesClientUtils$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.resource.ExecutorResourceRequest;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.resource.ResourceProfile$;
import org.apache.spark.rpc.RpcEndpointAddress$;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005=e!B\u0012%\u0001)\u0002\u0004\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011B\"\t\u0011\u001d\u0003!\u0011!Q\u0001\n!C\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\u0006'\u0002!\t\u0001\u0016\u0005\b3\u0002\u0011\r\u0011\"\u0003[\u0011\u00191\u0007\u0001)A\u00057\"9q\r\u0001b\u0001\n\u0013A\u0007B\u00027\u0001A\u0003%\u0011\u000eC\u0004n\u0001\t\u0007I\u0011\u0002.\t\r9\u0004\u0001\u0015!\u0003\\\u0011\u001dy\u0007A1A\u0005\niCa\u0001\u001d\u0001!\u0002\u0013Y\u0006bB9\u0001\u0005\u0004%IA\u001d\u0005\u0007u\u0002\u0001\u000b\u0011B:\t\u000fm\u0004!\u0019!C\u0005y\"9\u0011\u0011\u0001\u0001!\u0002\u0013i\b\u0002CA\u0002\u0001\t\u0007I\u0011\u0002?\t\u000f\u0005\u0015\u0001\u0001)A\u0005{\"A\u0011q\u0001\u0001C\u0002\u0013%A\u0010C\u0004\u0002\n\u0001\u0001\u000b\u0011B?\t\u0013\u0005-\u0001A1A\u0005\n\u00055\u0001\u0002CA\u000b\u0001\u0001\u0006I!a\u0004\t\u0013\u0005]\u0001A1A\u0005\n\u0005e\u0001\u0002CA\u0011\u0001\u0001\u0006I!a\u0007\t\u0013\u0005\r\u0002A1A\u0005\u0002\u0005\u0015\u0002\u0002CA\u001b\u0001\u0001\u0006I!a\n\t\u0011\u0005]\u0002A1A\u0005\nIDq!!\u000f\u0001A\u0003%1\u000f\u0003\u0005\u0002<\u0001\u0011\r\u0011\"\u0003[\u0011\u001d\ti\u0004\u0001Q\u0001\nmC\u0011\"a\u0010\u0001\u0005\u0004%I!!\u0011\t\u0011\u0005%\u0003\u0001)A\u0005\u0003\u0007Bq!a\u0013\u0001\t\u0013\ti\u0005C\u0004\u0002\u0002\u0002!\t%a!\u00031\t\u000b7/[2Fq\u0016\u001cW\u000f^8s\r\u0016\fG/\u001e:f'R,\u0007O\u0003\u0002&M\u0005Aa-Z1ukJ,7O\u0003\u0002(Q\u0005\u00191\u000eO:\u000b\u0005%R\u0013A\u00023fa2|\u0017P\u0003\u0002,Y\u0005)1\u000f]1sW*\u0011QFL\u0001\u0007CB\f7\r[3\u000b\u0003=\n1a\u001c:h'\u0011\u0001\u0011gN\u001e\u0011\u0005I*T\"A\u001a\u000b\u0003Q\nQa]2bY\u0006L!AN\u001a\u0003\r\u0005s\u0017PU3g!\tA\u0014(D\u0001%\u0013\tQDEA\u000eLk\n,'O\\3uKN4U-\u0019;ve\u0016\u001cuN\u001c4jON#X\r\u001d\t\u0003y}j\u0011!\u0010\u0006\u0003})\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003\u0001v\u0012q\u0001T8hO&tw-\u0001\blk\n,'O\\3uKN\u001cuN\u001c4\u0004\u0001A\u0011A)R\u0007\u0002M%\u0011aI\n\u0002\u0017\u0017V\u0014WM\u001d8fi\u0016\u001cX\t_3dkR|'oQ8oM\u000611/Z2NOJ\u0004\"!\u0013&\u000e\u0003)J!a\u0013\u0016\u0003\u001fM+7-\u001e:jifl\u0015M\\1hKJ\fqB]3t_V\u00148-\u001a)s_\u001aLG.\u001a\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!*\n\u0001B]3t_V\u00148-Z\u0005\u0003%>\u0013qBU3t_V\u00148-\u001a)s_\u001aLG.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\tU3v\u000b\u0017\t\u0003q\u0001AQ!\u0011\u0003A\u0002\rCQa\u0012\u0003A\u0002!CQ\u0001\u0014\u0003A\u00025\u000ba#\u001a=fGV$xN]\"p]R\f\u0017N\\3s\u00136\fw-Z\u000b\u00027B\u0011Al\u0019\b\u0003;\u0006\u0004\"AX\u001a\u000e\u0003}S!\u0001\u0019\"\u0002\rq\u0012xn\u001c;?\u0013\t\u00117'\u0001\u0004Qe\u0016$WMZ\u0005\u0003I\u0016\u0014aa\u0015;sS:<'B\u000124\u0003])\u00070Z2vi>\u00148i\u001c8uC&tWM]%nC\u001e,\u0007%\u0001\tcY>\u001c7.T1oC\u001e,'\u000fU8siV\t\u0011\u000e\u0005\u00023U&\u00111n\r\u0002\u0004\u0013:$\u0018!\u00052m_\u000e\\W*\u00198bO\u0016\u0014\bk\u001c:uA\u0005)R\r_3dkR|'\u000fU8e\u001d\u0006lW\r\u0015:fM&D\u0018AF3yK\u000e,Ho\u001c:Q_\u0012t\u0015-\\3Qe\u00164\u0017\u000e\u001f\u0011\u0002\u001b\u0011\u0014\u0018N^3s\u0003\u0012$'/Z:t\u00039!'/\u001b<fe\u0006#GM]3tg\u0002\n\u0011\u0002\u001a:jm\u0016\u0014XK\u001d7\u0016\u0003M\u0004\"\u0001^=\u000e\u0003UT!A^<\u0002\t1\fgn\u001a\u0006\u0002q\u0006!!.\u0019<b\u0013\t!W/\u0001\u0006ee&4XM]+sY\u0002\n\u0001#[:EK\u001a\fW\u000f\u001c;Qe>4\u0017\u000e\\3\u0016\u0003u\u0004\"A\r@\n\u0005}\u001c$a\u0002\"p_2,\u0017M\\\u0001\u0012SN$UMZ1vYR\u0004&o\u001c4jY\u0016\u0004\u0013aC5t!f$\bn\u001c8BaB\fA\"[:QsRDwN\\!qa\u0002\n\u0001\u0003Z5tC\ndWmQ8oM&<W*\u00199\u0002#\u0011L7/\u00192mK\u000e{gNZ5h\u001b\u0006\u0004\b%A\u000bnS:LW.^7NK6|'/_(wKJDW-\u00193\u0016\u0005\u0005=\u0001c\u0001\u001a\u0002\u0012%\u0019\u00111C\u001a\u0003\t1{gnZ\u0001\u0017[&t\u0017.\\;n\u001b\u0016lwN]=Pm\u0016\u0014\b.Z1eA\u0005!R.Z7pef|e/\u001a:iK\u0006$g)Y2u_J,\"!a\u0007\u0011\u0007I\ni\"C\u0002\u0002 M\u0012a\u0001R8vE2,\u0017!F7f[>\u0014\u0018p\u0014<fe\",\u0017\r\u001a$bGR|'\u000fI\u0001\u000eKb,7MU3t_V\u00148-Z:\u0016\u0005\u0005\u001d\u0002\u0003BA\u0015\u0003_q1ATA\u0016\u0013\r\ticT\u0001\u0010%\u0016\u001cx.\u001e:dKB\u0013xNZ5mK&!\u0011\u0011GA\u001a\u0005m)\u00050Z2vi>\u0014(+Z:pkJ\u001cWm](s\t\u00164\u0017-\u001e7ug*\u0019\u0011QF(\u0002\u001d\u0015DXm\u0019*fg>,(oY3tA\u0005!R\r_3dkR|'/T3n_JL8\u000b\u001e:j]\u001e\fQ#\u001a=fGV$xN]'f[>\u0014\u0018p\u0015;sS:<\u0007%\u0001\u000bfq\u0016\u001cW\u000f^8s\u0007>\u0014Xm\u001d*fcV,7\u000f^\u0001\u0016Kb,7-\u001e;pe\u000e{'/Z:SKF,Xm\u001d;!\u0003I)\u00070Z2vi>\u0014H*[7ji\u000e{'/Z:\u0016\u0005\u0005\r\u0003\u0003\u0002\u001a\u0002FmK1!a\u00124\u0005\u0019y\u0005\u000f^5p]\u0006\u0019R\r_3dkR|'\u000fT5nSR\u001cuN]3tA\u0005\u0001#-^5mI\u0016CXmY;u_J\u0014Vm]8ve\u000e,7/U;b]RLG/[3t)\u0011\ty%!\u001d\u0011\rq\u000b\tfWA+\u0013\r\t\u0019&\u001a\u0002\u0004\u001b\u0006\u0004\b\u0003BA,\u0003[j!!!\u0017\u000b\t\u0005m\u0013QL\u0001\u0006[>$W\r\u001c\u0006\u0005\u0003?\n\t'A\u0002ba&TA!a\u0019\u0002f\u0005Q1.\u001e2fe:,G/Z:\u000b\t\u0005\u001d\u0014\u0011N\u0001\bM\u0006\u0014'/[29\u0015\t\tY'\u0001\u0002j_&!\u0011qNA-\u0005!\tV/\u00198uSRL\bbBA:C\u0001\u0007\u0011QO\u0001\u0010GV\u001cHo\\7SKN|WO]2fgB)A,a\u001e\u0002|%\u0019\u0011\u0011P3\u0003\u0007M+G\u000fE\u0002O\u0003{J1!a P\u0005])\u00050Z2vi>\u0014(+Z:pkJ\u001cWMU3rk\u0016\u001cH/\u0001\u0007d_:4\u0017nZ;sKB{G\r\u0006\u0003\u0002\u0006\u0006-\u0005c\u0001#\u0002\b&\u0019\u0011\u0011\u0012\u0014\u0003\u0011M\u0003\u0018M]6Q_\u0012Dq!!$#\u0001\u0004\t))A\u0002q_\u0012\u0004")
public class BasicExecutorFeatureStep
implements KubernetesFeatureConfigStep,
Logging {
    private final KubernetesExecutorConf kubernetesConf;
    private final SecurityManager secMgr;
    private final ResourceProfile resourceProfile;
    private final String executorContainerImage;
    private final int blockManagerPort;
    private final String executorPodNamePrefix;
    private final String driverAddress;
    private final String driverUrl;
    private final boolean isDefaultProfile;
    private final boolean isPythonApp;
    private final boolean disableConfigMap;
    private final long minimumMemoryOverhead;
    private final double memoryOverheadFactor;
    private final ResourceProfile.ExecutorResourcesOrDefaults execResources;
    private final String executorMemoryString;
    private final String executorCoresRequest;
    private final Option<String> executorLimitCores;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public scala.collection.immutable.Map<String, String> getAdditionalPodSystemProperties() {
        return KubernetesFeatureConfigStep.getAdditionalPodSystemProperties$(this);
    }

    @Override
    public scala.collection.immutable.Seq<HasMetadata> getAdditionalPreKubernetesResources() {
        return KubernetesFeatureConfigStep.getAdditionalPreKubernetesResources$(this);
    }

    @Override
    public scala.collection.immutable.Seq<HasMetadata> getAdditionalKubernetesResources() {
        return KubernetesFeatureConfigStep.getAdditionalKubernetesResources$(this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String executorContainerImage() {
        return this.executorContainerImage;
    }

    private int blockManagerPort() {
        return this.blockManagerPort;
    }

    private String executorPodNamePrefix() {
        return this.executorPodNamePrefix;
    }

    private String driverAddress() {
        return this.driverAddress;
    }

    private String driverUrl() {
        return this.driverUrl;
    }

    private boolean isDefaultProfile() {
        return this.isDefaultProfile;
    }

    private boolean isPythonApp() {
        return this.isPythonApp;
    }

    private boolean disableConfigMap() {
        return this.disableConfigMap;
    }

    private long minimumMemoryOverhead() {
        return this.minimumMemoryOverhead;
    }

    private double memoryOverheadFactor() {
        return this.memoryOverheadFactor;
    }

    public ResourceProfile.ExecutorResourcesOrDefaults execResources() {
        return this.execResources;
    }

    private String executorMemoryString() {
        return this.executorMemoryString;
    }

    private String executorCoresRequest() {
        return this.executorCoresRequest;
    }

    private Option<String> executorLimitCores() {
        return this.executorLimitCores;
    }

    private scala.collection.immutable.Map<String, Quantity> buildExecutorResourcesQuantities(Set<ExecutorResourceRequest> customResources) {
        return ((IterableOnceOps)customResources.map((Function1 & Serializable)request -> {
            if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(request.vendor()))) {
                throw new SparkException("Resource: " + request.resourceName() + " was requested, but vendor was not specified.");
            }
            String vendorDomain = request.vendor();
            Quantity quantity = new Quantity(Long.toString(request.amount()));
            return new Tuple2((Object)KubernetesConf$.MODULE$.buildKubernetesResourceName(vendorDomain, request.resourceName()), (Object)quantity);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    public SparkPod configurePod(SparkPod pod2) {
        String string;
        Option ownerReference;
        Container containerWithLifecycle;
        String hostname;
        scala.collection.immutable.Seq<KeyToPath> keyToPaths;
        String configMapName;
        String name2;
        block11: {
            block10: {
                Container container;
                Container containerWithLimitCores;
                Nil$ requiredPorts;
                name2 = this.executorPodNamePrefix() + "-exec-" + this.kubernetesConf.executorId();
                configMapName = KubernetesClientUtils$.MODULE$.configMapNameExecutor();
                scala.collection.immutable.Map<String, String> confFilesMap = KubernetesClientUtils$.MODULE$.buildSparkConfDirFilesMap(configMapName, this.kubernetesConf.sparkConf(), (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
                keyToPaths = KubernetesClientUtils$.MODULE$.buildKeyToPathObjects(confFilesMap);
                hostname = name2.substring(Math.max(0, name2.length() - Config$.MODULE$.KUBERNETES_DNS_LABEL_NAME_MAX_LENGTH())).replaceAll("^[^\\w]+", "").replaceAll("[^\\w-]+", "_");
                if (this.kubernetesConf.get(Config$.MODULE$.KUBERNETES_ALLOCATION_PODS_ALLOCATOR()).equals("deployment")) {
                    hostname = hostname.toLowerCase(Locale.ROOT);
                }
                Quantity executorMemoryQuantity = new Quantity(this.execResources().totalMemMiB() + "Mi");
                Quantity executorCpuQuantity = new Quantity(this.executorCoresRequest());
                scala.collection.immutable.Map<String, Quantity> executorResourceQuantities = this.buildExecutorResourcesQuantities((Set<ExecutorResourceRequest>)this.execResources().customResources().values().toSet());
                scala.collection.immutable.Seq sparkAuthSecret = (scala.collection.immutable.Seq)Option$.MODULE$.apply((Object)this.secMgr.getSecretKey()).map((Function1 & Serializable)x0$1 -> {
                    String string = x0$1;
                    if (string != null) {
                        String string2 = string;
                        if (((Option)$this.kubernetesConf.get(package$.MODULE$.AUTH_SECRET_FILE_EXECUTOR())).isEmpty()) {
                            return new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecurityManager$.MODULE$.ENV_AUTH_SECRET()), (Object)string2), (List)Nil$.MODULE$);
                        }
                    }
                    return Nil$.MODULE$;
                }).getOrElse((Function0 & Serializable)() -> Nil$.MODULE$);
                scala.collection.immutable.Seq userOpts = (scala.collection.immutable.Seq)Option$.MODULE$.option2Iterable((Option)this.kubernetesConf.get(package$.MODULE$.EXECUTOR_JAVA_OPTIONS())).toSeq().flatMap((Function1 & Serializable)opts -> {
                    String subsOpts = Utils$.MODULE$.substituteAppNExecIds(opts, $this.kubernetesConf.appId(), $this.kubernetesConf.executorId());
                    return Utils$.MODULE$.splitCommandString(subsOpts);
                });
                scala.collection.immutable.Seq sparkOpts = Utils$.MODULE$.sparkJavaOpts((ReadOnlySparkConf)this.kubernetesConf.sparkConf(), (Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)SparkConf$.MODULE$.isExecutorStartupConf(name)));
                scala.collection.immutable.Map allOpts = ((IterableOnceOps)((IterableOps)((IterableOps)userOpts.$plus$plus((IterableOnce)sparkOpts)).zipWithIndex()).map((Function1 & Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        String opt = (String)tuple2._1();
                        int index = tuple2._2$mcI$sp();
                        return new Tuple2((Object)(Constants$.MODULE$.ENV_JAVA_OPT_PREFIX() + index), (Object)opt);
                    }
                    throw new MatchError((Object)tuple2);
                })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                scala.collection.immutable.Map attributes = ((Option)this.kubernetesConf.get(UI$.MODULE$.CUSTOM_EXECUTOR_LOG_URL())).isDefined() ? (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_EXECUTOR_ATTRIBUTE_APP_ID()), (Object)this.kubernetesConf.appId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_EXECUTOR_ATTRIBUTE_EXECUTOR_ID()), (Object)this.kubernetesConf.executorId())})) : Predef$.MODULE$.Map().empty();
                scala.collection.immutable.Seq executorEnv = (scala.collection.immutable.Seq)KubernetesUtils$.MODULE$.buildEnvVars((scala.collection.immutable.Seq<Tuple2<String, String>>)((scala.collection.immutable.Seq)((IterableOps)((IterableOps)((IterableOps)((IterableOps)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_DRIVER_URL()), (Object)this.driverUrl()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_EXECUTOR_CORES()), (Object)this.execResources().cores().get().toString()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_EXECUTOR_MEMORY()), (Object)this.executorMemoryString()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_APPLICATION_ID()), (Object)this.kubernetesConf.appId()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_SPARK_CONF_DIR()), (Object)Constants$.MODULE$.SPARK_CONF_DIR_INTERNAL()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_EXECUTOR_ID()), (Object)this.kubernetesConf.executorId()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_RESOURCE_PROFILE_ID()), (Object)Integer.toString(this.resourceProfile.id())), (List)Nil$.MODULE$))))))).$plus$plus((IterableOnce)attributes)).$plus$plus(this.kubernetesConf.environment())).$plus$plus((IterableOnce)sparkAuthSecret)).$plus$plus((IterableOnce)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_CLASSPATH()), ((Option)this.kubernetesConf.get(package$.MODULE$.EXECUTOR_CLASS_PATH())).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), (List)Nil$.MODULE$))).$plus$plus((IterableOnce)allOpts))).$plus$plus(KubernetesUtils$.MODULE$.buildEnvVarsWithFieldRef((scala.collection.immutable.Seq<Tuple3<String, String, String>>)new .colon.colon((Object)new Tuple3((Object)Constants$.MODULE$.ENV_EXECUTOR_POD_IP(), (Object)"v1", (Object)"status.podIP"), (List)new .colon.colon((Object)new Tuple3((Object)Constants$.MODULE$.ENV_EXECUTOR_POD_NAME(), (Object)"v1", (Object)"metadata.name"), (List)Nil$.MODULE$))));
                executorEnv.find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BasicExecutorFeatureStep.$anonfun$configurePod$6(x$1))).foreach((Function1 & Serializable)e -> {
                    e.setValue(e.getValue().replaceAll(Constants$.MODULE$.ENV_APPLICATION_ID(), this.kubernetesConf.appId()).replaceAll(Constants$.MODULE$.ENV_EXECUTOR_ID(), this.kubernetesConf.executorId()));
                    return BoxedUnit.UNIT;
                });
                Object object = requiredPorts = this.blockManagerPort() != 0 ? (scala.collection.immutable.Seq)new .colon.colon((Object)new Tuple2((Object)Constants$.MODULE$.BLOCK_MANAGER_PORT_NAME(), (Object)BoxesRunTime.boxToInteger((int)this.blockManagerPort())), (List)Nil$.MODULE$).map((Function1 & Serializable)x0$3 -> {
                    Tuple2 tuple2 = x0$3;
                    if (tuple2 != null) {
                        String name = (String)tuple2._1();
                        int port = tuple2._2$mcI$sp();
                        return ((ContainerPortBuilder)new ContainerPortBuilder().withName(name).withContainerPort(Predef$.MODULE$.int2Integer(port))).build();
                    }
                    throw new MatchError((Object)tuple2);
                }) : Nil$.MODULE$;
                if (!this.isDefaultProfile() && pod2.container() != null && pod2.container().getResources() != null) {
                    this.logDebug((Function0<String>)(Function0 & Serializable)() -> "NOT using the default profile and removing template resources");
                    pod2.container().setResources(new ResourceRequirements());
                }
                Container executorContainer = ((ContainerBuilder)((ContainerFluent)((ContainerFluent.EnvNested)((ContainerFluent)((ContainerFluent.ResourcesNested)new ContainerBuilder(pod2.container()).withName((String)Option$.MODULE$.apply((Object)pod2.container().getName()).getOrElse((Function0 & Serializable)() -> Constants$.MODULE$.DEFAULT_EXECUTOR_CONTAINER_NAME())).withImage(this.executorContainerImage()).withImagePullPolicy(this.kubernetesConf.imagePullPolicy()).editOrNewResources().addToRequests("memory", executorMemoryQuantity).addToLimits("memory", executorMemoryQuantity).addToRequests("cpu", executorCpuQuantity).addToLimits(CollectionConverters$.MODULE$.MapHasAsJava(executorResourceQuantities).asJava())).endResources()).addNewEnv().withName(Constants$.MODULE$.ENV_SPARK_USER()).withValue(Utils$.MODULE$.getCurrentUserName())).endEnv()).addAllToEnv((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)executorEnv).asJava()).addAllToPorts((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)requiredPorts).asJava()).addToArgs(new String[]{"executor"})).build();
                Container executorContainerWithConfVolume = this.disableConfigMap() ? executorContainer : ((ContainerBuilder)((ContainerFluent.VolumeMountsNested)new ContainerBuilder(executorContainer).addNewVolumeMount().withName(Constants$.MODULE$.SPARK_CONF_VOLUME_EXEC()).withMountPath(Constants$.MODULE$.SPARK_CONF_DIR_INTERNAL())).endVolumeMount()).build();
                Container container2 = containerWithLimitCores = this.isDefaultProfile() ? (Container)this.executorLimitCores().map((Function1 & Serializable)limitCores -> {
                    Quantity executorCpuLimitQuantity = new Quantity(limitCores);
                    if (executorCpuLimitQuantity.compareTo(executorCpuQuantity) < 0) {
                        throw new IllegalArgumentException("The executor cpu request (" + executorCpuQuantity + ") should be less than or equal to cpu limit (" + executorCpuLimitQuantity + ")");
                    }
                    return ((ContainerBuilder)((ContainerFluent.ResourcesNested)new ContainerBuilder(executorContainerWithConfVolume).editResources().addToLimits("cpu", executorCpuLimitQuantity)).endResources()).build();
                }).getOrElse((Function0 & Serializable)() -> executorContainerWithConfVolume) : executorContainerWithConfVolume;
                if (!this.kubernetesConf.workerDecommissioning()) {
                    this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Decommissioning not enabled, skipping shutdown script");
                    container = containerWithLimitCores;
                } else {
                    this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Adding decommission script to lifecycle");
                    container = ((ContainerBuilder)((ContainerFluent.LifecycleNested)((LifecycleFluent.PreStopNested)((LifecycleHandlerFluent.ExecNested)new ContainerBuilder(containerWithLimitCores).withNewLifecycle().withNewPreStop().withNewExec().addToCommand(new String[]{this.kubernetesConf.get(Config$.MODULE$.DECOMMISSION_SCRIPT())})).endExec()).endPreStop()).endLifecycle()).build();
                }
                containerWithLifecycle = container;
                ownerReference = this.kubernetesConf.driverPod().map((Function1 & Serializable)pod -> ((OwnerReferenceBuilder)new OwnerReferenceBuilder().withController(Predef$.MODULE$.boolean2Boolean(true)).withApiVersion(pod.getApiVersion()).withKind(pod.getKind()).withName(pod.getMetadata().getName()).withUid(pod.getMetadata().getUid())).build());
                String string2 = this.kubernetesConf.get(Config$.MODULE$.KUBERNETES_ALLOCATION_PODS_ALLOCATOR());
                switch (string2 == null ? 0 : string2.hashCode()) {
                    case 1736521110: {
                        if ("statefulset".equals(string2)) {
                            break;
                        }
                        break block10;
                    }
                    case 1939520197: {
                        if ("deployment".equals(string2)) {
                            break;
                        }
                        break block10;
                    }
                    default: {
                        break block10;
                    }
                }
                string = "Always";
                break block11;
            }
            string = "Never";
        }
        String policy = string;
        PodFluent.SpecNested executorPodBuilder = (PodFluent.SpecNested)((PodFluent)((PodFluent.MetadataNested)new PodBuilder(pod2.pod()).editOrNewMetadata().withName(name2).addToLabels(CollectionConverters$.MODULE$.MapHasAsJava(this.kubernetesConf.labels()).asJava()).addToAnnotations(CollectionConverters$.MODULE$.MapHasAsJava(this.kubernetesConf.annotations()).asJava()).addToOwnerReferences((OwnerReference[])Option$.MODULE$.option2Iterable(ownerReference).toSeq().toArray(ClassTag$.MODULE$.apply(OwnerReference.class)))).endMetadata()).editOrNewSpec().withHostname(hostname).withRestartPolicy(policy).withTerminationGracePeriodSeconds(Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)this.kubernetesConf.get(Config$.MODULE$.KUBERNETES_EXECUTOR_TERMINATION_GRACE_PERIOD_SECONDS())))).addToNodeSelector(CollectionConverters$.MODULE$.MapHasAsJava(this.kubernetesConf.nodeSelector()).asJava()).addToNodeSelector(CollectionConverters$.MODULE$.MapHasAsJava(this.kubernetesConf.executorNodeSelector()).asJava()).addToImagePullSecrets((LocalObjectReference[])this.kubernetesConf.imagePullSecrets().toArray(ClassTag$.MODULE$.apply(LocalObjectReference.class)));
        Pod executorPod = this.disableConfigMap() ? ((PodBuilder)executorPodBuilder.endSpec()).build() : ((PodBuilder)((PodFluent.SpecNested)((PodSpecFluent.VolumesNested)((VolumeFluent.ConfigMapNested)executorPodBuilder.addNewVolume().withName(Constants$.MODULE$.SPARK_CONF_VOLUME_EXEC()).withNewConfigMap().withItems(CollectionConverters$.MODULE$.SeqHasAsJava(keyToPaths).asJava()).withName(configMapName)).endConfigMap()).endVolume()).endSpec()).build();
        PodSpec podSpec = executorPod.getSpec();
        this.kubernetesConf.schedulerName().foreach((Function1 & Serializable)x$1 -> {
            podSpec.setSchedulerName(x$1);
            return BoxedUnit.UNIT;
        });
        return new SparkPod(executorPod, containerWithLifecycle);
    }

    public static final /* synthetic */ boolean $anonfun$configurePod$6(EnvVar x$1) {
        String string = x$1.getName();
        String string2 = Constants$.MODULE$.ENV_EXECUTOR_DIRS();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public BasicExecutorFeatureStep(KubernetesExecutorConf kubernetesConf, SecurityManager secMgr, ResourceProfile resourceProfile) {
        this.kubernetesConf = kubernetesConf;
        this.secMgr = secMgr;
        this.resourceProfile = resourceProfile;
        KubernetesFeatureConfigStep.$init$(this);
        Logging.$init$((Logging)this);
        this.executorContainerImage = kubernetesConf.image();
        this.blockManagerPort = kubernetesConf.sparkConf().getInt(package$.MODULE$.BLOCK_MANAGER_PORT().key(), Constants$.MODULE$.DEFAULT_BLOCKMANAGER_PORT());
        Predef$.MODULE$.require(this.blockManagerPort() == 0 || 1024 <= this.blockManagerPort() && this.blockManagerPort() < 65536, (Function0 & Serializable)() -> "port number must be 0 or in [1024, 65535]");
        this.executorPodNamePrefix = kubernetesConf.resourceNamePrefix();
        this.driverAddress = BoxesRunTime.unboxToBoolean((Object)kubernetesConf.get(Config$.MODULE$.KUBERNETES_EXECUTOR_USE_DRIVER_POD_IP())) ? (String)kubernetesConf.get(package$.MODULE$.DRIVER_BIND_ADDRESS()) : (String)kubernetesConf.get(package$.MODULE$.DRIVER_HOST_ADDRESS());
        this.driverUrl = RpcEndpointAddress$.MODULE$.apply(this.driverAddress(), kubernetesConf.sparkConf().getInt(package$.MODULE$.DRIVER_PORT().key(), Constants$.MODULE$.DEFAULT_DRIVER_PORT()), CoarseGrainedSchedulerBackend$.MODULE$.ENDPOINT_NAME()).toString();
        this.isDefaultProfile = resourceProfile.id() == ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID();
        String string = kubernetesConf.get(Config$.MODULE$.APP_RESOURCE_TYPE());
        Some some = new Some((Object)Constants$.MODULE$.APP_RESOURCE_TYPE_PYTHON());
        this.isPythonApp = !(string != null ? !string.equals(some) : some != null);
        this.disableConfigMap = BoxesRunTime.unboxToBoolean((Object)kubernetesConf.get(Config$.MODULE$.KUBERNETES_EXECUTOR_DISABLE_CONFIGMAP()));
        this.minimumMemoryOverhead = BoxesRunTime.unboxToLong(kubernetesConf.get(package$.MODULE$.EXECUTOR_MIN_MEMORY_OVERHEAD()));
        this.memoryOverheadFactor = kubernetesConf.contains(package$.MODULE$.EXECUTOR_MEMORY_OVERHEAD_FACTOR()) ? BoxesRunTime.unboxToDouble(kubernetesConf.get(package$.MODULE$.EXECUTOR_MEMORY_OVERHEAD_FACTOR())) : BoxesRunTime.unboxToDouble((Object)kubernetesConf.get(Config$.MODULE$.MEMORY_OVERHEAD_FACTOR()));
        this.execResources = ResourceProfile$.MODULE$.getResourcesForClusterManager(resourceProfile.id(), resourceProfile.executorResources(), this.minimumMemoryOverhead(), this.memoryOverheadFactor(), kubernetesConf.sparkConf(), this.isPythonApp(), Predef$.MODULE$.Map().empty());
        Predef$.MODULE$.assert(this.execResources().cores().nonEmpty());
        this.executorMemoryString = this.execResources().executorMemoryMiB() + "m";
        this.executorCoresRequest = this.isDefaultProfile() && kubernetesConf.sparkConf().contains(Config$.MODULE$.KUBERNETES_EXECUTOR_REQUEST_CORES()) ? (String)((Option)kubernetesConf.get(Config$.MODULE$.KUBERNETES_EXECUTOR_REQUEST_CORES())).get() : this.execResources().cores().get().toString();
        this.executorLimitCores = (Option)kubernetesConf.get(Config$.MODULE$.KUBERNETES_EXECUTOR_LIMIT_CORES());
    }
}

