/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.classic;

import java.io.Serializable;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.analysis.NamedStreamingRelation;
import org.apache.spark.sql.catalyst.analysis.NamedStreamingRelation$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.UnresolvedDataSource;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.classic.ClassicConversions$;
import org.apache.spark.sql.classic.Dataset;
import org.apache.spark.sql.classic.Dataset$;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.json.JsonUtils$;
import org.apache.spark.sql.execution.datasources.xml.XmlUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Evolving
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015h\u0001B\u0014)\u0005MB\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\u0007}\u0001!\tAK \t\u000b\t\u0003A\u0011A\"\t\u000bQ\u0003A\u0011A+\t\u000bu\u0003A\u0011\u00010\t\u000b\r\u0004A\u0011\u00013\t\r1\u0004A\u0011\u0001\u0016n\u0011\u00159\b\u0001\"\u0001y\u0011\u001d\t\t\u0001\u0001C\u0005\u0003\u0007Aaa\u001e\u0001\u0005\u0002\u0005E\u0001bBA\u000b\u0001\u0011\u0005\u0011q\u0003\u0005\b\u0003;\u0001A\u0011KA\u0010\u0011\u001d\tY\u0003\u0001C)\u0003[Aq!a\f\u0001\t#\ni\u0003\u0003\u0004U\u0001\u0011\u0005\u0013\u0011\u0007\u0005\u0007;\u0002!\t%a\u000e\t\ru\u0003A\u0011IA\"\u0011\u0019i\u0006\u0001\"\u0011\u0002P!11\r\u0001C!\u00037Bq!!\u001c\u0001\t\u0003\ny\u0007C\u0004\u0002t\u0001!\t%!\u001e\t\u000f\u0005e\u0004\u0001\"\u0011\u0002|!9\u0011q\u0010\u0001\u0005B\u0005\u0005\u0005bBAC\u0001\u0011\u0005\u0013q\u0011\u0005\b\u0003\u0017\u0003A\u0011IAG\u0011\u001d\t\t\n\u0001C!\u0003'C\u0001B\u0012\u0001A\u0002\u0013%\u0011Q\u0014\u0005\n\u0003?\u0003\u0001\u0019!C\u0005\u0003CCq!a*\u0001A\u0003&q\tC\u0005\u0002*\u0002\u0001\r\u0011\"\u0003\u0002,\"I\u0011q\u0016\u0001A\u0002\u0013%\u0011\u0011\u0017\u0005\t\u0003k\u0003\u0001\u0015)\u0003\u0002.\"I\u0011q\u0017\u0001A\u0002\u0013%\u0011\u0011\u0018\u0005\n\u0003\u0013\u0004\u0001\u0019!C\u0005\u0003\u0017D\u0001\"a4\u0001A\u0003&\u00111\u0018\u0005\n\u0003#\u0004\u0001\u0019!C\u0005\u0003'D\u0011\"!6\u0001\u0001\u0004%I!a6\t\u0011\u0005m\u0007\u0001)Q\u0005\u0003\u0013\u0011\u0001\u0003R1uCN#(/Z1n%\u0016\fG-\u001a:\u000b\u0005%R\u0013aB2mCN\u001c\u0018n\u0019\u0006\u0003W1\n1a]9m\u0015\tic&A\u0003ta\u0006\u00148N\u0003\u00020a\u00051\u0011\r]1dQ\u0016T\u0011!M\u0001\u0004_J<7\u0001A\n\u0003\u0001Q\u0002\"!\u000e\u001d\u000e\u0003YR!a\u000e\u0016\u0002\u0013M$(/Z1nS:<\u0017BA\u00147\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\tYD(D\u0001)\u0013\ti\u0004F\u0001\u0007Ta\u0006\u00148nU3tg&|g.\u0001\u0004=S:LGO\u0010\u000b\u0003\u0001\u0006\u0003\"a\u000f\u0001\t\u000be\u0012\u0001\u0019\u0001\u001e\u0002\r\u0019|'/\\1u)\t!U)D\u0001\u0001\u0011\u001515\u00011\u0001H\u0003\u0019\u0019x.\u001e:dKB\u0011\u0001*\u0015\b\u0003\u0013>\u0003\"AS'\u000e\u0003-S!\u0001\u0014\u001a\u0002\rq\u0012xn\u001c;?\u0015\u0005q\u0015!B:dC2\f\u0017B\u0001)N\u0003\u0019\u0001&/\u001a3fM&\u0011!k\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Ak\u0015AB:dQ\u0016l\u0017\r\u0006\u0002E-\")A\u000b\u0002a\u0001/B\u0011\u0001lW\u0007\u00023*\u0011!LK\u0001\u0006if\u0004Xm]\u0005\u00039f\u0013!b\u0015;sk\u000e$H+\u001f9f\u0003\u0019y\u0007\u000f^5p]R\u0019AiX1\t\u000b\u0001,\u0001\u0019A$\u0002\u0007-,\u0017\u0010C\u0003c\u000b\u0001\u0007q)A\u0003wC2,X-A\u0004paRLwN\\:\u0015\u0005\u0011+\u0007\"B2\u0007\u0001\u00041\u0007\u0003B4k\u000f\u001ek\u0011\u0001\u001b\u0006\u0003S6\u000b!bY8mY\u0016\u001cG/[8o\u0013\tY\u0007NA\u0002NCB\fAA\\1nKR\u0011AI\u001c\u0005\u0006_\u001e\u0001\raR\u0001\u000bg>,(oY3OC6,\u0007FA\u0004r!\t\u0011X/D\u0001t\u0015\t!H&\u0001\u0006b]:|G/\u0019;j_:L!A^:\u0003\u0019\u0015C\b/\u001a:j[\u0016tG/\u00197\u0002\t1|\u0017\r\u001a\u000b\u0002sB\u0011!0 \b\u0003wmL!\u0001 \u0015\u0002\u000fA\f7m[1hK&\u0011ap \u0002\n\t\u0006$\u0018M\u0012:b[\u0016T!\u0001 \u0015\u0002\u00191|\u0017\rZ%oi\u0016\u0014h.\u00197\u0015\u0007e\f)\u0001C\u0004\u0002\b%\u0001\r!!\u0003\u0002\tA\fG\u000f\u001b\t\u0006\u0003\u0017\tiaR\u0007\u0002\u001b&\u0019\u0011qB'\u0003\r=\u0003H/[8o)\rI\u00181\u0003\u0005\u0007\u0003\u000fQ\u0001\u0019A$\u0002\u000bQ\f'\r\\3\u0015\u0007e\fI\u0002\u0003\u0004\u0002\u001c-\u0001\raR\u0001\ni\u0006\u0014G.\u001a(b[\u0016\fq#Y:tKJ$hj\\*qK\u000eLg-[3e'\u000eDW-\\1\u0015\t\u0005\u0005\u0012q\u0005\t\u0005\u0003\u0017\t\u0019#C\u0002\u0002&5\u0013A!\u00168ji\"1\u0011\u0011\u0006\u0007A\u0002\u001d\u000b\u0011b\u001c9fe\u0006$\u0018n\u001c8\u0002%Y\fG.\u001b3bi\u0016T5o\u001c8TG\",W.\u0019\u000b\u0003\u0003C\t\u0011C^1mS\u0012\fG/\u001a-nYN\u001b\u0007.Z7b)\r!\u00151\u0007\u0005\u0007\u0003ky\u0001\u0019A$\u0002\u0019M\u001c\u0007.Z7b'R\u0014\u0018N\\4\u0015\u000b\u0011\u000bI$a\u000f\t\u000b\u0001\u0004\u0002\u0019A$\t\r\t\u0004\u0002\u0019AA\u001f!\u0011\tY!a\u0010\n\u0007\u0005\u0005SJA\u0004C_>dW-\u00198\u0015\u000b\u0011\u000b)%a\u0012\t\u000b\u0001\f\u0002\u0019A$\t\r\t\f\u0002\u0019AA%!\u0011\tY!a\u0013\n\u0007\u00055SJ\u0001\u0003M_:<G#\u0002#\u0002R\u0005M\u0003\"\u00021\u0013\u0001\u00049\u0005B\u00022\u0013\u0001\u0004\t)\u0006\u0005\u0003\u0002\f\u0005]\u0013bAA-\u001b\n1Ai\\;cY\u0016$2\u0001RA/\u0011\u0019\u00197\u00031\u0001\u0002`A1\u0011\u0011MA6\u000f\u001ek!!a\u0019\u000b\t\u0005\u0015\u0014qM\u0001\u0005kRLGN\u0003\u0002\u0002j\u0005!!.\u0019<b\u0013\rY\u00171M\u0001\u0005UN|g\u000eF\u0002z\u0003cBa!a\u0002\u0015\u0001\u00049\u0015aA2tmR\u0019\u00110a\u001e\t\r\u0005\u001dQ\u00031\u0001H\u0003\rAX\u000e\u001c\u000b\u0004s\u0006u\u0004BBA\u0004-\u0001\u0007q)A\u0002pe\u000e$2!_AB\u0011\u0019\t9a\u0006a\u0001\u000f\u00069\u0001/\u0019:rk\u0016$HcA=\u0002\n\"1\u0011q\u0001\rA\u0002\u001d\u000bA\u0001^3yiR\u0019\u00110a$\t\r\u0005\u001d\u0011\u00041\u0001H\u0003!!X\r\u001f;GS2,G\u0003BAK\u00037\u0003BaOAL\u000f&\u0019\u0011\u0011\u0014\u0015\u0003\u000f\u0011\u000bG/Y:fi\"1\u0011q\u0001\u000eA\u0002\u001d+\u0012aR\u0001\u000bg>,(oY3`I\u0015\fH\u0003BA\u0011\u0003GC\u0001\"!*\u001d\u0003\u0003\u0005\raR\u0001\u0004q\u0012\n\u0014aB:pkJ\u001cW\rI\u0001\u0014kN,'o\u00159fG&4\u0017.\u001a3TG\",W.Y\u000b\u0003\u0003[\u0003R!a\u0003\u0002\u000e]\u000bq#^:feN\u0003XmY5gS\u0016$7k\u00195f[\u0006|F%Z9\u0015\t\u0005\u0005\u00121\u0017\u0005\n\u0003K{\u0012\u0011!a\u0001\u0003[\u000bA#^:feN\u0003XmY5gS\u0016$7k\u00195f[\u0006\u0004\u0013\u0001D3yiJ\fw\n\u001d;j_:\u001cXCAA^!\u0015\ti,!2H\u001b\t\tyL\u0003\u0003\u0002f\u0005\u0005'bAAbU\u0005A1-\u0019;bYf\u001cH/\u0003\u0003\u0002H\u0006}&AE\"bg\u0016Len]3og&$\u0018N^3NCB\f\u0001#\u001a=ue\u0006|\u0005\u000f^5p]N|F%Z9\u0015\t\u0005\u0005\u0012Q\u001a\u0005\n\u0003K\u0013\u0013\u0011!a\u0001\u0003w\u000bQ\"\u001a=ue\u0006|\u0005\u000f^5p]N\u0004\u0013AF;tKJ\u0004&o\u001c<jI\u0016$7k\\;sG\u0016t\u0015-\\3\u0016\u0005\u0005%\u0011AG;tKJ\u0004&o\u001c<jI\u0016$7k\\;sG\u0016t\u0015-\\3`I\u0015\fH\u0003BA\u0011\u00033D\u0011\"!*&\u0003\u0003\u0005\r!!\u0003\u0002/U\u001cXM\u001d)s_ZLG-\u001a3T_V\u00148-\u001a(b[\u0016\u0004\u0003f\u0001\u0001\u0002`B\u0019!/!9\n\u0007\u0005\r8O\u0001\u0005Fm>dg/\u001b8h\u0001")
public final class DataStreamReader
extends org.apache.spark.sql.streaming.DataStreamReader {
    private final SparkSession sparkSession;
    private String source;
    private Option<StructType> userSpecifiedSchema;
    private CaseInsensitiveMap<String> extraOptions;
    private Option<String> userProvidedSourceName;

    public DataStreamReader format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataStreamReader schema(StructType schema) {
        block0: {
            if (schema == null) break block0;
            StructType replaced = (StructType)CharVarcharUtils$.MODULE$.failIfHasCharVarchar((DataType)schema);
            this.userSpecifiedSchema_$eq((Option<StructType>)Option$.MODULE$.apply((Object)replaced));
        }
        return this;
    }

    public DataStreamReader option(String key, String value) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value)));
        return this;
    }

    public DataStreamReader options(Map<String, String> options) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus(options));
        return this;
    }

    @Experimental
    public DataStreamReader name(String sourceName) {
        this.validateSourceName(sourceName);
        this.userProvidedSourceName_$eq((Option<String>)Option$.MODULE$.apply((Object)sourceName));
        return this;
    }

    public Dataset<Row> load() {
        return this.loadInternal((Option<String>)None$.MODULE$);
    }

    private Dataset<Row> loadInternal(Option<String> path) {
        UnresolvedDataSource unresolved = new UnresolvedDataSource(this.source(), this.userSpecifiedSchema(), this.extraOptions(), true, (Seq<String>)Option$.MODULE$.option2Iterable(path).toSeq());
        NamedStreamingRelation plan = NamedStreamingRelation$.MODULE$.withUserProvidedName((LogicalPlan)unresolved, this.userProvidedSourceName());
        return Dataset$.MODULE$.ofRows(this.sparkSession, (LogicalPlan)plan);
    }

    public Dataset<Row> load(String path) {
        if (!this.sparkSession.sessionState().conf().legacyPathOptionBehavior() && this.extraOptions().contains("path")) {
            throw QueryCompilationErrors$.MODULE$.setPathOptionAndCallWithPathParameterError("load");
        }
        return this.loadInternal((Option<String>)new Some((Object)path));
    }

    public Dataset<Row> table(String tableName) {
        Predef$.MODULE$.require(tableName != null, (Function0 & Serializable)() -> "The table name can't be null");
        Seq identifier = this.sparkSession.sessionState().sqlParser().parseMultipartIdentifier(tableName);
        UnresolvedRelation unresolved = new UnresolvedRelation(identifier, new CaseInsensitiveStringMap(CollectionConverters$.MODULE$.MapHasAsJava((Map)this.extraOptions().toMap()).asJava()), true);
        NamedStreamingRelation plan = NamedStreamingRelation$.MODULE$.withUserProvidedName((LogicalPlan)unresolved, this.userProvidedSourceName());
        return Dataset$.MODULE$.ofRows(this.sparkSession, (LogicalPlan)plan);
    }

    public void assertNoSpecifiedSchema(String operation) {
        if (this.userSpecifiedSchema().nonEmpty()) {
            throw QueryCompilationErrors$.MODULE$.userSpecifiedSchemaUnsupportedError(operation);
        }
    }

    public void validateJsonSchema() {
        this.userSpecifiedSchema().foreach((Function1 & Serializable)schema -> {
            JsonUtils$.MODULE$.checkJsonSchema(schema);
            return BoxedUnit.UNIT;
        });
    }

    public void validateXmlSchema() {
        this.userSpecifiedSchema().foreach((Function1 & Serializable)schema -> {
            XmlUtils$.MODULE$.checkXmlSchema(schema);
            return BoxedUnit.UNIT;
        });
    }

    public DataStreamReader schema(String schemaString) {
        return (DataStreamReader)super.schema(schemaString);
    }

    public DataStreamReader option(String key, boolean value) {
        return (DataStreamReader)super.option(key, value);
    }

    public DataStreamReader option(String key, long value) {
        return (DataStreamReader)super.option(key, value);
    }

    public DataStreamReader option(String key, double value) {
        return (DataStreamReader)super.option(key, value);
    }

    public DataStreamReader options(java.util.Map<String, String> options) {
        return (DataStreamReader)super.options(options);
    }

    public Dataset<Row> json(String path) {
        return ClassicConversions$.MODULE$.castToImpl(super.json(path));
    }

    public Dataset<Row> csv(String path) {
        return ClassicConversions$.MODULE$.castToImpl(super.csv(path));
    }

    public Dataset<Row> xml(String path) {
        return ClassicConversions$.MODULE$.castToImpl(super.xml(path));
    }

    public Dataset<Row> orc(String path) {
        return ClassicConversions$.MODULE$.castToImpl(super.orc(path));
    }

    public Dataset<Row> parquet(String path) {
        return ClassicConversions$.MODULE$.castToImpl(super.parquet(path));
    }

    public Dataset<Row> text(String path) {
        return ClassicConversions$.MODULE$.castToImpl(super.text(path));
    }

    public Dataset<String> textFile(String path) {
        return ClassicConversions$.MODULE$.castToImpl(super.textFile(path));
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private Option<StructType> userSpecifiedSchema() {
        return this.userSpecifiedSchema;
    }

    private void userSpecifiedSchema_$eq(Option<StructType> x$1) {
        this.userSpecifiedSchema = x$1;
    }

    private CaseInsensitiveMap<String> extraOptions() {
        return this.extraOptions;
    }

    private void extraOptions_$eq(CaseInsensitiveMap<String> x$1) {
        this.extraOptions = x$1;
    }

    private Option<String> userProvidedSourceName() {
        return this.userProvidedSourceName;
    }

    private void userProvidedSourceName_$eq(Option<String> x$1) {
        this.userProvidedSourceName = x$1;
    }

    public DataStreamReader(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
        this.source = sparkSession.sessionState().conf().defaultDataSourceName();
        this.userSpecifiedSchema = None$.MODULE$;
        this.extraOptions = CaseInsensitiveMap$.MODULE$.apply(Predef$.MODULE$.Map().empty());
        this.userProvidedSourceName = None$.MODULE$;
    }
}

