/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import java.io.CharConversionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.MalformedInputException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JacksonUtils$;
import org.apache.spark.sql.catalyst.json.JsonInferSchema$;
import org.apache.spark.sql.catalyst.util.DropMalformedMode$;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.ParseMode;
import org.apache.spark.sql.catalyst.util.PermissiveMode$;
import org.apache.spark.sql.catalyst.util.SparkDateTimeUtils$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.LegacyBehaviorPolicy$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.util.control.Exception$;

@ScalaSignature(bytes="\u0006\u0005\tUc\u0001B\u0013'\u0001MB\u0001\u0002\u0014\u0001\u0003\u0006\u0004%I!\u0014\u0005\t%\u0002\u0011\t\u0011)A\u0005\u001d\")1\u000b\u0001C\u0001)\"9q\u000b\u0001b\u0001\n\u0013A\u0006B\u00027\u0001A\u0003%\u0011\fC\u0004n\u0001\t\u0007I\u0011\u00028\t\rU\u0004\u0001\u0015!\u0003p\u0011\u001d1\bA1A\u0005\n9Daa\u001e\u0001!\u0002\u0013y\u0007b\u0002=\u0001\u0005\u0004%I!\u001f\u0005\u0007{\u0002\u0001\u000b\u0011\u0002>\t\u000fy\u0004!\u0019!C\u0005s\"1q\u0010\u0001Q\u0001\niD\u0001\"!\u0001\u0001\u0005\u0004%I!\u001f\u0005\b\u0003\u0007\u0001\u0001\u0015!\u0003{\u0011!\t)\u0001\u0001b\u0001\n\u0013I\bbBA\u0004\u0001\u0001\u0006IA\u001f\u0005\b\u0003\u0013\u0001A\u0011IA\u0006\u0011\u001d\t9\u0002\u0001C!\u00033Aq!!\t\u0001\t\u0013\t\u0019\u0003C\u0004\u0002P\u0001!\t!!\u0015\t\u0013\u0005}\u0005!%A\u0005\u0002\u0005\u0005\u0006bBA^\u0001\u0011\u0005\u0011Q\u0018\u0005\t\u0003\u0013\u0004A\u0011\u0001\u0015\u0002L\u001e9\u0011Q\u001b\u0014\t\u0002\u0005]gAB\u0013'\u0011\u0003\tI\u000e\u0003\u0004T5\u0011\u0005\u0011Q\u001d\u0005\n\u0003OT\"\u0019!C\u0001\u0003SD\u0001\"!=\u001bA\u0003%\u00111\u001e\u0005\b\u0005\u001fQB\u0011\u0001B\t\u0011\u001d\u0011iB\u0007C\u0001\u0005?AqAa\f\u001b\t\u0003\u0011\t\u0004\u0003\u0005\u0003:i\u0001\u000b\u0011\u0002B\f\u0011\u001d\u0011YD\u0007C\u0001\u0005{A\u0011Ba\u0013\u001b#\u0003%\tA!\u0014\t\u0013\tE#$!A\u0005\n\tM#a\u0004&t_:LeNZ3s'\u000eDW-\\1\u000b\u0005\u001dB\u0013\u0001\u00026t_:T!!\u000b\u0016\u0002\u0011\r\fG/\u00197zgRT!a\u000b\u0017\u0002\u0007M\fHN\u0003\u0002.]\u0005)1\u000f]1sW*\u0011q\u0006M\u0001\u0007CB\f7\r[3\u000b\u0003E\n1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\u001b;\rB\u0011Q\u0007O\u0007\u0002m)\tq'A\u0003tG\u0006d\u0017-\u0003\u0002:m\t1\u0011I\\=SK\u001a\u0004\"aO\"\u000f\u0005q\neBA\u001fA\u001b\u0005q$BA 3\u0003\u0019a$o\\8u}%\tq'\u0003\u0002Cm\u00059\u0001/Y2lC\u001e,\u0017B\u0001#F\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t\u0011e\u0007\u0005\u0002H\u00156\t\u0001J\u0003\u0002JY\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002L\u0011\n9Aj\\4hS:<\u0017aB8qi&|gn]\u000b\u0002\u001dB\u0011q\nU\u0007\u0002M%\u0011\u0011K\n\u0002\f\u0015N{ej\u00149uS>t7/\u0001\u0005paRLwN\\:!\u0003\u0019a\u0014N\\5u}Q\u0011QK\u0016\t\u0003\u001f\u0002AQ\u0001T\u0002A\u00029\u000bQ\u0002Z3dS6\fG\u000eU1sg\u0016\u0014X#A-\u0011\tURF\fZ\u0005\u00037Z\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0005u\u000bgB\u00010`!\tid'\u0003\u0002am\u00051\u0001K]3eK\u001aL!AY2\u0003\rM#(/\u001b8h\u0015\t\u0001g\u0007\u0005\u0002fU6\taM\u0003\u0002hQ\u0006!Q.\u0019;i\u0015\u0005I\u0017\u0001\u00026bm\u0006L!a\u001b4\u0003\u0015\tKw\rR3dS6\fG.\u0001\beK\u000eLW.\u00197QCJ\u001cXM\u001d\u0011\u0002%QLW.Z:uC6\u0004hi\u001c:nCR$XM]\u000b\u0002_B\u0011\u0001o]\u0007\u0002c*\u0011!\u000fK\u0001\u0005kRLG.\u0003\u0002uc\n\u0011B+[7fgR\fW\u000e\u001d$pe6\fG\u000f^3s\u0003M!\u0018.\\3ti\u0006l\u0007OR8s[\u0006$H/\u001a:!\u0003U!\u0018.\\3ti\u0006l\u0007O\u0014+[\r>\u0014X.\u0019;uKJ\fa\u0003^5nKN$\u0018-\u001c9O)j3uN]7biR,'\u000fI\u0001\u0013S\u001etwN]3D_J\u0014X\u000f\u001d;GS2,7/F\u0001{!\t)40\u0003\u0002}m\t9!i\\8mK\u0006t\u0017aE5h]>\u0014XmQ8seV\u0004HOR5mKN\u0004\u0013AE5h]>\u0014X-T5tg&twMR5mKN\f1#[4o_J,W*[:tS:<g)\u001b7fg\u0002\nA\"[:EK\u001a\fW\u000f\u001c;O)j\u000bQ\"[:EK\u001a\fW\u000f\u001c;O)j\u0003\u0013A\u00037fO\u0006\u001c\u00170T8eK\u0006YA.Z4bGflu\u000eZ3!\u0003\u0019)\u0017/^1mgR\u0019!0!\u0004\t\u000f\u0005=!\u00031\u0001\u0002\u0012\u0005\u0019qN\u00196\u0011\u0007U\n\u0019\"C\u0002\u0002\u0016Y\u00121!\u00118z\u0003!A\u0017m\u001d5D_\u0012,GCAA\u000e!\r)\u0014QD\u0005\u0004\u0003?1$aA%oi\u0006Y\u0002.\u00198eY\u0016T5o\u001c8FeJ|'o\u001d\"z!\u0006\u00148/Z'pI\u0016$\u0002\"!\n\u00028\u0005\u0005\u0013Q\t\t\u0006k\u0005\u001d\u00121F\u0005\u0004\u0003S1$AB(qi&|g\u000e\u0005\u0003\u0002.\u0005MRBAA\u0018\u0015\r\t\tDK\u0001\u0006if\u0004Xm]\u0005\u0005\u0003k\tyC\u0001\u0006TiJ,8\r\u001e+za\u0016Dq!!\u000f\u0015\u0001\u0004\tY$A\u0005qCJ\u001cX-T8eKB\u0019\u0001/!\u0010\n\u0007\u0005}\u0012OA\u0005QCJ\u001cX-T8eK\"1\u00111\t\u000bA\u0002q\u000b\u0011dY8mk6tg*Y7f\u001f\u001a\u001cuN\u001d:vaR\u0014VmY8sI\"9\u0011q\t\u000bA\u0002\u0005%\u0013!A3\u0011\u0007m\nY%C\u0002\u0002N\u0015\u0013\u0011\u0002\u00165s_^\f'\r\\3\u0002\u000b%tg-\u001a:\u0016\t\u0005M\u0013q\r\u000b\t\u0003W\t)&a\u001d\u0002\u001c\"1q%\u0006a\u0001\u0003/\u0002b!!\u0017\u0002`\u0005\rTBAA.\u0015\r\ti\u0006L\u0001\u0004e\u0012$\u0017\u0002BA1\u00037\u00121A\u0015#E!\u0011\t)'a\u001a\r\u0001\u00119\u0011\u0011N\u000bC\u0002\u0005-$!\u0001+\u0012\t\u00055\u0014\u0011\u0003\t\u0004k\u0005=\u0014bAA9m\t9aj\u001c;iS:<\u0007bBA;+\u0001\u0007\u0011qO\u0001\rGJ,\u0017\r^3QCJ\u001cXM\u001d\t\nk\u0005e\u0014QPA2\u0003+K1!a\u001f7\u0005%1UO\\2uS>t'\u0007\u0005\u0003\u0002\u0000\u0005EUBAAA\u0015\u0011\t\u0019)!\"\u0002\t\r|'/\u001a\u0006\u0005\u0003\u000f\u000bI)A\u0004kC\u000e\\7o\u001c8\u000b\t\u0005-\u0015QR\u0001\nM\u0006\u001cH/\u001a:y[2T!!a$\u0002\u0007\r|W.\u0003\u0003\u0002\u0014\u0006\u0005%a\u0003&t_:4\u0015m\u0019;pef\u0004B!a \u0002\u0018&!\u0011\u0011TAA\u0005)Q5o\u001c8QCJ\u001cXM\u001d\u0005\t\u0003;+\u0002\u0013!a\u0001u\u0006Q\u0011n\u001d*fC\u00124\u0015\u000e\\3\u0002\u001f%tg-\u001a:%I\u00164\u0017-\u001e7uIM*B!a)\u0002:V\u0011\u0011Q\u0015\u0016\u0004u\u0006\u001d6FAAU!\u0011\tY+!.\u000e\u0005\u00055&\u0002BAX\u0003c\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005Mf'\u0001\u0006b]:|G/\u0019;j_:LA!a.\u0002.\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u000f\u0005%dC1\u0001\u0002l\u0005Q\u0011N\u001c4fe\u001aKW\r\u001c3\u0015\t\u0005}\u0016Q\u0019\t\u0005\u0003[\t\t-\u0003\u0003\u0002D\u0006=\"\u0001\u0003#bi\u0006$\u0016\u0010]3\t\u000f\u0005\u001dw\u00031\u0001\u0002\u0016\u00061\u0001/\u0019:tKJ\f\u0001cY1o_:L7-\u00197ju\u0016$\u0016\u0010]3\u0015\r\u00055\u0017qZAj!\u0015)\u0014qEA`\u0011\u001d\t\t\u000e\u0007a\u0001\u0003\u007f\u000b1\u0001\u001e9f\u0011\u0015a\u0005\u00041\u0001O\u0003=Q5o\u001c8J]\u001a,'oU2iK6\f\u0007CA(\u001b'\u0011QB'a7\u0011\t\u0005u\u00171]\u0007\u0003\u0003?T1!!9i\u0003\tIw.C\u0002E\u0003?$\"!a6\u0002+M$(/^2u\r&,G\u000eZ\"p[B\f'/\u0019;peV\u0011\u00111\u001e\n\u0007\u0003[\f\u00190a@\u0007\r\u0005=X\u0004AAv\u00051a$/\u001a4j]\u0016lWM\u001c;?\u0003Y\u0019HO];di\u001aKW\r\u001c3D_6\u0004\u0018M]1u_J\u0004\u0003\u0003BA{\u0003wl!!a>\u000b\u0007\u0005e\b.\u0001\u0003mC:<\u0017\u0002BA\u007f\u0003o\u0014aa\u00142kK\u000e$\bC\u0002B\u0001\u0005\u000b\u0011I!\u0004\u0002\u0003\u0004)\u0011!\u000f[\u0005\u0005\u0005\u000f\u0011\u0019A\u0001\u0006D_6\u0004\u0018M]1u_J\u0004B!!\f\u0003\f%!!QBA\u0018\u0005-\u0019FO];di\u001aKW\r\u001c3\u0002\u0011%\u001c8k\u001c:uK\u0012$2A\u001fB\n\u0011\u001d\u0011)B\ba\u0001\u0005/\t1!\u0019:s!\u0015)$\u0011\u0004B\u0005\u0013\r\u0011YB\u000e\u0002\u0006\u0003J\u0014\u0018-_\u0001\u0011o&$\bnQ8seV\u0004HOR5fY\u0012$\"\"a\u000b\u0003\"\t\u0015\"\u0011\u0006B\u0017\u0011\u001d\u0011\u0019c\ba\u0001\u0003W\taa\u001d;sk\u000e$\bb\u0002B\u0014?\u0001\u0007\u0011qX\u0001\u0006_RDWM\u001d\u0005\u0007\u0005Wy\u0002\u0019\u0001/\u00025\r|G.^7o\u001d\u0006lWm\u00144D_J\u0014X\u000f\u001d;SK\u000e|'\u000fZ:\t\u000f\u0005er\u00041\u0001\u0002<\u0005\u00112m\\7qCRL'\r\\3S_>$H+\u001f9f)\u0019\u0011\u0019D!\u000e\u00038AIQ'!\u001f\u0002@\u0006}\u0016q\u0018\u0005\u0007\u0005W\u0001\u0003\u0019\u0001/\t\u000f\u0005e\u0002\u00051\u0001\u0002<\u0005)R-\u001c9usN#(/^2u\r&,G\u000eZ!se\u0006L\u0018AD2p[B\fG/\u001b2mKRK\b/\u001a\u000b\t\u0003\u007f\u0013yDa\u0011\u0003H!9!\u0011\t\u0012A\u0002\u0005}\u0016A\u0001;2\u0011\u001d\u0011)E\ta\u0001\u0003\u007f\u000b!\u0001\u001e\u001a\t\u0013\t%#\u0005%AA\u0002\u0005}\u0016a\u00043fM\u0006,H\u000e\u001e#bi\u0006$\u0016\u0010]3\u00021\r|W\u000e]1uS\ndW\rV=qK\u0012\"WMZ1vYR$3'\u0006\u0002\u0003P)\"\u0011qXAT\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\t\u0019\u0010")
public class JsonInferSchema
implements Serializable,
Logging {
    private final JSONOptions options;
    private final Function1<String, BigDecimal> decimalParser;
    private final TimestampFormatter timestampFormatter;
    private final TimestampFormatter timestampNTZFormatter;
    private final boolean ignoreCorruptFiles;
    private final boolean ignoreMissingFiles;
    private final boolean isDefaultNTZ;
    private final boolean legacyMode;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static DataType compatibleType$default$3() {
        return JsonInferSchema$.MODULE$.compatibleType$default$3();
    }

    public static DataType compatibleType(DataType t1, DataType t2, DataType defaultDataType) {
        return JsonInferSchema$.MODULE$.compatibleType(t1, t2, defaultDataType);
    }

    public static Function2<DataType, DataType, DataType> compatibleRootType(String columnNameOfCorruptRecords, ParseMode parseMode) {
        return JsonInferSchema$.MODULE$.compatibleRootType(columnNameOfCorruptRecords, parseMode);
    }

    public static StructType withCorruptField(StructType struct, DataType other, String columnNameOfCorruptRecords, ParseMode parseMode) {
        return JsonInferSchema$.MODULE$.withCorruptField(struct, other, columnNameOfCorruptRecords, parseMode);
    }

    public static boolean isSorted(StructField[] arr) {
        return JsonInferSchema$.MODULE$.isSorted(arr);
    }

    public static Comparator<StructField> structFieldComparator() {
        return JsonInferSchema$.MODULE$.structFieldComparator();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private JSONOptions options() {
        return this.options;
    }

    private Function1<String, BigDecimal> decimalParser() {
        return this.decimalParser;
    }

    private TimestampFormatter timestampFormatter() {
        return this.timestampFormatter;
    }

    private TimestampFormatter timestampNTZFormatter() {
        return this.timestampNTZFormatter;
    }

    private boolean ignoreCorruptFiles() {
        return this.ignoreCorruptFiles;
    }

    private boolean ignoreMissingFiles() {
        return this.ignoreMissingFiles;
    }

    private boolean isDefaultNTZ() {
        return this.isDefaultNTZ;
    }

    private boolean legacyMode() {
        return this.legacyMode;
    }

    public boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof JsonInferSchema) {
            JsonInferSchema jsonInferSchema = (JsonInferSchema)object;
            JSONOptions jSONOptions = this.options();
            JSONOptions jSONOptions2 = jsonInferSchema.options();
            return !(jSONOptions != null ? !((Object)jSONOptions).equals(jSONOptions2) : jSONOptions2 != null);
        }
        return false;
    }

    public int hashCode() {
        return this.options().hashCode();
    }

    private Option<StructType> handleJsonErrorsByParseMode(ParseMode parseMode, String columnNameOfCorruptRecord, Throwable e) {
        ParseMode parseMode2 = parseMode;
        if (PermissiveMode$.MODULE$.equals(parseMode2)) {
            return new Some((Object)new StructType((StructField[])((Object[])new StructField[]{new StructField(columnNameOfCorruptRecord, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
        }
        if (DropMalformedMode$.MODULE$.equals(parseMode2)) {
            return None$.MODULE$;
        }
        if (FailFastMode$.MODULE$.equals(parseMode2)) {
            throw QueryExecutionErrors$.MODULE$.malformedRecordsDetectedInSchemaInferenceError(e, columnNameOfCorruptRecord);
        }
        throw new MatchError((Object)parseMode2);
    }

    public <T> StructType infer(RDD<T> json, Function2<JsonFactory, T, JsonParser> createParser, boolean isReadFile) {
        ParseMode parseMode = this.options().parseMode();
        String columnNameOfCorruptRecord = this.options().columnNameOfCorruptRecord();
        Function2<DataType, DataType, DataType> typeMerger = JsonInferSchema$.MODULE$.compatibleRootType(columnNameOfCorruptRecord, parseMode);
        RDD mergedTypesFromPartitions = json.mapPartitions((Function1 & Serializable)iter -> {
            JsonFactory factory = this.options().buildJsonFactory();
            return iter.flatMap((Function1 & Serializable)row -> {
                Option<StructType> option;
                try {
                    option = (Option<StructType>)Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> (JsonParser)createParser.apply((Object)factory, row), (Function1 & Serializable)parser -> {
                        parser.nextToken();
                        return new Some((Object)this.inferField((JsonParser)parser));
                    });
                }
                catch (Throwable throwable) {
                    boolean bl = false;
                    FileNotFoundException fileNotFoundException = null;
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof RuntimeException) {
                        RuntimeException runtimeException = (RuntimeException)throwable2;
                        if (!isReadFile) {
                            option = this.handleJsonErrorsByParseMode(parseMode, columnNameOfCorruptRecord, runtimeException);
                        }
                    }
                    if (throwable2 instanceof JsonProcessingException ? true : throwable2 instanceof MalformedInputException) {
                        option = this.handleJsonErrorsByParseMode(parseMode, columnNameOfCorruptRecord, throwable2);
                    }
                    if (throwable2 instanceof CharConversionException) {
                        CharConversionException charConversionException = (CharConversionException)throwable2;
                        if (this.options().encoding().isEmpty()) {
                            String msg = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("JSON parser cannot handle a character in its input.\n                |Specifying encoding as an input option explicitly might help to resolve the issue.\n                |")) + charConversionException.getMessage();
                            CharConversionException wrappedCharException = new CharConversionException(msg);
                            wrappedCharException.initCause(charConversionException);
                            option = this.handleJsonErrorsByParseMode(parseMode, columnNameOfCorruptRecord, wrappedCharException);
                        }
                    }
                    if (throwable2 instanceof FileNotFoundException) {
                        bl = true;
                        fileNotFoundException = (FileNotFoundException)throwable2;
                        if (this.ignoreMissingFiles()) {
                            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Skipped missing file", (Throwable)fileNotFoundException);
                            option = new Option<StructType>((Object)StructType$.MODULE$.apply((Seq)Nil$.MODULE$));
                        }
                    }
                    if (bl && !this.ignoreMissingFiles()) {
                        throw fileNotFoundException;
                    }
                    if ((throwable2 instanceof IOException ? true : throwable2 instanceof RuntimeException) && this.ignoreCorruptFiles()) {
                        this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Skipped the rest of the content in the corrupted file", throwable2);
                        option = new Some((Object)StructType$.MODULE$.apply((Seq)Nil$.MODULE$));
                    }
                    throw throwable;
                }
                return option;
            }).reduceOption(typeMerger).iterator();
        }, json.mapPartitions$default$2(), ClassTag$.MODULE$.apply(DataType.class));
        SQLConf existingConf = SQLConf$.MODULE$.get();
        ObjectRef rootType = ObjectRef.create((Object)StructType$.MODULE$.apply((Seq)Nil$.MODULE$));
        Function1 & Serializable foldPartition = (Function1 & Serializable)iter -> (DataType)iter.fold((Object)StructType$.MODULE$.apply((Seq)Nil$.MODULE$), typeMerger);
        Function2 & Serializable mergeResult = (Function2 & Serializable)(index, taskResult) -> {
            rootType.elem = (DataType)SQLConf$.MODULE$.withExistingConf(existingConf, (Function0 & Serializable)() -> (DataType)typeMerger$1.apply((Object)((DataType)rootType$1.elem), (Object)taskResult));
            return BoxedUnit.UNIT;
        };
        json.sparkContext().runJob(mergedTypesFromPartitions, (Function1)foldPartition, (Function2)mergeResult, ClassTag$.MODULE$.apply(DataType.class));
        return (StructType)Option$.MODULE$.option2Iterable(this.canonicalizeType((DataType)rootType.elem, this.options())).find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JsonInferSchema.$anonfun$infer$10(x$1))).getOrElse((Function0 & Serializable)() -> StructType$.MODULE$.apply((Seq)Nil$.MODULE$));
    }

    public <T> boolean infer$default$3() {
        return false;
    }

    public DataType inferField(JsonParser parser) {
        boolean bl = false;
        JsonToken jsonToken = null;
        JsonToken jsonToken2 = parser.getCurrentToken();
        if (jsonToken2 == null ? true : JsonToken.VALUE_NULL.equals(jsonToken2)) {
            return NullType$.MODULE$;
        }
        if (JsonToken.FIELD_NAME.equals(jsonToken2)) {
            parser.nextToken();
            return this.inferField(parser);
        }
        if (JsonToken.VALUE_STRING.equals(jsonToken2)) {
            bl = true;
            jsonToken = jsonToken2;
            if (parser.getTextLength() < 1) {
                return NullType$.MODULE$;
            }
        }
        if (bl) {
            LazyRef decimalTry$lzy = new LazyRef();
            String field = parser.getText();
            if (this.options().prefersDecimal() && this.decimalTry$1(decimalTry$lzy, field).isDefined()) {
                return (DataType)this.decimalTry$1(decimalTry$lzy, field).get();
            }
            if (this.options().inferTimestamp()) {
                if (this.isDefaultNTZ() && this.timestampNTZFormatter().parseWithoutTimeZoneOptional(field, false).isDefined()) {
                    return TimestampNTZType$.MODULE$;
                }
                if (this.timestampFormatter().parseOptional(field).isDefined()) {
                    return TimestampType$.MODULE$;
                }
                if (this.legacyMode()) {
                    UTF8String utf8Value = UTF8String.fromString((String)field);
                    if (SparkDateTimeUtils$.MODULE$.stringToTimestampWithoutTimeZone(utf8Value, false).isDefined()) {
                        return TimestampType$.MODULE$;
                    }
                    return StringType$.MODULE$;
                }
                return StringType$.MODULE$;
            }
            return StringType$.MODULE$;
        }
        if (JsonToken.START_OBJECT.equals(jsonToken2)) {
            ArrayBuilder builder = Array$.MODULE$.newBuilder(ClassTag$.MODULE$.apply(StructField.class));
            while (JacksonUtils$.MODULE$.nextUntil(parser, JsonToken.END_OBJECT)) {
                builder.$plus$eq((Object)new StructField(parser.currentName(), this.inferField(parser), true, StructField$.MODULE$.apply$default$4()));
            }
            StructField[] fields = (StructField[])builder.result();
            Arrays.sort((Object[])fields, JsonInferSchema$.MODULE$.structFieldComparator());
            return new StructType(fields);
        }
        if (JsonToken.START_ARRAY.equals(jsonToken2)) {
            NullType$ elementType = NullType$.MODULE$;
            while (JacksonUtils$.MODULE$.nextUntil(parser, JsonToken.END_ARRAY)) {
                elementType = JsonInferSchema$.MODULE$.compatibleType((DataType)elementType, this.inferField(parser), JsonInferSchema$.MODULE$.compatibleType$default$3());
            }
            return ArrayType$.MODULE$.apply((DataType)elementType);
        }
        if ((JsonToken.VALUE_NUMBER_INT.equals(jsonToken2) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken2)) && this.options().primitivesAsString()) {
            return StringType$.MODULE$;
        }
        if ((JsonToken.VALUE_TRUE.equals(jsonToken2) ? true : JsonToken.VALUE_FALSE.equals(jsonToken2)) && this.options().primitivesAsString()) {
            return StringType$.MODULE$;
        }
        if (JsonToken.VALUE_NUMBER_INT.equals(jsonToken2) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken2)) {
            JsonParser.NumberType numberType = parser.getNumberType();
            if (JsonParser.NumberType.INT.equals(numberType) ? true : JsonParser.NumberType.LONG.equals(numberType)) {
                return LongType$.MODULE$;
            }
            if (JsonParser.NumberType.BIG_INTEGER.equals(numberType) ? true : JsonParser.NumberType.BIG_DECIMAL.equals(numberType)) {
                BigDecimal v = parser.getDecimalValue();
                if (Math.max(v.precision(), v.scale()) <= DecimalType$.MODULE$.MAX_PRECISION()) {
                    return new DecimalType(Math.max(v.precision(), v.scale()), v.scale());
                }
                return DoubleType$.MODULE$;
            }
            if ((JsonParser.NumberType.FLOAT.equals(numberType) ? true : JsonParser.NumberType.DOUBLE.equals(numberType)) && this.options().prefersDecimal()) {
                BigDecimal v = parser.getDecimalValue();
                if (Math.max(v.precision(), v.scale()) <= DecimalType$.MODULE$.MAX_PRECISION()) {
                    return new DecimalType(Math.max(v.precision(), v.scale()), v.scale());
                }
                return DoubleType$.MODULE$;
            }
            if (JsonParser.NumberType.FLOAT.equals(numberType) ? true : JsonParser.NumberType.DOUBLE.equals(numberType)) {
                return DoubleType$.MODULE$;
            }
            throw new MatchError((Object)numberType);
        }
        if (JsonToken.VALUE_TRUE.equals(jsonToken2) ? true : JsonToken.VALUE_FALSE.equals(jsonToken2)) {
            return BooleanType$.MODULE$;
        }
        throw QueryExecutionErrors$.MODULE$.malformedJSONError();
    }

    public Option<DataType> canonicalizeType(DataType tpe, JSONOptions options) {
        DataType dataType = tpe;
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            return this.canonicalizeType(arrayType.elementType(), options).map((Function1 & Serializable)t -> arrayType.copy(t, arrayType.copy$default$2()));
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            StructField[] canonicalFields = (StructField[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$2.name()))))), (Function1 & Serializable)f -> this.canonicalizeType(f.dataType(), options).map((Function1 & Serializable)t -> {
                DataType x$1 = t;
                String x$2 = f.copy$default$1();
                boolean x$3 = f.copy$default$3();
                Metadata x$4 = f.copy$default$4();
                return f.copy(x$2, x$1, x$3, x$4);
            }), ClassTag$.MODULE$.apply(StructField.class));
            if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])canonicalFields))) {
                return None$.MODULE$;
            }
            return new Some((Object)new StructType(canonicalFields));
        }
        if (NullType$.MODULE$.equals(dataType)) {
            if (options.dropFieldIfAllNull()) {
                return None$.MODULE$;
            }
            return new Some((Object)StringType$.MODULE$);
        }
        return new Some((Object)dataType);
    }

    public static final /* synthetic */ boolean $anonfun$infer$10(DataType x$1) {
        return x$1 instanceof StructType;
    }

    private final /* synthetic */ Option decimalTry$lzycompute$1(LazyRef decimalTry$lzy$1, String field$1) {
        Option option;
        LazyRef lazyRef = decimalTry$lzy$1;
        synchronized (lazyRef) {
            option = decimalTry$lzy$1.initialized() ? (Option)decimalTry$lzy$1.value() : (Option)decimalTry$lzy$1.initialize((Object)Exception$.MODULE$.allCatch().opt((Function0 & Serializable)() -> {
                BigDecimal bigDecimal = (BigDecimal)this.decimalParser().apply((Object)field$1);
                return new DecimalType(bigDecimal.precision(), bigDecimal.scale());
            }));
        }
        return option;
    }

    private final Option decimalTry$1(LazyRef decimalTry$lzy$1, String field$1) {
        if (decimalTry$lzy$1.initialized()) {
            return (Option)decimalTry$lzy$1.value();
        }
        return this.decimalTry$lzycompute$1(decimalTry$lzy$1, field$1);
    }

    public JsonInferSchema(JSONOptions options) {
        this.options = options;
        Logging.$init$((Logging)this);
        this.decimalParser = ExprUtils$.MODULE$.getDecimalParser(options.locale());
        this.timestampFormatter = TimestampFormatter$.MODULE$.apply(options.timestampFormatInRead(), options.zoneId(), options.locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true);
        this.timestampNTZFormatter = TimestampFormatter$.MODULE$.apply(options.timestampNTZFormatInRead(), options.zoneId(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true, true);
        this.ignoreCorruptFiles = options.ignoreCorruptFiles();
        this.ignoreMissingFiles = options.ignoreMissingFiles();
        AtomicType atomicType = SQLConf$.MODULE$.get().timestampType();
        TimestampNTZType$ timestampNTZType$ = TimestampNTZType$.MODULE$;
        this.isDefaultNTZ = !(atomicType != null ? !atomicType.equals(timestampNTZType$) : timestampNTZType$ != null);
        Enumeration.Value value = SQLConf$.MODULE$.get().legacyTimeParserPolicy();
        Enumeration.Value value2 = LegacyBehaviorPolicy$.MODULE$.LEGACY();
        this.legacyMode = !(value != null ? !value.equals(value2) : value2 != null);
    }
}

