/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.org.apache.arrow.vector.complex.impl;

import java.time.LocalDateTime;
import org.sparkproject.org.apache.arrow.vector.complex.impl.AbstractFieldReader;
import org.sparkproject.org.apache.arrow.vector.holders.DateMilliHolder;
import org.sparkproject.org.apache.arrow.vector.holders.NullableDateMilliHolder;
import org.sparkproject.org.apache.arrow.vector.types.Types;
import org.sparkproject.org.apache.arrow.vector.util.DateUtility;

public class NullableDateMilliHolderReaderImpl
extends AbstractFieldReader {
    private NullableDateMilliHolder holder;

    public NullableDateMilliHolderReaderImpl(NullableDateMilliHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.DATEMILLI;
    }

    @Override
    public boolean isSet() {
        return this.holder.isSet == 1;
    }

    @Override
    public void read(DateMilliHolder h) {
        h.value = this.holder.value;
    }

    @Override
    public void read(NullableDateMilliHolder h) {
        h.value = this.holder.value;
        h.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public LocalDateTime readLocalDateTime() {
        if (!this.isSet()) {
            return null;
        }
        return DateUtility.getLocalDateTimeFromEpochMilli(this.holder.value);
    }

    @Override
    public Object readObject() {
        return this.readLocalDateTime();
    }
}

