/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd;

import java.util.List;
import java.util.ListIterator;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.security.HiveAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAccessControlException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAccessController;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzSessionContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveMetastoreClientFactory;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrincipal;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilege;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeInfo;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveRoleGrant;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLAuthorizationUtils;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAccessController;

@InterfaceAudience.Private
public class SQLStdHiveAccessControllerWrapper
implements HiveAccessController {
    private final SQLStdHiveAccessController hiveAccessController;

    public SQLStdHiveAccessControllerWrapper(HiveMetastoreClientFactory metastoreClientFactory, HiveConf conf, HiveAuthenticationProvider authenticator, HiveAuthzSessionContext ctx) throws HiveAuthzPluginException {
        this.hiveAccessController = new SQLStdHiveAccessController(metastoreClientFactory, conf, authenticator, ctx);
    }

    @Override
    public void grantPrivileges(List<HivePrincipal> hivePrincipals, List<HivePrivilege> hivePrivileges, HivePrivilegeObject hivePrivObject, HivePrincipal grantorPrincipal, boolean grantOption) throws HiveAuthzPluginException, HiveAccessControlException {
        hivePrincipals = SQLAuthorizationUtils.getValidatedPrincipals(hivePrincipals);
        grantorPrincipal = SQLAuthorizationUtils.getValidatedPrincipal(grantorPrincipal);
        this.hiveAccessController.grantPrivileges(hivePrincipals, hivePrivileges, hivePrivObject, grantorPrincipal, grantOption);
    }

    @Override
    public void revokePrivileges(List<HivePrincipal> hivePrincipals, List<HivePrivilege> hivePrivileges, HivePrivilegeObject hivePrivObject, HivePrincipal grantorPrincipal, boolean grantOption) throws HiveAuthzPluginException, HiveAccessControlException {
        hivePrincipals = SQLAuthorizationUtils.getValidatedPrincipals(hivePrincipals);
        grantorPrincipal = SQLAuthorizationUtils.getValidatedPrincipal(grantorPrincipal);
        this.hiveAccessController.revokePrivileges(hivePrincipals, hivePrivileges, hivePrivObject, grantorPrincipal, grantOption);
    }

    @Override
    public void createRole(String roleName, HivePrincipal adminGrantor) throws HiveAuthzPluginException, HiveAccessControlException {
        roleName = roleName.toLowerCase();
        adminGrantor = SQLAuthorizationUtils.getValidatedPrincipal(adminGrantor);
        this.hiveAccessController.createRole(roleName, adminGrantor);
    }

    @Override
    public void dropRole(String roleName) throws HiveAuthzPluginException, HiveAccessControlException {
        roleName = roleName.toLowerCase();
        this.hiveAccessController.dropRole(roleName);
    }

    @Override
    public void grantRole(List<HivePrincipal> hivePrincipals, List<String> roles, boolean grantOption, HivePrincipal grantorPrinc) throws HiveAuthzPluginException, HiveAccessControlException {
        hivePrincipals = SQLAuthorizationUtils.getValidatedPrincipals(hivePrincipals);
        roles = this.getLowerCaseRoleNames(roles);
        grantorPrinc = SQLAuthorizationUtils.getValidatedPrincipal(grantorPrinc);
        this.hiveAccessController.grantRole(hivePrincipals, roles, grantOption, grantorPrinc);
    }

    @Override
    public void revokeRole(List<HivePrincipal> hivePrincipals, List<String> roles, boolean grantOption, HivePrincipal grantorPrinc) throws HiveAuthzPluginException, HiveAccessControlException {
        hivePrincipals = SQLAuthorizationUtils.getValidatedPrincipals(hivePrincipals);
        roles = this.getLowerCaseRoleNames(roles);
        grantorPrinc = SQLAuthorizationUtils.getValidatedPrincipal(grantorPrinc);
        this.hiveAccessController.revokeRole(hivePrincipals, roles, grantOption, grantorPrinc);
    }

    @Override
    public List<String> getAllRoles() throws HiveAuthzPluginException, HiveAccessControlException {
        return this.hiveAccessController.getAllRoles();
    }

    @Override
    public List<HivePrivilegeInfo> showPrivileges(HivePrincipal principal, HivePrivilegeObject privObj) throws HiveAuthzPluginException, HiveAccessControlException {
        principal = SQLAuthorizationUtils.getValidatedPrincipal(principal);
        return this.hiveAccessController.showPrivileges(principal, privObj);
    }

    @Override
    public void setCurrentRole(String roleName) throws HiveAuthzPluginException, HiveAccessControlException {
        roleName = roleName.toLowerCase();
        this.hiveAccessController.setCurrentRole(roleName);
    }

    @Override
    public List<String> getCurrentRoleNames() throws HiveAuthzPluginException {
        return this.hiveAccessController.getCurrentRoleNames();
    }

    @Override
    public List<HiveRoleGrant> getPrincipalGrantInfoForRole(String roleName) throws HiveAuthzPluginException, HiveAccessControlException {
        roleName = roleName.toLowerCase();
        return this.hiveAccessController.getPrincipalGrantInfoForRole(roleName);
    }

    @Override
    public List<HiveRoleGrant> getRoleGrantInfoForPrincipal(HivePrincipal principal) throws HiveAuthzPluginException, HiveAccessControlException {
        principal = SQLAuthorizationUtils.getValidatedPrincipal(principal);
        return this.hiveAccessController.getRoleGrantInfoForPrincipal(principal);
    }

    @Override
    public void applyAuthorizationConfigPolicy(HiveConf hiveConf) throws HiveAuthzPluginException {
        this.hiveAccessController.applyAuthorizationConfigPolicy(hiveConf);
    }

    public boolean isUserAdmin() throws HiveAuthzPluginException {
        return this.hiveAccessController.isUserAdmin();
    }

    private List<String> getLowerCaseRoleNames(List<String> roles) {
        ListIterator<String> roleIter = roles.listIterator();
        while (roleIter.hasNext()) {
            roleIter.set(roleIter.next().toLowerCase());
        }
        return roles;
    }
}

