/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.sketch;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.spark.util.sketch.BitArray;
import org.apache.spark.util.sketch.BloomFilter;
import org.apache.spark.util.sketch.BloomFilterBase;
import org.apache.spark.util.sketch.IncompatibleMergeException;

class BloomFilterImpl
extends BloomFilterBase
implements Serializable {
    BloomFilterImpl(int numHashFunctions, long numBits) {
        super(numHashFunctions, numBits);
    }

    private BloomFilterImpl() {
    }

    @Override
    protected boolean scatterHashAndSetAllBits(BloomFilterBase.HiLoHash inputHash) {
        int h1 = inputHash.hi();
        int h2 = inputHash.lo();
        long bitSize = this.bits.bitSize();
        boolean bitsChanged = false;
        for (int i = 1; i <= this.numHashFunctions; ++i) {
            int combinedHash = h1 + i * h2;
            if (combinedHash < 0) {
                combinedHash ^= 0xFFFFFFFF;
            }
            bitsChanged |= this.bits.set((long)combinedHash % bitSize);
        }
        return bitsChanged;
    }

    @Override
    protected boolean scatterHashAndGetAllBits(BloomFilterBase.HiLoHash inputHash) {
        int h1 = inputHash.hi();
        int h2 = inputHash.lo();
        long bitSize = this.bits.bitSize();
        for (int i = 1; i <= this.numHashFunctions; ++i) {
            int combinedHash = h1 + i * h2;
            if (combinedHash < 0) {
                combinedHash ^= 0xFFFFFFFF;
            }
            if (this.bits.get((long)combinedHash % bitSize)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected BloomFilterImpl checkCompatibilityForMerge(BloomFilter other) throws IncompatibleMergeException {
        if (other == null) {
            throw new IncompatibleMergeException("Cannot merge null bloom filter");
        }
        if (!(other instanceof BloomFilterImpl)) {
            throw new IncompatibleMergeException("Cannot merge bloom filter of class " + other.getClass().getName());
        }
        BloomFilterImpl that = (BloomFilterImpl)other;
        if (this.bitSize() != that.bitSize()) {
            throw new IncompatibleMergeException("Cannot merge bloom filters with different bit size");
        }
        if (this.numHashFunctions != that.numHashFunctions) {
            throw new IncompatibleMergeException("Cannot merge bloom filters with different number of hash functions");
        }
        return that;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        DataOutputStream dos = new DataOutputStream(out);
        dos.writeInt(BloomFilter.Version.V1.getVersionNumber());
        dos.writeInt(this.numHashFunctions);
        this.bits.writeTo(dos);
    }

    private void readFrom0(InputStream in) throws IOException {
        DataInputStream dis = new DataInputStream(in);
        int version = dis.readInt();
        if (version != BloomFilter.Version.V1.getVersionNumber()) {
            throw new IOException("Unexpected Bloom filter version number (" + version + ")");
        }
        this.numHashFunctions = dis.readInt();
        this.seed = 0;
        this.bits = BitArray.readFrom(dis);
    }

    public static BloomFilterImpl readFrom(InputStream in) throws IOException {
        BloomFilterImpl filter = new BloomFilterImpl();
        filter.readFrom0(in);
        return filter;
    }

    @Deprecated
    public static BloomFilter readFrom(byte[] bytes) throws IOException {
        return BloomFilter.readFrom(bytes);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.writeTo(out);
    }

    private void readObject(ObjectInputStream in) throws IOException {
        this.readFrom0(in);
    }
}

