/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.types.variant;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.spark.types.variant.Variant;
import org.apache.spark.types.variant.VariantBuilder;
import org.apache.spark.types.variant.VariantSchema;
import org.apache.spark.types.variant.VariantUtil;

public class ShreddingUtils {
    public static Variant rebuild(ShreddedRow row, VariantSchema schema) {
        if (schema.topLevelMetadataIdx < 0 || row.isNullAt(schema.topLevelMetadataIdx)) {
            throw VariantUtil.malformedVariant();
        }
        byte[] metadata = row.getBinary(schema.topLevelMetadataIdx);
        if (schema.isUnshredded()) {
            if (row.isNullAt(schema.variantIdx)) {
                throw VariantUtil.malformedVariant();
            }
            return new Variant(row.getBinary(schema.variantIdx), metadata);
        }
        VariantBuilder builder = new VariantBuilder(false);
        ShreddingUtils.rebuild(row, metadata, schema, builder);
        return builder.result();
    }

    public static void rebuild(ShreddedRow row, byte[] metadata, VariantSchema schema, VariantBuilder builder) {
        int typedIdx = schema.typedIdx;
        int variantIdx = schema.variantIdx;
        if (typedIdx >= 0 && !row.isNullAt(typedIdx)) {
            if (schema.scalarSchema != null) {
                VariantSchema.ScalarType scalar = schema.scalarSchema;
                if (scalar instanceof VariantSchema.StringType) {
                    builder.appendString(row.getString(typedIdx));
                } else if (scalar instanceof VariantSchema.IntegralType) {
                    VariantSchema.IntegralType it = (VariantSchema.IntegralType)scalar;
                    long value = 0L;
                    switch (it.size) {
                        case BYTE: {
                            value = row.getByte(typedIdx);
                            break;
                        }
                        case SHORT: {
                            value = row.getShort(typedIdx);
                            break;
                        }
                        case INT: {
                            value = row.getInt(typedIdx);
                            break;
                        }
                        case LONG: {
                            value = row.getLong(typedIdx);
                        }
                    }
                    builder.appendLong(value);
                } else if (scalar instanceof VariantSchema.FloatType) {
                    builder.appendFloat(row.getFloat(typedIdx));
                } else if (scalar instanceof VariantSchema.DoubleType) {
                    builder.appendDouble(row.getDouble(typedIdx));
                } else if (scalar instanceof VariantSchema.BooleanType) {
                    builder.appendBoolean(row.getBoolean(typedIdx));
                } else if (scalar instanceof VariantSchema.BinaryType) {
                    builder.appendBinary(row.getBinary(typedIdx));
                } else if (scalar instanceof VariantSchema.UuidType) {
                    builder.appendUuid(row.getUuid(typedIdx));
                } else if (scalar instanceof VariantSchema.DecimalType) {
                    VariantSchema.DecimalType dt = (VariantSchema.DecimalType)scalar;
                    builder.appendDecimal(row.getDecimal(typedIdx, dt.precision, dt.scale));
                } else if (scalar instanceof VariantSchema.DateType) {
                    builder.appendDate(row.getInt(typedIdx));
                } else if (scalar instanceof VariantSchema.TimestampType) {
                    builder.appendTimestamp(row.getLong(typedIdx));
                } else {
                    assert (scalar instanceof VariantSchema.TimestampNTZType);
                    builder.appendTimestampNtz(row.getLong(typedIdx));
                }
            } else if (schema.arraySchema != null) {
                VariantSchema elementSchema = schema.arraySchema;
                ShreddedRow array = row.getArray(typedIdx);
                int start = builder.getWritePos();
                ArrayList<Integer> offsets = new ArrayList<Integer>(array.numElements());
                for (int i = 0; i < array.numElements(); ++i) {
                    offsets.add(builder.getWritePos() - start);
                    ShreddingUtils.rebuild(array.getStruct(i, elementSchema.numFields), metadata, elementSchema, builder);
                }
                builder.finishWritingArray(start, offsets);
            } else {
                ShreddedRow object = row.getStruct(typedIdx, schema.objectSchema.length);
                ArrayList<VariantBuilder.FieldEntry> fields = new ArrayList<VariantBuilder.FieldEntry>();
                int start = builder.getWritePos();
                for (int fieldIdx = 0; fieldIdx < schema.objectSchema.length; ++fieldIdx) {
                    if (object.isNullAt(fieldIdx)) {
                        throw VariantUtil.malformedVariant();
                    }
                    String fieldName = schema.objectSchema[fieldIdx].fieldName;
                    VariantSchema fieldSchema = schema.objectSchema[fieldIdx].schema;
                    ShreddedRow fieldValue = object.getStruct(fieldIdx, fieldSchema.numFields);
                    if ((fieldSchema.typedIdx < 0 || fieldValue.isNullAt(fieldSchema.typedIdx)) && (fieldSchema.variantIdx < 0 || fieldValue.isNullAt(fieldSchema.variantIdx))) continue;
                    int id = builder.addKey(fieldName);
                    fields.add(new VariantBuilder.FieldEntry(fieldName, id, builder.getWritePos() - start));
                    ShreddingUtils.rebuild(fieldValue, metadata, fieldSchema, builder);
                }
                if (variantIdx >= 0 && !row.isNullAt(variantIdx)) {
                    Variant v = new Variant(row.getBinary(variantIdx), metadata);
                    if (v.getType() != VariantUtil.Type.OBJECT) {
                        throw VariantUtil.malformedVariant();
                    }
                    for (int i = 0; i < v.objectSize(); ++i) {
                        Variant.ObjectField field = v.getFieldAtIndex(i);
                        if (schema.objectSchemaMap.containsKey(field.key)) {
                            throw VariantUtil.malformedVariant();
                        }
                        int id = builder.addKey(field.key);
                        fields.add(new VariantBuilder.FieldEntry(field.key, id, builder.getWritePos() - start));
                        builder.appendVariant(field.value);
                    }
                }
                builder.finishWritingObject(start, fields);
            }
        } else if (variantIdx >= 0 && !row.isNullAt(variantIdx)) {
            builder.appendVariant(new Variant(row.getBinary(variantIdx), metadata));
        } else {
            throw VariantUtil.malformedVariant();
        }
    }

    public static interface ShreddedRow {
        public boolean isNullAt(int var1);

        public boolean getBoolean(int var1);

        public byte getByte(int var1);

        public short getShort(int var1);

        public int getInt(int var1);

        public long getLong(int var1);

        public float getFloat(int var1);

        public double getDouble(int var1);

        public BigDecimal getDecimal(int var1, int var2, int var3);

        public String getString(int var1);

        public byte[] getBinary(int var1);

        public UUID getUuid(int var1);

        public ShreddedRow getStruct(int var1, int var2);

        public ShreddedRow getArray(int var1);

        public int numElements();
    }
}

