/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.classification.LogisticRegressionModel;
import org.apache.spark.mllib.classification.LogisticRegressionModel$;
import org.apache.spark.mllib.classification.LogisticRegressionWithLBFGS;
import org.apache.spark.mllib.evaluation.MulticlassMetrics;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ClassTag$;

public final class LogisticRegressionWithLBFGSExample$ {
    public static final LogisticRegressionWithLBFGSExample$ MODULE$ = new LogisticRegressionWithLBFGSExample$();

    public void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("LogisticRegressionWithLBFGSExample");
        SparkContext sc = new SparkContext(conf);
        RDD data = MLUtils$.MODULE$.loadLibSVMFile(sc, "data/mllib/sample_libsvm_data.txt");
        RDD[] splits = data.randomSplit(new double[]{0.6, 0.4}, 11L);
        RDD training = splits[0].cache();
        RDD test = splits[1];
        LogisticRegressionModel model = new LogisticRegressionWithLBFGS().setNumClasses(10).run(training);
        RDD predictionAndLabels = test.map((Function1 & Serializable)x0$1 -> {
            LabeledPoint labeledPoint = x0$1;
            if (labeledPoint != null) {
                double label = labeledPoint.label();
                Vector features = labeledPoint.features();
                double prediction = model.predict(features);
                return new Tuple2.mcDD.sp(prediction, label);
            }
            throw new MatchError((Object)labeledPoint);
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        MulticlassMetrics metrics = new MulticlassMetrics(predictionAndLabels);
        double accuracy = metrics.accuracy();
        Predef$.MODULE$.println((Object)("Accuracy = " + accuracy));
        model.save(sc, "target/tmp/scalaLogisticRegressionWithLBFGSModel");
        LogisticRegressionModel sameModel = LogisticRegressionModel$.MODULE$.load(sc, "target/tmp/scalaLogisticRegressionWithLBFGSModel");
        sc.stop();
    }

    private LogisticRegressionWithLBFGSExample$() {
    }
}

