/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples;

import java.io.File;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DFSReadWriteTest$ {
    public static final DFSReadWriteTest$ MODULE$ = new DFSReadWriteTest$();
    private static File localFilePath = new File(".");
    private static String dfsDirPath = "";
    private static final int NPARAMS = 2;

    private File localFilePath() {
        return localFilePath;
    }

    private void localFilePath_$eq(File x$1) {
        localFilePath = x$1;
    }

    private String dfsDirPath() {
        return dfsDirPath;
    }

    private void dfsDirPath_$eq(String x$1) {
        dfsDirPath = x$1;
    }

    private int NPARAMS() {
        return NPARAMS;
    }

    private List<String> readFile(String filename) {
        return (List)Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> Source$.MODULE$.fromFile(filename, Codec$.MODULE$.fallbackSystemCodec()), (Function1 & Serializable)x$1 -> x$1.getLines().toList());
    }

    private void printUsage() {
        String usage = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("DFS Read-Write Test\n    |Usage: localFile dfsDir\n    |localFile - (string) local file to use in test\n    |dfsDir - (string) DFS directory for read/write tests"));
        Predef$.MODULE$.println((Object)usage);
    }

    private void parseArgs(String[] args) {
        if (args.length != this.NPARAMS()) {
            this.printUsage();
            System.exit(1);
        }
        int i = 0;
        this.localFilePath_$eq(new File(args[i]));
        if (!this.localFilePath().exists()) {
            System.err.println("Given path (" + args[i] + ") does not exist");
            this.printUsage();
            System.exit(1);
        }
        if (!this.localFilePath().isFile()) {
            System.err.println("Given path (" + args[i] + ") is not a file");
            this.printUsage();
            System.exit(1);
        }
        this.dfsDirPath_$eq(args[++i]);
    }

    public int runLocalWordCount(List<String> fileContents) {
        return BoxesRunTime.unboxToInt((Object)fileContents.flatMap((Function1 & Serializable)x$2 -> Predef$.MODULE$.wrapRefArray((Object[])x$2.split(" "))).flatMap((Function1 & Serializable)x$3 -> Predef$.MODULE$.wrapRefArray((Object[])x$3.split("\t"))).filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$4)))).groupBy((Function1 & Serializable)w -> w).transform((Function2 & Serializable)(x$5, v) -> BoxesRunTime.boxToInteger((int)v.size())).values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public void main(String[] args) {
        this.parseArgs(args);
        Predef$.MODULE$.println((Object)"Performing local word count");
        List<String> fileContents = this.readFile(this.localFilePath().toString());
        int localWordCount = this.runLocalWordCount(fileContents);
        Predef$.MODULE$.println((Object)"Creating SparkSession");
        SparkSession spark = SparkSession$.MODULE$.builder().appName("DFS Read Write Test").getOrCreate();
        Predef$.MODULE$.println((Object)"Writing local file to DFS");
        String dfsFilename = this.dfsDirPath() + "/dfs_read_write_test";
        FileSystem fs = FileSystem.get((Configuration)spark.sessionState().newHadoopConf());
        Object object = fs.exists(new Path(dfsFilename)) ? BoxesRunTime.boxToBoolean((boolean)fs.delete(new Path(dfsFilename), true)) : BoxedUnit.UNIT;
        SparkContext qual$1 = spark.sparkContext();
        List<String> x$1 = fileContents;
        int x$2 = qual$1.parallelize$default$2();
        RDD fileRDD = qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(String.class));
        fileRDD.saveAsTextFile(dfsFilename);
        Predef$.MODULE$.println((Object)"Reading file from DFS and running Word Count");
        SparkContext qual$2 = spark.sparkContext();
        String x$3 = dfsFilename;
        int x$4 = qual$2.textFile$default$2();
        RDD readFileRDD = qual$2.textFile(x$3, x$4);
        long dfsWordCount = BoxesRunTime.unboxToLong((Object)RDD$.MODULE$.rddToPairRDDFunctions(readFileRDD.flatMap((Function1 & Serializable)x$6 -> Predef$.MODULE$.wrapRefArray((Object[])x$6.split(" ")), ClassTag$.MODULE$.apply(String.class)).flatMap((Function1 & Serializable)x$7 -> Predef$.MODULE$.wrapRefArray((Object[])x$7.split("\t")), ClassTag$.MODULE$.apply(String.class)).filter((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$8)))).map((Function1 & Serializable)w -> new Tuple2(w, (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), (ClassTag)ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).countByKey().values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        spark.stop();
        if ((long)localWordCount == dfsWordCount) {
            Predef$.MODULE$.println((Object)("Success! Local Word Count " + localWordCount + " and DFS Word Count " + dfsWordCount + " agree."));
            return;
        }
        Predef$.MODULE$.println((Object)("Failure! Local Word Count " + localWordCount + " and DFS Word Count " + dfsWordCount + " disagree."));
    }

    private DFSReadWriteTest$() {
    }
}

