/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.UnresolvedSeed$;
import org.apache.spark.sql.catalyst.expressions.Add$;
import org.apache.spark.sql.catalyst.expressions.EvalMode$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NondeterministicUnaryRDG;
import org.apache.spark.sql.catalyst.expressions.Randn$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.util.random.XORShiftRandom;
import scala.Option;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_([seed]) - Returns a random value with independent and identically distributed (i.i.d.) values drawn from the standard normal distribution.", examples="\n    Examples:\n      > SELECT _FUNC_();\n       -0.3254147983080288\n      > SELECT _FUNC_(0);\n       1.6034991609278433\n      > SELECT _FUNC_(null);\n       1.6034991609278433\n  ", note="\n    The function is non-deterministic in general case.\n  ", since="1.5.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0005\t\u0005a\u0001\u0002\u0012$\u0001BB\u0001b\u0012\u0001\u0003\u0016\u0004%\t\u0001\u0013\u0005\t\u0019\u0002\u0011\t\u0012)A\u0005\u0013\"AQ\n\u0001BK\u0002\u0013\u0005a\n\u0003\u0005S\u0001\tE\t\u0015!\u0003P\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0011\u0015\u0019\u0006\u0001\"\u0001Y\u0011\u0015\u0019\u0006\u0001\"\u0001Z\u0011\u0015Y\u0006\u0001\"\u0011]\u0011\u0015\u0011\u0007\u0001\"\u0011d\u0011\u00151\u0007\u0001\"\u0015h\u0011\u0015\t\b\u0001\"\u0011s\u0011\u001d\t\t\u0001\u0001C!\u0003\u0007Aa\u0001\u000b\u0001\u0005B\u0005E\u0001bBA\u0012\u0001\u0011E\u0013Q\u0005\u0005\n\u0003W\u0001\u0011\u0011!C\u0001\u0003[A\u0011\"a\r\u0001#\u0003%\t!!\u000e\t\u0013\u0005-\u0003!%A\u0005\u0002\u00055\u0003\"CA)\u0001\u0005\u0005I\u0011IA*\u0011%\t\u0019\u0007AA\u0001\n\u0003\t)\u0007C\u0005\u0002n\u0001\t\t\u0011\"\u0001\u0002p!I\u0011Q\u000f\u0001\u0002\u0002\u0013\u0005\u0013q\u000f\u0005\n\u0003\u0007\u0003\u0011\u0011!C\u0001\u0003\u000bC\u0011\"!#\u0001\u0003\u0003%\t%a#\t\u0013\u0005=\u0005!!A\u0005B\u0005EuaBA^G!\u0005\u0011Q\u0018\u0004\u0007E\rB\t!a0\t\rMSB\u0011AAi\u0011\u001d\t\u0019N\u0007C\u0001\u0003+D\u0011\"a5\u001b\u0003\u0003%\t)!7\t\u0013\u0005}'$%A\u0005\u0002\u00055\u0003\"CAq5\u0005\u0005I\u0011QAr\u0011%\t)PGI\u0001\n\u0003\ti\u0005C\u0005\u0002xj\t\t\u0011\"\u0003\u0002z\n)!+\u00198e]*\u0011A%J\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002'O\u0005A1-\u0019;bYf\u001cHO\u0003\u0002)S\u0005\u00191/\u001d7\u000b\u0005)Z\u0013!B:qCJ\\'B\u0001\u0017.\u0003\u0019\t\u0007/Y2iK*\ta&A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001cUZ\u0004C\u0001\u001a4\u001b\u0005\u0019\u0013B\u0001\u001b$\u0005aquN\u001c3fi\u0016\u0014X.\u001b8jgRL7-\u00168bef\u0014Fi\u0012\t\u0003mej\u0011a\u000e\u0006\u0002q\u0005)1oY1mC&\u0011!h\u000e\u0002\b!J|G-^2u!\taDI\u0004\u0002>\u0005:\u0011a(Q\u0007\u0002\u007f)\u0011\u0001iL\u0001\u0007yI|w\u000e\u001e \n\u0003aJ!aQ\u001c\u0002\u000fA\f7m[1hK&\u0011QI\u0012\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003\u0007^\nQa\u00195jY\u0012,\u0012!\u0013\t\u0003e)K!aS\u0012\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0004dQ&dG\rI\u0001\tQ&$WmU3fIV\tq\n\u0005\u00027!&\u0011\u0011k\u000e\u0002\b\u0005>|G.Z1o\u0003%A\u0017\u000eZ3TK\u0016$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0004+Z;\u0006C\u0001\u001a\u0001\u0011\u00159U\u00011\u0001J\u0011\u001diU\u0001%AA\u0002=#\u0012!\u0016\u000b\u0003+jCQaR\u0004A\u0002%\u000b1b^5uQ:+woU3fIR\u0011Q+\u0018\u0005\u0006=\"\u0001\raX\u0001\u0005g\u0016,G\r\u0005\u00027A&\u0011\u0011m\u000e\u0002\u0005\u0019>tw-A\bxSRD7\u000b[5gi\u0016$7+Z3e)\t)F\rC\u0003f\u0013\u0001\u0007q,A\u0003tQ&4G/\u0001\u0007fm\u0006d\u0017J\u001c;fe:\fG\u000e\u0006\u0002iWB\u0011a'[\u0005\u0003U^\u0012a\u0001R8vE2,\u0007\"\u00027\u000b\u0001\u0004i\u0017!B5oaV$\bC\u00018p\u001b\u0005)\u0013B\u00019&\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u0013\u0011|w)\u001a8D_\u0012,GcA:z}B\u0011Ao^\u0007\u0002k*\u0011aoI\u0001\bG>$WmZ3o\u0013\tAXO\u0001\u0005FqB\u00148i\u001c3f\u0011\u0015Q8\u00021\u0001|\u0003\r\u0019G\u000f\u001f\t\u0003irL!!`;\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\")qp\u0003a\u0001g\u0006\u0011QM^\u0001\u000eM2\fG/\u0011:hk6,g\u000e^:\u0016\u0005\u0005\u0015\u0001#\u0002\u001f\u0002\b\u0005-\u0011bAA\u0005\r\nA\u0011\n^3sCR|'\u000fE\u00027\u0003\u001bI1!a\u00048\u0005\r\te._\u000b\u0003\u0003'\u0001B!!\u0006\u0002\u001e9!\u0011qCA\r!\tqt'C\u0002\u0002\u001c]\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0010\u0003C\u0011aa\u0015;sS:<'bAA\u000eo\u0005!r/\u001b;i\u001d\u0016<8\t[5mI&sG/\u001a:oC2$2!VA\u0014\u0011\u0019\tIC\u0004a\u0001\u0013\u0006Aa.Z<DQ&dG-\u0001\u0003d_BLH#B+\u00020\u0005E\u0002bB$\u0010!\u0003\u0005\r!\u0013\u0005\b\u001b>\u0001\n\u00111\u0001P\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u000e+\u0007%\u000bId\u000b\u0002\u0002<A!\u0011QHA$\u001b\t\tyD\u0003\u0003\u0002B\u0005\r\u0013!C;oG\",7m[3e\u0015\r\t)eN\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA%\u0003\u007f\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a\u0014+\u0007=\u000bI$A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003+\u0002B!a\u0016\u0002b5\u0011\u0011\u0011\f\u0006\u0005\u00037\ni&\u0001\u0003mC:<'BAA0\u0003\u0011Q\u0017M^1\n\t\u0005}\u0011\u0011L\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003O\u00022ANA5\u0013\r\tYg\u000e\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u0017\t\t\bC\u0005\u0002tQ\t\t\u00111\u0001\u0002h\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u001f\u0011\r\u0005m\u0014\u0011QA\u0006\u001b\t\tiHC\u0002\u0002\u0000]\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI!! \u0002\u0011\r\fg.R9vC2$2aTAD\u0011%\t\u0019HFA\u0001\u0002\u0004\tY!\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA+\u0003\u001bC\u0011\"a\u001d\u0018\u0003\u0003\u0005\r!a\u001a\u0002\r\u0015\fX/\u00197t)\ry\u00151\u0013\u0005\n\u0003gB\u0012\u0011!a\u0001\u0003\u0017As\u0003AAL\u0003;\u000by*a)\u0002&\u0006%\u00161VAX\u0003c\u000b),a.\u0011\u0007I\nI*C\u0002\u0002\u001c\u000e\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002\"\u0006\t\u0019c\u0018$V\u001d\u000e{\u0006fW:fK\u0012l\u0016\u0006I\u0017!%\u0016$XO\u001d8tA\u0005\u0004#/\u00198e_6\u0004c/\u00197vK\u0002:\u0018\u000e\u001e5!S:$W\r]3oI\u0016tG\u000fI1oI\u0002JG-\u001a8uS\u000e\fG\u000e\\=!I&\u001cHO]5ckR,G\r\t\u0015j]%tCML\u0015!m\u0006dW/Z:!IJ\fwO\u001c\u0011ge>l\u0007\u0005\u001e5fAM$\u0018M\u001c3be\u0012\u0004cn\u001c:nC2\u0004C-[:ue&\u0014W\u000f^5p]:\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003O\u000b\u0011\u0011\r\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)SmR\u0001\u0005\t\u0011!A\u0001\u0002S\u0006\r\u00184eU\"\u0014\u0007N\u001c:qM\u0002\u0004\b\r\u001a9q)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0003'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!c92\u0004g\r\u001b:sE2\u0004'\u000f\u001a8qQ\u001a4G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015ok2d\u0017f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00112]Y\u00024\u0007N\u001d:cY\u0002\u0014HM\u001c9iM\u001a$\u0002\t\u0011\u0002\t9|G/Z\u0011\u0003\u0003[\u000b!H\u0003\u0011!A\u0001\"\u0006.\u001a\u0011gk:\u001cG/[8oA%\u001c\bE\\8o[\u0011,G/\u001a:nS:L7\u000f^5dA%t\u0007eZ3oKJ\fG\u000eI2bg\u0016t#\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005M\u0016!B\u0019/k9\u0002\u0014!B4s_V\u0004\u0018EAA]\u0003)i\u0017\r\u001e5`MVt7m]\u0001\u0006%\u0006tGM\u001c\t\u0003ei\u0019RAGAa\u0003\u000f\u00042ANAb\u0013\r\t)m\u000e\u0002\u0007\u0003:L(+\u001a4\u0011\t\u0005%\u0017qZ\u0007\u0003\u0003\u0017TA!!4\u0002^\u0005\u0011\u0011n\\\u0005\u0004\u000b\u0006-GCAA_\u0003\u0015\t\u0007\u000f\u001d7z)\r)\u0016q\u001b\u0005\u0006=r\u0001\ra\u0018\u000b\u0006+\u0006m\u0017Q\u001c\u0005\u0006\u000fv\u0001\r!\u0013\u0005\b\u001bv\u0001\n\u00111\u0001P\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u0012\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0003K\f\t\u0010E\u00037\u0003O\fY/C\u0002\u0002j^\u0012aa\u00149uS>t\u0007#\u0002\u001c\u0002n&{\u0015bAAxo\t1A+\u001e9mKJB\u0001\"a= \u0003\u0003\u0005\r!V\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002|B!\u0011qKA\u007f\u0013\u0011\ty0!\u0017\u0003\r=\u0013'.Z2u\u0001")
public class Randn
extends NondeterministicUnaryRDG
implements Serializable {
    private final Expression child;
    private final boolean hideSeed;

    public static boolean $lessinit$greater$default$2() {
        return Randn$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Object>> unapply(Randn x$0) {
        return Randn$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$2() {
        return Randn$.MODULE$.apply$default$2();
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public boolean hideSeed() {
        return this.hideSeed;
    }

    @Override
    public Randn withNewSeed(long seed) {
        return new Randn(new Literal(BoxesRunTime.boxToLong((long)seed), (DataType)LongType$.MODULE$), this.hideSeed());
    }

    @Override
    public Randn withShiftedSeed(long shift) {
        return new Randn(Add$.MODULE$.apply(this.child(), (Expression)Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)shift)), EvalMode$.MODULE$.LEGACY()), this.hideSeed());
    }

    public double evalInternal(InternalRow input) {
        return this.rng().nextGaussian();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String className = XORShiftRandom.class.getName();
        String rngTerm = ctx.addMutableState(className, "rng", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        ctx.addPartitionInitializationStatement(rngTerm + " = new " + className + "(" + this.seed() + "L + partitionIndex);");
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n      final ", " ", " = ", ".nextGaussian();"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), rngTerm})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child()}));
    }

    @Override
    public String sql() {
        return "randn(" + (this.hideSeed() ? "" : this.child().sql()) + ")";
    }

    @Override
    public Randn withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    public Randn copy(Expression child, boolean hideSeed) {
        return new Randn(child, hideSeed);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public boolean copy$default$2() {
        return this.hideSeed();
    }

    @Override
    public String productPrefix() {
        return "Randn";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return BoxesRunTime.boxToBoolean((boolean)this.hideSeed());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Randn;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "hideSeed";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Randn)) return false;
        boolean bl = true;
        if (!bl) return false;
        Randn randn = (Randn)x$1;
        if (this.hideSeed() != randn.hideSeed()) return false;
        Expression expression = this.child();
        Expression expression2 = randn.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!randn.canEqual(this)) return false;
        return true;
    }

    public Randn(Expression child, boolean hideSeed) {
        this.child = child;
        this.hideSeed = hideSeed;
    }

    public Randn() {
        this(UnresolvedSeed$.MODULE$, true);
    }

    public Randn(Expression child) {
        this(child, false);
    }
}

