/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.BinaryArithmetic;
import org.apache.spark.sql.catalyst.expressions.DivModLike;
import org.apache.spark.sql.catalyst.expressions.Divide$;
import org.apache.spark.sql.catalyst.expressions.EvalMode$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.NumericEvalContext;
import org.apache.spark.sql.catalyst.expressions.NumericEvalContext$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.types.PhysicalDecimalType$;
import org.apache.spark.sql.catalyst.types.PhysicalFractionalType$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$DecimalIsFractional$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FractionalType;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.math.Fractional;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Returns `expr1`/`expr2`. It always performs floating point division.", examples="\n    Examples:\n      > SELECT 3 _FUNC_ 2;\n       1.5\n      > SELECT 2L _FUNC_ 2L;\n       1.0\n  ", since="1.0.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0005\t\u0015b\u0001B\u0013'\u0001NB\u0001\"\u0014\u0001\u0003\u0016\u0004%\tA\u0014\u0005\t%\u0002\u0011\t\u0012)A\u0005\u001f\"A1\u000b\u0001BK\u0002\u0013\u0005a\n\u0003\u0005U\u0001\tE\t\u0015!\u0003P\u0011!)\u0006A!f\u0001\n\u00031\u0006\u0002\u0003.\u0001\u0005#\u0005\u000b\u0011B,\t\u000bm\u0003A\u0011\u0001/\t\u000bm\u0003A\u0011A1\t\u000b\u0011\u0004A\u0011K3\t\u000b%\u0004A\u0011\t6\t\u000bE\u0004A\u0011\t:\t\u000bm\u0004A\u0011\t:\t\u000bq\u0004A\u0011I?\t\u0015\u0005e\u0001\u0001#b\u0001\n\u0013\tY\u0002C\u0004\u0002*\u0001!\t%a\u000b\t\u000f\u0005E\u0002\u0001\"\u0015\u00024!I\u0011Q\b\u0001\u0002\u0002\u0013\u0005\u0011q\b\u0005\n\u0003\u000f\u0002\u0011\u0013!C\u0001\u0003\u0013B\u0011\"a\u0018\u0001#\u0003%\t!!\u0013\t\u0013\u0005\u0005\u0004!%A\u0005\u0002\u0005\r\u0004\"CA4\u0001\u0005\u0005I\u0011IA5\u0011%\tI\bAA\u0001\n\u0003\tY\bC\u0005\u0002~\u0001\t\t\u0011\"\u0001\u0002\u0000!I\u0011Q\u0011\u0001\u0002\u0002\u0013\u0005\u0013q\u0011\u0005\n\u0003+\u0003\u0011\u0011!C\u0001\u0003/C\u0011\"a'\u0001\u0003\u0003%\t%!(\t\u0013\u0005\u0005\u0006!!A\u0005B\u0005\rvaBAdM!\u0005\u0011\u0011\u001a\u0004\u0007K\u0019B\t!a3\t\rmkB\u0011AAo\u0011\u001d\ty.\bC\u0001\u0003CD\u0011\"a8\u001e\u0003\u0003%\t)a?\t\u0013\t\rQ$%A\u0005\u0002\u0005\r\u0004\"\u0003B\u0003;\u0005\u0005I\u0011\u0011B\u0004\u0011%\u0011I\"HI\u0001\n\u0003\t\u0019\u0007C\u0005\u0003\u001cu\t\t\u0011\"\u0003\u0003\u001e\t1A)\u001b<jI\u0016T!a\n\u0015\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003S)\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003W1\n1a]9m\u0015\tic&A\u0003ta\u0006\u00148N\u0003\u00020a\u00051\u0011\r]1dQ\u0016T\u0011!M\u0001\u0004_J<7\u0001A\n\u0006\u0001QB4(\u0011\t\u0003kYj\u0011AJ\u0005\u0003o\u0019\u0012\u0001CQ5oCJL\u0018I]5uQ6,G/[2\u0011\u0005UJ\u0014B\u0001\u001e'\u0005)!\u0015N^'pI2K7.\u001a\t\u0003y}j\u0011!\u0010\u0006\u0002}\u0005)1oY1mC&\u0011\u0001)\u0010\u0002\b!J|G-^2u!\t\u0011%J\u0004\u0002D\u0011:\u0011AiR\u0007\u0002\u000b*\u0011aIM\u0001\u0007yI|w\u000e\u001e \n\u0003yJ!!S\u001f\u0002\u000fA\f7m[1hK&\u00111\n\u0014\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003\u0013v\nA\u0001\\3giV\tq\n\u0005\u00026!&\u0011\u0011K\n\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017!\u00027fMR\u0004\u0013!\u0002:jO\"$\u0018A\u0002:jO\"$\b%A\u0006fm\u0006d7i\u001c8uKb$X#A,\u0011\u0005UB\u0016BA-'\u0005IqU/\\3sS\u000e,e/\u00197D_:$X\r\u001f;\u0002\u0019\u00154\u0018\r\\\"p]R,\u0007\u0010\u001e\u0011\u0002\rqJg.\u001b;?)\u0011ifl\u00181\u0011\u0005U\u0002\u0001\"B'\b\u0001\u0004y\u0005\"B*\b\u0001\u0004y\u0005bB+\b!\u0003\u0005\ra\u0016\u000b\u0004;\n\u001c\u0007\"B'\t\u0001\u0004y\u0005\"B*\t\u0001\u0004y\u0015a\u00034bS2|e.\u0012:s_J,\u0012A\u001a\t\u0003y\u001dL!\u0001[\u001f\u0003\u000f\t{w\u000e\\3b]\u0006I\u0011N\u001c9viRK\b/Z\u000b\u0002WB\u0011An\\\u0007\u0002[*\u0011aNK\u0001\u0006if\u0004Xm]\u0005\u0003a6\u0014\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\rMLXNY8m+\u0005\u0019\bC\u0001;y\u001d\t)h\u000f\u0005\u0002E{%\u0011q/P\u0001\u0007!J,G-\u001a4\n\u0005eT(AB*ue&twM\u0003\u0002x{\u0005iA-Z2j[\u0006dW*\u001a;i_\u0012\f\u0011C]3tk2$H)Z2j[\u0006dG+\u001f9f)%q\u00181AA\u0007\u0003#\t)\u0002\u0005\u0002m\u007f&\u0019\u0011\u0011A7\u0003\u0017\u0011+7-[7bYRK\b/\u001a\u0005\b\u0003\u000bi\u0001\u0019AA\u0004\u0003\t\u0001\u0018\u0007E\u0002=\u0003\u0013I1!a\u0003>\u0005\rIe\u000e\u001e\u0005\b\u0003\u001fi\u0001\u0019AA\u0004\u0003\t\u0019\u0018\u0007C\u0004\u0002\u00145\u0001\r!a\u0002\u0002\u0005A\u0014\u0004bBA\f\u001b\u0001\u0007\u0011qA\u0001\u0003gJ\n1\u0001Z5w+\t\ti\u0002E\u0005=\u0003?\t\u0019#a\t\u0002$%\u0019\u0011\u0011E\u001f\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004c\u0001\u001f\u0002&%\u0019\u0011qE\u001f\u0003\u0007\u0005s\u00170A\u0007fm\u0006dw\n]3sCRLwN\u001c\u000b\u0007\u0003G\ti#a\f\t\r5{\u0001\u0019AA\u0012\u0011\u0019\u0019v\u00021\u0001\u0002$\u00059r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0006;\u0006U\u0012\u0011\b\u0005\u0007\u0003o\u0001\u0002\u0019A(\u0002\u000f9,w\u000fT3gi\"1\u00111\b\tA\u0002=\u000b\u0001B\\3x%&<\u0007\u000e^\u0001\u0005G>\u0004\u0018\u0010F\u0004^\u0003\u0003\n\u0019%!\u0012\t\u000f5\u000b\u0002\u0013!a\u0001\u001f\"91+\u0005I\u0001\u0002\u0004y\u0005bB+\u0012!\u0003\u0005\raV\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tYEK\u0002P\u0003\u001bZ#!a\u0014\u0011\t\u0005E\u00131L\u0007\u0003\u0003'RA!!\u0016\u0002X\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00033j\u0014AC1o]>$\u0018\r^5p]&!\u0011QLA*\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!!\u001a+\u0007]\u000bi%A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003W\u0002B!!\u001c\u0002x5\u0011\u0011q\u000e\u0006\u0005\u0003c\n\u0019(\u0001\u0003mC:<'BAA;\u0003\u0011Q\u0017M^1\n\u0007e\fy'\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\b\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u0012\u0003\u0003C\u0011\"a!\u0018\u0003\u0003\u0005\r!a\u0002\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tI\t\u0005\u0004\u0002\f\u0006E\u00151E\u0007\u0003\u0003\u001bS1!a$>\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003'\u000biI\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGc\u00014\u0002\u001a\"I\u00111Q\r\u0002\u0002\u0003\u0007\u00111E\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002l\u0005}\u0005\"CAB5\u0005\u0005\t\u0019AA\u0004\u0003\u0019)\u0017/^1mgR\u0019a-!*\t\u0013\u0005\r5$!AA\u0002\u0005\r\u0002f\u0005\u0001\u0002*\u0006=\u0016\u0011WA[\u0003o\u000bY,!0\u0002B\u0006\r\u0007cA\u001b\u0002,&\u0019\u0011Q\u0016\u0014\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u00111W\u0001ZKb\u0004(/\r\u0011`\rVs5i\u0018\u0011fqB\u0014(\u0007I\u0017!%\u0016$XO\u001d8tA\u0001,\u0007\u0010\u001d:2A>\u0002W\r\u001f9se\u0001t\u0003%\u0013;!C2<\u0018-_:!a\u0016\u0014hm\u001c:ng\u00022Gn\\1uS:<\u0007\u0005]8j]R\u0004C-\u001b<jg&|gNL\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011\u0011X\u0001`\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\u001a\u0004e\u0018$V\u001d\u000e{\u0006EM\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!c9*$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000b\t\u001aMA}3UKT\"`AIb5H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u0019/a)\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002@\u0006)\u0011G\f\u0019/a\u0005)qM]8va\u0006\u0012\u0011QY\u0001\u000b[\u0006$\bn\u00184v]\u000e\u001c\u0018A\u0002#jm&$W\r\u0005\u00026;M)Q$!4\u0002TB\u0019A(a4\n\u0007\u0005EWH\u0001\u0004B]f\u0014VM\u001a\t\u0005\u0003+\fY.\u0004\u0002\u0002X*!\u0011\u0011\\A:\u0003\tIw.C\u0002L\u0003/$\"!!3\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000fu\u000b\u0019/!:\u0002h\")Qj\ba\u0001\u001f\")1k\ba\u0001\u001f\"9\u0011\u0011^\u0010A\u0002\u0005-\u0018\u0001C3wC2lu\u000eZ3\u0011\t\u00055\u00181\u001f\b\u0004k\u0005=\u0018bAAyM\u0005AQI^1m\u001b>$W-\u0003\u0003\u0002v\u0006](!\u0002,bYV,\u0017bAA}{\tYQI\\;nKJ\fG/[8o)\u001di\u0016Q`A\u0000\u0005\u0003AQ!\u0014\u0011A\u0002=CQa\u0015\u0011A\u0002=Cq!\u0016\u0011\u0011\u0002\u0003\u0007q+A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0003\u001d)h.\u00199qYf$BA!\u0003\u0003\u0016A)AHa\u0003\u0003\u0010%\u0019!QB\u001f\u0003\r=\u0003H/[8o!\u0019a$\u0011C(P/&\u0019!1C\u001f\u0003\rQ+\b\u000f\\34\u0011!\u00119BIA\u0001\u0002\u0004i\u0016a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"Aa\b\u0011\t\u00055$\u0011E\u0005\u0005\u0005G\tyG\u0001\u0004PE*,7\r\u001e")
public class Divide
extends BinaryArithmetic
implements DivModLike {
    private Function2<Object, Object, Object> div;
    private final Expression left;
    private final Expression right;
    private final NumericEvalContext evalContext;
    private Function1<Object, Object> org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero;
    private volatile byte bitmap$0;

    public static NumericEvalContext $lessinit$greater$default$3() {
        return Divide$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, NumericEvalContext>> unapply(Divide x$0) {
        return Divide$.MODULE$.unapply(x$0);
    }

    public static NumericEvalContext apply$default$3() {
        return Divide$.MODULE$.apply$default$3();
    }

    @Override
    public /* synthetic */ DataType org$apache$spark$sql$catalyst$expressions$DivModLike$$super$dataType() {
        return super.dataType();
    }

    @Override
    public String decimalToDataTypeCodeGen(String decimalResult) {
        return DivModLike.decimalToDataTypeCodeGen$(this, decimalResult);
    }

    @Override
    public boolean checkDivideOverflow() {
        return DivModLike.checkDivideOverflow$(this);
    }

    @Override
    public boolean nullable() {
        return DivModLike.nullable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return DivModLike.eval$(this, input);
    }

    @Override
    public String divideByZeroErrorCode(CodegenContext ctx) {
        return DivModLike.divideByZeroErrorCode$(this, ctx);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return DivModLike.doGenCode$(this, ctx, ev);
    }

    private Function1<Object, Object> org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero$lzycompute() {
        Divide divide = this;
        synchronized (divide) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero = DivModLike.org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero;
    }

    @Override
    public Function1<Object, Object> org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero$lzycompute();
        }
        return this.org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public NumericEvalContext evalContext() {
        return this.evalContext;
    }

    @Override
    public boolean failOnError() {
        Enumeration.Value value = this.evalMode();
        Enumeration.Value value2 = EvalMode$.MODULE$.ANSI();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    @Override
    public AbstractDataType inputType() {
        return TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, DecimalType$.MODULE$}));
    }

    @Override
    public String symbol() {
        return "/";
    }

    @Override
    public String decimalMethod() {
        return "$div";
    }

    @Override
    public DecimalType resultDecimalType(int p1, int s1, int p2, int s2) {
        int decDig;
        int intDig;
        block1: {
            if (this.allowPrecisionLoss()) {
                int intDig2 = p1 - s1 + s2;
                int scale = package$.MODULE$.max(DecimalType$.MODULE$.MINIMUM_ADJUSTED_SCALE(), s1 + p2 + 1);
                int prec = intDig2 + scale;
                return DecimalType$.MODULE$.adjustPrecisionScale(prec, scale);
            }
            intDig = package$.MODULE$.min(DecimalType$.MODULE$.MAX_SCALE(), p1 - s1 + s2);
            int diff = intDig + (decDig = package$.MODULE$.min(DecimalType$.MODULE$.MAX_SCALE(), package$.MODULE$.max(DecimalType$.MODULE$.MINIMUM_ADJUSTED_SCALE(), s1 + p2 + 1))) - DecimalType$.MODULE$.MAX_SCALE();
            if (diff <= 0) break block1;
            intDig = DecimalType$.MODULE$.MAX_SCALE() - (decDig -= diff / 2 + 1);
        }
        return DecimalType$.MODULE$.bounded(intDig + decDig, decDig);
    }

    private Function2<Object, Object, Object> div$lzycompute() {
        Divide divide = this;
        synchronized (divide) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Function2 & Serializable intersect;
                DecimalType decimalType;
                Option option;
                DataType dataType = this.dataType();
                if (dataType instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
                    int precision = ((Tuple2)option.get())._1$mcI$sp();
                    int scale = ((Tuple2)option.get())._2$mcI$sp();
                    Decimal$DecimalIsFractional$ fractional = PhysicalDecimalType$.MODULE$.apply(precision, scale).fractional();
                    intersect = (Function2 & Serializable)(l, r) -> {
                        Object value = fractional.div(l, r);
                        return this.checkDecimalOverflow((Decimal)value, precision, scale);
                    };
                } else if (dataType instanceof FractionalType) {
                    FractionalType fractionalType = (FractionalType)dataType;
                    Fractional<Object> fractional = PhysicalFractionalType$.MODULE$.fractional(fractionalType);
                    intersect = (Function2 & Serializable)(x, y) -> fractional.div(x, y);
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.div = intersect;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.div;
    }

    private Function2<Object, Object, Object> div() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.div$lzycompute();
        }
        return this.div;
    }

    @Override
    public Object evalOperation(Object left, Object right) {
        return this.div().apply(left, right);
    }

    @Override
    public Divide withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    public Divide copy(Expression left, Expression right, NumericEvalContext evalContext) {
        return new Divide(left, right, evalContext);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public NumericEvalContext copy$default$3() {
        return this.evalContext();
    }

    @Override
    public String productPrefix() {
        return "Divide";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
            case 2: {
                return this.evalContext();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Divide;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
            case 2: {
                return "evalContext";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Divide)) return false;
        boolean bl = true;
        if (!bl) return false;
        Divide divide = (Divide)x$1;
        Expression expression = this.left();
        Expression expression2 = divide.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = divide.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        NumericEvalContext numericEvalContext = this.evalContext();
        NumericEvalContext numericEvalContext2 = divide.evalContext();
        if (numericEvalContext == null) {
            if (numericEvalContext2 != null) {
                return false;
            }
        } else if (!((Object)numericEvalContext).equals(numericEvalContext2)) return false;
        if (!divide.canEqual(this)) return false;
        return true;
    }

    public Divide(Expression left, Expression right, NumericEvalContext evalContext) {
        this.left = left;
        this.right = right;
        this.evalContext = evalContext;
        DivModLike.$init$(this);
    }

    public Divide(Expression left, Expression right) {
        this(left, right, NumericEvalContext$.MODULE$.fromSQLConf(SQLConf$.MODULE$.get()));
    }
}

